/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.profile.drafter.commands;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.uml.profile.drafter.model.CreatedPapyrusProfileModel;
import org.eclipse.papyrus.uml.tools.model.UmlModel;
import org.eclipse.papyrus.uml.tools.model.UmlUtils;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.UMLFactory;

public class CreateProfileAndProfileResourceCommand {
    protected String profileName;
    protected URI resourceURI;
    protected ModelSet modelSet;
    protected Resource resultResource;
    protected Profile resultProfile;

    public CreateProfileAndProfileResourceCommand(String profileName, ModelSet modelSet) {
        this.profileName = profileName;
        this.modelSet = modelSet;
        this.resourceURI = this.getResourceURIFromProfileName(profileName);
    }

    public CreateProfileAndProfileResourceCommand(String profileName, URI resourceURI, ModelSet modelSet) {
        this.profileName = profileName;
        this.resourceURI = resourceURI;
        this.modelSet = modelSet;
    }

    public Resource getResultResource() {
        return this.resultResource;
    }

    public Profile getResultProfile() {
        return this.resultProfile;
    }

    private URI getResourceURIFromProfileName(String profileName) {
        URI baseURI = this.modelSet.getURIWithoutExtension().trimSegments(1);
        baseURI = baseURI.appendSegment(profileName).appendFileExtension("profile");
        return baseURI;
    }

    private boolean isResourceAlreadyExist() {
        return false;
    }

    public boolean canExecute() {
        return !this.isResourceAlreadyExist();
    }

    public void execute() {
        CreatedPapyrusProfileModel profileModel = new CreatedPapyrusProfileModel(this.modelSet, this.resourceURI, true);
        this.resultProfile = profileModel.getProfile();
        this.resultProfile.setName(this.profileName);
        this.resultResource = profileModel.getProfileResource();
    }

    private Profile createProfile() {
        this.resultProfile = UMLFactory.eINSTANCE.createProfile();
        this.resultProfile.setName(this.profileName);
        return this.resultProfile;
    }

    private Resource createResource() {
        this.resultResource = this.modelSet.createResource(this.resourceURI.appendFileExtension("uml"), null);
        UmlModel umlModel = UmlUtils.getUmlModel((ModelSet)this.modelSet);
        umlModel.handle(this.resultResource);
        return this.resultResource;
    }
}

