/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.databinding.custom;

import java.math.BigDecimal;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.databinding.custom.AbstractCustomStyleObservableValue;

public class CustomDoubleStyleObservableValue
extends AbstractCustomStyleObservableValue {
    private static final double DEFAULT_VALUE = 0.0;

    public CustomDoubleStyleObservableValue(View source, EditingDomain domain, String styleName) {
        super(source, domain, styleName, NotationPackage.eINSTANCE.getDoubleValueStyle(), (EStructuralFeature)NotationPackage.eINSTANCE.getDoubleValueStyle_DoubleValue());
    }

    public Object getValueType() {
        return EcorePackage.eINSTANCE.getEFloat();
    }

    @Override
    protected Object getDefaultValue() {
        return 0.0;
    }

    @Override
    protected Object doGetValue() {
        return super.doGetValue();
    }

    @Override
    public Command getCommand(Object value) {
        if (value instanceof Double) {
            return super.getCommand(value);
        }
        if (value instanceof Float) {
            BigDecimal number = new BigDecimal(((Float)value).floatValue());
            return super.getCommand(number.doubleValue());
        }
        throw new IllegalArgumentException(String.format("The value %s is not a valid Double Value", value == null ? "null" : value.toString()));
    }
}

