/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.customization.properties.generation.generators;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import org.eclipse.papyrus.customization.properties.generation.generators.IGenerator;
import org.eclipse.papyrus.customization.properties.generation.layout.ILayoutGenerator;
import org.eclipse.papyrus.infra.properties.contexts.Context;
import org.eclipse.papyrus.infra.properties.contexts.DataContextElement;
import org.eclipse.papyrus.infra.properties.contexts.DataContextRoot;
import org.eclipse.papyrus.infra.properties.contexts.Property;
import org.eclipse.papyrus.infra.properties.contexts.Section;
import org.eclipse.papyrus.infra.properties.contexts.Tab;
import org.eclipse.papyrus.infra.properties.contexts.View;
import org.eclipse.papyrus.infra.properties.contexts.util.ContextAnnotations;
import org.eclipse.papyrus.infra.properties.ui.PropertyEditor;
import org.eclipse.papyrus.infra.properties.ui.UiFactory;
import org.eclipse.papyrus.infra.properties.ui.ValueAttribute;
import org.eclipse.papyrus.infra.properties.ui.runtime.IConfigurationManager;
import org.eclipse.papyrus.infra.properties.ui.runtime.PropertiesRuntime;
import org.eclipse.papyrus.infra.tools.util.ClassLoaderHelper;

public class GeneratorHelper {
    private final IConfigurationManager configManager = PropertiesRuntime.getConfigurationManager();
    private final IGenerator generator;
    private final ILayoutGenerator layout;

    public GeneratorHelper(IGenerator generator, ILayoutGenerator layout) {
        this.generator = generator;
        this.layout = layout;
    }

    public List<Section> generateLayout(Context context, Tab tab, View view, BiPredicate<? super Property, ? super Integer> propertySelectionPredicate) {
        this.layout.setGenerator(this.generator);
        LinkedList<PropertyEditor> editors = new LinkedList<PropertyEditor>();
        ArrayList<Property> properties = new ArrayList<Property>();
        Set<DataContextElement> elements = this.getAllContextElements((Collection<DataContextElement>)view.getDatacontexts());
        for (DataContextElement element : elements) {
            for (Property property : element.getProperties()) {
                if (!propertySelectionPredicate.test((Property)property, (Integer)view.getElementMultiplicity())) continue;
                properties.add(property);
            }
        }
        Collection<DataContextRoot> dataContexts = this.getRoots(elements);
        ClassLoaderHelper.getURI(this.layout.getClass()).ifSuccess(uri -> dataContexts.forEach(dc -> ContextAnnotations.setLayoutGeneratorClassName((DataContextRoot)dc, (String)uri.toString())));
        ArrayList tmpProperties = new ArrayList(properties);
        for (Property p1 : tmpProperties) {
            properties.removeAll((Collection<?>)p1.getRedefinedProperties());
        }
        for (Property property : properties) {
            PropertyEditor editor = UiFactory.eINSTANCE.createPropertyEditor();
            editor.setProperty(property);
            editor.setWidgetType(this.configManager.getDefaultEditorType(property));
            editors.add(editor);
            ValueAttribute input = UiFactory.eINSTANCE.createValueAttribute();
            input.setName("input");
            input.setValue("{Binding}");
            editor.getAttributes().add((Object)input);
        }
        List<Section> generatedSections = this.layout.layoutElements(editors, view);
        tab.getSections().addAll(generatedSections);
        view.getSections().addAll(generatedSections);
        return generatedSections;
    }

    private Set<DataContextElement> getAllContextElements(Collection<DataContextElement> source) {
        HashSet<DataContextElement> result = new HashSet<DataContextElement>();
        for (DataContextElement element : source) {
            this.getAllContextElements(element, result);
        }
        return result;
    }

    private void getAllContextElements(DataContextElement source, Set<DataContextElement> result) {
        if (result.contains(source)) {
            return;
        }
        result.add(source);
        for (DataContextElement element : source.getSupertypes()) {
            this.getAllContextElements(element, result);
        }
    }

    private Collection<DataContextRoot> getRoots(Collection<? extends DataContextElement> elements) {
        return elements.stream().map(GeneratorHelper::getRoot).filter(Objects::nonNull).distinct().collect(Collectors.toList());
    }

    public static DataContextRoot getRoot(DataContextElement element) {
        DataContextRoot result = null;
        DataContextElement dc = element;
        while (dc != null && result == null) {
            if (dc instanceof DataContextRoot) {
                result = (DataContextRoot)dc;
            }
            dc = dc.getPackage();
        }
        return result;
    }
}

