/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.properties.widgets;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.AbstractEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.nebula.widgets.nattable.grid.layer.GridLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.papyrus.infra.emf.gmf.command.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.nattable.layerstack.BodyLayerStack;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.widgets.Activator;
import org.eclipse.papyrus.infra.widgets.messages.Messages;
import org.eclipse.papyrus.robotics.properties.widgets.LayoutUtil;
import org.eclipse.papyrus.uml.properties.widgets.NattablePropertyEditor;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public abstract class TableEditorPlus
extends NattablePropertyEditor
implements SelectionListener {
    public static String ICON_PATH = "platform:/plugin/org.eclipse.papyrus.infra.widgets/icons/";
    protected Button add;
    protected Button remove;
    protected Composite controlsSection;
    protected EObject context;

    public TableEditorPlus(Composite parent, int style) {
        super(parent, style);
        LayoutUtil.fillVSpace(parent);
    }

    protected void createPreviousWidgets(EObject sourceElement, EStructuralFeature feature) {
        this.self.setLayout((Layout)new GridLayout(2, false));
        this.context = sourceElement;
    }

    protected void createFollowingWidgets(EObject sourceElement, EStructuralFeature feature) {
        this.controlsSection = new Composite((Composite)this.self, 0);
        this.controlsSection.setLayout((Layout)new FillLayout());
        this.controlsSection.setLayoutData((Object)new GridData(0x1000008, 128, false, false));
        this.createListControls();
        Control tableWidget = this.self.getChildren()[0];
        GridDataFactory gdf = GridDataFactory.fillDefaults().grab(true, true);
        gdf.applyTo(tableWidget);
    }

    protected void createListControls() {
        this.add = this.createButton(Activator.getDefault().getImage(ICON_PATH + "Add_12x12.gif"), Messages.MultipleValueEditor_AddElements);
        this.remove = this.createButton(Activator.getDefault().getImage(ICON_PATH + "Delete_12x12.gif"), Messages.MultipleValueEditor_RemoveSelectedElements);
    }

    protected Button createButton(Image image, String toolTipText) {
        Button button = new Button(this.controlsSection, 8);
        button.setImage(image);
        button.addSelectionListener((SelectionListener)this);
        button.setToolTipText(toolTipText);
        return button;
    }

    public abstract AbstractEditCommandRequest createElementRequest();

    public abstract AbstractEditCommandRequest removeElementRequest(Object var1);

    public void widgetSelected(SelectionEvent e) {
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)this.context);
        if (e.getSource() == this.add) {
            ICommand cmd = ElementEditServiceUtils.getCommandProvider((EObject)this.context).getEditCommand((IEditCommandRequest)this.createElementRequest());
            if (cmd != null) {
                domain.getCommandStack().execute(GMFtoEMFCommandWrapper.wrap((ICommand)cmd));
            }
        } else if (e.getSource() == this.remove) {
            ILayer gridLayer = this.natTableWidget.getLayer();
            ILayer bodyLayer = ((GridLayer)gridLayer).getBodyLayer();
            SelectionLayer sl = ((BodyLayerStack)bodyLayer).getSelectionLayer();
            int row = sl.getSelectionAnchor().rowPosition;
            if (row >= 0) {
                Object object = this.nattableManager.getRowElement(row);
                ICommand cmd = ElementEditServiceUtils.getCommandProvider((EObject)this.context).getEditCommand((IEditCommandRequest)this.removeElementRequest(object));
                if (cmd != null) {
                    domain.getCommandStack().execute(GMFtoEMFCommandWrapper.wrap((ICommand)cmd));
                }
            }
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }
}

