/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.weaving.adaptors;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.equinox.service.weaving.ICachingService;
import org.eclipse.equinox.service.weaving.ICachingServiceFactory;
import org.eclipse.equinox.service.weaving.ISupplementerRegistry;
import org.eclipse.equinox.service.weaving.IWeavingService;
import org.eclipse.equinox.service.weaving.IWeavingServiceFactory;
import org.eclipse.equinox.weaving.adaptors.Debug;
import org.eclipse.osgi.internal.loader.ModuleClassLoader;
import org.eclipse.osgi.storage.BundleInfo;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.service.startlevel.StartLevel;
import org.osgi.util.tracker.ServiceTracker;

public class WeavingAdaptorFactory {
    private static final Collection<String> IGNORE_WEAVING_SERVICE_BUNDLES = Arrays.asList("org.eclipse.equinox.weaving.aspectj", "org.eclipse.equinox.weaving.caching", "org.eclipse.equinox.weaving.caching.j9", "org.eclipse.equinox.simpleconfigurator", "org.eclipse.equinox.common");
    private ServiceTracker<ICachingServiceFactory, ICachingServiceFactory> cachingServiceFactoryTracker;
    private PackageAdmin packageAdminService;
    private StartLevel startLevelService;
    private ISupplementerRegistry supplementerRegistry;
    private ServiceTracker<IWeavingServiceFactory, IWeavingServiceFactory> weavingServiceFactoryTracker;
    private ServiceListener weavingServiceListener;
    private final Map<Bundle, IWeavingService> weavingServices = new ConcurrentHashMap<Bundle, IWeavingService>();

    public void dispose(BundleContext context) {
        context.removeServiceListener(this.weavingServiceListener);
        if (Debug.DEBUG_WEAVE) {
            Debug.println("> Removed service listener for weaving service.");
        }
        this.weavingServiceFactoryTracker.close();
        if (Debug.DEBUG_WEAVE) {
            Debug.println("> Closed service tracker for weaving service.");
        }
        this.cachingServiceFactoryTracker.close();
        if (Debug.DEBUG_CACHE) {
            Debug.println("> Closed service tracker for caching service.");
        }
    }

    protected ICachingService getCachingService(ModuleClassLoader loader, Bundle bundle, IWeavingService weavingService) {
        ICachingServiceFactory cachingServiceFactory;
        if (Debug.DEBUG_CACHE) {
            Debug.println("> WeavingAdaptorFactory.getCachingService() bundle=" + String.valueOf(bundle) + ", weavingService=" + String.valueOf(weavingService));
        }
        ICachingService service = null;
        String key = "";
        if (weavingService != null) {
            key = weavingService.getKey();
        }
        if ((cachingServiceFactory = (ICachingServiceFactory)this.cachingServiceFactoryTracker.getService()) != null) {
            service = cachingServiceFactory.createCachingService((ClassLoader)loader, bundle, key);
        }
        if (Debug.DEBUG_CACHE) {
            Debug.println("< WeavingAdaptorFactory.getCachingService() service=" + String.valueOf(service) + ", key='" + key + "'");
        }
        return service;
    }

    public Bundle getHost(Bundle fragment) {
        if (Debug.DEBUG_GENERAL) {
            Debug.println("> WeavingAdaptorFactory.getHost() fragment=" + String.valueOf(fragment));
        }
        Bundle host = null;
        if (this.packageAdminService != null) {
            host = this.packageAdminService.getHosts(fragment)[0];
        }
        if (Debug.DEBUG_GENERAL) {
            Debug.println("< WeavingAdaptorFactory.getHost() " + String.valueOf(host));
        }
        return host;
    }

    protected IWeavingService getWeavingService(ModuleClassLoader loader) {
        IWeavingServiceFactory weavingServiceFactory;
        if (Debug.DEBUG_WEAVE) {
            Debug.println("> WeavingAdaptorFactory.getWeavingService() baseClassLoader=" + String.valueOf(loader));
        }
        BundleInfo.Generation generation = loader.getClasspathManager().getGeneration();
        Bundle bundle = loader.getBundle();
        IWeavingService weavingService = null;
        if (!IGNORE_WEAVING_SERVICE_BUNDLES.contains(bundle.getSymbolicName()) && (weavingServiceFactory = (IWeavingServiceFactory)this.weavingServiceFactoryTracker.getService()) != null && (weavingService = weavingServiceFactory.createWeavingService((ClassLoader)loader, bundle, (BundleRevision)generation.getRevision(), this.supplementerRegistry)) != null) {
            this.weavingServices.put(bundle, weavingService);
        }
        if (Debug.DEBUG_WEAVE) {
            Debug.println("< WeavingAdaptorFactory.getWeavingService() service=" + String.valueOf(weavingService));
        }
        return weavingService;
    }

    public void initialize(BundleContext context, final ISupplementerRegistry supplementerRegistry) {
        if (Debug.DEBUG_GENERAL) {
            Debug.println("> WeavingAdaptorFactory.initialize() context=" + String.valueOf(context));
        }
        this.supplementerRegistry = supplementerRegistry;
        this.initializePackageAdminService(context);
        this.initializeStartLevelService(context);
        this.weavingServiceFactoryTracker = new ServiceTracker(context, IWeavingServiceFactory.class, null);
        this.weavingServiceFactoryTracker.open();
        if (Debug.DEBUG_WEAVE) {
            Debug.println("> Opened service tracker for weaving service.");
        }
        this.weavingServiceListener = new ServiceListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void serviceChanged(ServiceEvent event) {
                Bundle bundle;
                Iterator<Bundle> bundleEntries;
                Map<Bundle, IWeavingService> map;
                ArrayList<Bundle> bundlesToRefresh;
                if (event.getType() == 1) {
                    bundlesToRefresh = new ArrayList<Bundle>();
                    map = WeavingAdaptorFactory.this.weavingServices;
                    synchronized (map) {
                        bundleEntries = WeavingAdaptorFactory.this.weavingServices.keySet().iterator();
                        while (bundleEntries.hasNext()) {
                            bundle = bundleEntries.next();
                            bundleEntries.remove();
                            bundlesToRefresh.add(bundle);
                            if (!Debug.DEBUG_WEAVE) continue;
                            Debug.println("> Updated bundle " + bundle.getSymbolicName());
                        }
                    }
                    if (bundlesToRefresh.size() > 0) {
                        supplementerRegistry.refreshBundles(bundlesToRefresh.toArray(new Bundle[bundlesToRefresh.size()]));
                    }
                }
                if (event.getType() == 4 && WeavingAdaptorFactory.this.startLevelService != null && WeavingAdaptorFactory.this.startLevelService.getStartLevel() > 0) {
                    bundlesToRefresh = new ArrayList();
                    map = WeavingAdaptorFactory.this.weavingServices;
                    synchronized (map) {
                        bundleEntries = WeavingAdaptorFactory.this.weavingServices.keySet().iterator();
                        while (bundleEntries.hasNext()) {
                            bundle = bundleEntries.next();
                            bundleEntries.remove();
                            bundlesToRefresh.add(bundle);
                            if (!Debug.DEBUG_WEAVE) continue;
                            Debug.println("> Updated bundle " + bundle.getSymbolicName());
                        }
                    }
                    if (bundlesToRefresh.size() > 0) {
                        supplementerRegistry.refreshBundles(bundlesToRefresh.toArray(new Bundle[bundlesToRefresh.size()]));
                    }
                }
            }
        };
        try {
            context.addServiceListener(this.weavingServiceListener, "(objectClass=" + IWeavingServiceFactory.class.getName() + ")");
        }
        catch (InvalidSyntaxException invalidSyntaxException) {}
        this.cachingServiceFactoryTracker = new ServiceTracker(context, ICachingServiceFactory.class, null);
        this.cachingServiceFactoryTracker.open();
        if (Debug.DEBUG_CACHE) {
            Debug.println("> Opened service tracker for caching service.");
        }
    }

    private void initializePackageAdminService(BundleContext context) {
        ServiceReference ref;
        if (Debug.DEBUG_GENERAL) {
            Debug.println("> AdaptorFactory.initializePackageAdminService() context=" + String.valueOf(context));
        }
        if ((ref = context.getServiceReference(PackageAdmin.class)) != null) {
            this.packageAdminService = (PackageAdmin)context.getService(ref);
        }
        if (Debug.DEBUG_GENERAL) {
            Debug.println("< AdaptorFactory.initializePackageAdminService() " + String.valueOf(this.packageAdminService));
        }
    }

    private void initializeStartLevelService(BundleContext context) {
        ServiceReference ref;
        if (Debug.DEBUG_GENERAL) {
            Debug.println("> AdaptorFactory.initializeStartLevelService() context=" + String.valueOf(context));
        }
        if ((ref = context.getServiceReference(StartLevel.class)) != null) {
            this.startLevelService = (StartLevel)context.getService(ref);
        }
        if (Debug.DEBUG_GENERAL) {
            Debug.println("< AdaptorFactory.initializeStartLevelService() " + String.valueOf(this.startLevelService));
        }
    }
}

