/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.domain.services.properties;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.papyrus.uml.domain.services.profile.StereotypeUtil;
import org.eclipse.papyrus.uml.domain.services.properties.ILogger;
import org.eclipse.uml2.uml.UMLPackage;

public class PropertiesStereotypeApplicationServices {
    private static final String BOOLEAN_OBJECT_UNSET_LITERAL = "null";
    private static final String BOOLEAN_OBJECT_TRUE_LITERAL = "true";
    private static final String BOOLEAN_OBJECT_FALSE_LITERAL = "false";
    private ILogger logger;

    public PropertiesStereotypeApplicationServices(ILogger logger) {
        this.logger = logger;
    }

    public List<EStructuralFeature> getAllFeatures(EObject target) {
        return target.eClass().getEAllStructuralFeatures().stream().filter(this::isValidFeature).toList();
    }

    private boolean isValidFeature(EStructuralFeature feature) {
        return !feature.getName().startsWith("base_") && !feature.isTransient() && !feature.isDerived() && !this.isContainmentReference(feature);
    }

    private boolean isContainmentReference(EStructuralFeature feature) {
        if (feature instanceof EReference) {
            EReference reference = (EReference)feature;
            return reference.isContainment();
        }
        return false;
    }

    public boolean isEditable(EStructuralFeature feature) {
        return feature.isChangeable() && !feature.isTransient();
    }

    public Object getStereotypeFeatureValue(EObject stereotypeApplication, EStructuralFeature feature) {
        return stereotypeApplication.eGet(feature);
    }

    public Object getStereotypeFeatureBaseElementValue(EObject stereotypeApplication, EReference reference) {
        Object result;
        Object value = stereotypeApplication.eGet((EStructuralFeature)reference);
        if (value instanceof EObject) {
            EObject eObject = (EObject)value;
            result = StereotypeUtil.getBaseElement(eObject);
        } else {
            result = value instanceof List ? ((List)value).stream().filter(e -> e instanceof EObject).map(e -> (EObject)e).map(StereotypeUtil::getBaseElement).toList() : null;
        }
        return result;
    }

    public Object getStereotypeEnumerationValue(EObject stereotypeApplication, EStructuralFeature feature) {
        Object value = stereotypeApplication.eGet(feature);
        String literalResult = null;
        if (value instanceof EEnumLiteral) {
            EEnumLiteral literal = (EEnumLiteral)value;
            literalResult = literal.getLiteral();
        } else if (value instanceof Enumerator) {
            Enumerator enumeration = (Enumerator)value;
            literalResult = enumeration.getLiteral();
        }
        return literalResult;
    }

    public Object getStereotypeBooleanObjectValue(EObject stereotypeApplication, EStructuralFeature feature) {
        Object value;
        if (this.isMonoBooleanObjectAttribute(feature) && (value = stereotypeApplication.eGet(feature)) != null) {
            return value.toString();
        }
        return BOOLEAN_OBJECT_UNSET_LITERAL;
    }

    private void setIntegerValue(EObject stereotypeApplication, EStructuralFeature feature, String value) {
        try {
            Integer number = Integer.valueOf(value);
            stereotypeApplication.eSet(feature, (Object)number);
        }
        catch (NumberFormatException e) {
            this.logger.log(MessageFormat.format("''{0}'' is not a valid value for feature ''{1}'' expecting an integer number", value, feature.getName()), ILogger.ILogLevel.ERROR);
        }
    }

    private void setDoubleValue(EObject stereotypeApplication, EStructuralFeature feature, String value) {
        try {
            Double number = Double.valueOf(value);
            stereotypeApplication.eSet(feature, (Object)number);
        }
        catch (NumberFormatException e) {
            this.logger.log(MessageFormat.format("''{0}'' is not a valid value for feature ''{1}'' expecting a double number", value, feature.getName()), ILogger.ILogLevel.ERROR);
        }
    }

    private void setFloatValue(EObject stereotypeApplication, EStructuralFeature feature, String value) {
        try {
            Float number = Float.valueOf(value);
            stereotypeApplication.eSet(feature, (Object)number);
        }
        catch (NumberFormatException e) {
            this.logger.log(MessageFormat.format("''{0}'' is not a valid value for feature ''{1}'' expecting a float number", value, feature.getName()), ILogger.ILogLevel.ERROR);
        }
    }

    public Object setStereotypeFeatureValue(EObject stereotypeApplication, EStructuralFeature feature, Object value) {
        if (this.isMonoIntegerAttribute(feature)) {
            this.setIntegerValue(stereotypeApplication, feature, (String)value);
        } else if (this.isMonoDoubleAttribute(feature)) {
            this.setDoubleValue(stereotypeApplication, feature, (String)value);
        } else if (this.isMonoFloatAttribute(feature)) {
            this.setFloatValue(stereotypeApplication, feature, (String)value);
        } else if (this.isMonoBooleanAttribute(feature)) {
            stereotypeApplication.eSet(feature, value);
        } else if (this.isMonoBooleanObjectAttribute(feature)) {
            stereotypeApplication.eSet(feature, (Object)this.getBooleanObjectLiteral((String)value));
        } else if (this.isMonoStringAttribute(feature)) {
            stereotypeApplication.eSet(feature, value);
        } else if (this.isMonoEnumeration(feature)) {
            stereotypeApplication.eSet(feature, this.getEnumLiteral(feature, (String)value));
        }
        return stereotypeApplication;
    }

    private Object getEnumLiteral(EStructuralFeature feature, String value) {
        EDataType type;
        EAttribute attr;
        EEnumLiteral result = null;
        if (feature instanceof EAttribute && !(attr = (EAttribute)feature).isMany() && (type = attr.getEAttributeType()) instanceof EEnum) {
            Enumerator enumLiteralInstance;
            EEnumLiteral enumLiteral;
            EEnum enumeration = (EEnum)type;
            enumeration.getInstanceClass();
            result = enumLiteral = enumeration.getEEnumLiteral(value);
            if (enumLiteral != null && (enumLiteralInstance = enumLiteral.getInstance()) != null) {
                result = enumLiteralInstance;
            }
        }
        return result;
    }

    public boolean isMonoStringAttribute(EStructuralFeature feature) {
        EAttribute attr;
        if (feature instanceof EAttribute && !(attr = (EAttribute)feature).isMany()) {
            return this.isAttributeOfType(attr, String.class);
        }
        return false;
    }

    public boolean isMultiStringAttribute(EStructuralFeature feature) {
        EAttribute attr;
        if (feature instanceof EAttribute && (attr = (EAttribute)feature).isMany()) {
            return this.isAttributeOfType(attr, String.class);
        }
        return false;
    }

    public boolean isMonoBooleanAttribute(EStructuralFeature feature) {
        EAttribute attr;
        if (feature instanceof EAttribute && !(attr = (EAttribute)feature).isMany()) {
            return this.isAttributeOfType(attr, Boolean.TYPE);
        }
        return false;
    }

    public boolean isMultiBooleanAttribute(EStructuralFeature feature) {
        EAttribute attr;
        if (feature instanceof EAttribute && (attr = (EAttribute)feature).isMany()) {
            return this.isAttributeOfType(attr, Boolean.TYPE) || this.isAttributeOfType(attr, Boolean.class);
        }
        return false;
    }

    public boolean isMonoBooleanObjectAttribute(EStructuralFeature feature) {
        EAttribute attr;
        if (feature instanceof EAttribute && !(attr = (EAttribute)feature).isMany()) {
            return this.isAttributeOfType(attr, Boolean.class);
        }
        return false;
    }

    public boolean isMonoIntegerAttribute(EStructuralFeature feature) {
        EAttribute attr;
        if (feature instanceof EAttribute && !(attr = (EAttribute)feature).isMany()) {
            return this.isAttributeOfType(attr, Integer.TYPE) || this.isAttributeOfType(attr, Integer.class);
        }
        return false;
    }

    public boolean isMultiIntegerAttribute(EStructuralFeature feature) {
        EAttribute attr;
        if (feature instanceof EAttribute && (attr = (EAttribute)feature).isMany()) {
            return this.isAttributeOfType(attr, Integer.TYPE) || this.isAttributeOfType(attr, Integer.class);
        }
        return false;
    }

    public boolean isMonoDoubleAttribute(EStructuralFeature feature) {
        EAttribute attr;
        if (feature instanceof EAttribute && !(attr = (EAttribute)feature).isMany()) {
            return this.isAttributeOfType(attr, Double.TYPE) || this.isAttributeOfType(attr, Double.class);
        }
        return false;
    }

    public boolean isMultiDoubleAttribute(EStructuralFeature feature) {
        EAttribute attr;
        if (feature instanceof EAttribute && (attr = (EAttribute)feature).isMany()) {
            return this.isAttributeOfType(attr, Double.TYPE) || this.isAttributeOfType(attr, Double.class);
        }
        return false;
    }

    public boolean isMonoFloatAttribute(EStructuralFeature feature) {
        EAttribute attr;
        if (feature instanceof EAttribute && !(attr = (EAttribute)feature).isMany()) {
            return this.isAttributeOfType(attr, Float.TYPE) || this.isAttributeOfType(attr, Float.class);
        }
        return false;
    }

    public boolean isMultiFloatAttribute(EStructuralFeature feature) {
        EAttribute attr;
        if (feature instanceof EAttribute && (attr = (EAttribute)feature).isMany()) {
            return this.isAttributeOfType(attr, Float.TYPE) || this.isAttributeOfType(attr, Float.class);
        }
        return false;
    }

    private boolean isAttributeOfType(EAttribute attr, Class<?> expectedType) {
        Class instanceClass;
        EDataType type = attr.getEAttributeType();
        if (type != null && (instanceClass = type.getInstanceClass()) != null) {
            return instanceClass.isAssignableFrom(expectedType);
        }
        return false;
    }

    public boolean isMonoEnumeration(EStructuralFeature feature) {
        EDataType type;
        EAttribute attr;
        return feature instanceof EAttribute && !(attr = (EAttribute)feature).isMany() && (type = attr.getEAttributeType()) instanceof EEnum;
    }

    public boolean isMultiEnumeration(EStructuralFeature feature) {
        EDataType type;
        EAttribute attr;
        return feature instanceof EAttribute && (attr = (EAttribute)feature).isMany() && (type = attr.getEAttributeType()) instanceof EEnum;
    }

    public List<String> getStereotypeEnumerationLiterals(EStructuralFeature feature) {
        EAttribute attr;
        EDataType type;
        if (feature instanceof EAttribute && (type = (attr = (EAttribute)feature).getEAttributeType()) instanceof EEnum) {
            EEnum enumeration = (EEnum)type;
            return enumeration.getELiterals().stream().map(EEnumLiteral::getLiteral).toList();
        }
        return List.of();
    }

    public List<String> getStereotypeBooleanObjectLiterals(EStructuralFeature feature) {
        return List.of(BOOLEAN_OBJECT_TRUE_LITERAL, BOOLEAN_OBJECT_FALSE_LITERAL, BOOLEAN_OBJECT_UNSET_LITERAL);
    }

    private Boolean getBooleanObjectLiteral(String value) {
        if (BOOLEAN_OBJECT_UNSET_LITERAL.equals(value)) {
            return null;
        }
        return Boolean.valueOf(value);
    }

    public boolean isMonoReference(EStructuralFeature feature) {
        EReference ref;
        return feature instanceof EReference && !(ref = (EReference)feature).isMany();
    }

    public boolean isUMLDataType(EClassifier classifier) {
        return classifier.getEPackage() == UMLPackage.eINSTANCE;
    }

    public boolean isStereotypeDataType(EClass eClass) {
        return eClass != null && StereotypeUtil.getBaseReferences(eClass).count() > 0L;
    }

    public boolean isMultiReference(EStructuralFeature feature) {
        EReference ref;
        return feature instanceof EReference && (ref = (EReference)feature).isMany();
    }
}

