/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.domain.services.internal.helpers;

import java.util.Optional;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.uml2.uml.Action;
import org.eclipse.uml2.uml.ActivityEdge;
import org.eclipse.uml2.uml.ActivityNode;
import org.eclipse.uml2.uml.ActivityParameterNode;
import org.eclipse.uml2.uml.DecisionNode;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.FinalNode;
import org.eclipse.uml2.uml.ForkNode;
import org.eclipse.uml2.uml.InitialNode;
import org.eclipse.uml2.uml.InputPin;
import org.eclipse.uml2.uml.JoinNode;
import org.eclipse.uml2.uml.MergeNode;
import org.eclipse.uml2.uml.OpaqueAction;
import org.eclipse.uml2.uml.OutputPin;
import org.eclipse.uml2.uml.Pin;
import org.eclipse.uml2.uml.StructuredActivityNode;
import org.eclipse.uml2.uml.UMLPackage;

public class ObjectFlowHelper {
    public boolean canCreateObjectFlow(EObject semanticEdgeSource, EObject semanticEdgeTarget) {
        if (semanticEdgeSource instanceof ActivityNode && semanticEdgeTarget instanceof ActivityNode && this.canCreateFromSource((ActivityNode)semanticEdgeSource, (ActivityNode)semanticEdgeTarget)) {
            return this.canCreateToTarget((ActivityNode)semanticEdgeSource, (ActivityNode)semanticEdgeTarget);
        }
        return false;
    }

    public boolean canCreateFromSource(ActivityNode source, ActivityNode target) {
        EList incomings;
        boolean canCreate = true;
        if (source instanceof Action) {
            if (!this.canStartNewObjectFlowByAddingPin((Action)source)) {
                canCreate = false;
            }
        } else if (source instanceof InputPin) {
            if (this.isStructuredActivityNode(source.getOwner())) {
                if (target != null && !this.isPinOwnedByStructuredActivityNode(target, (StructuredActivityNode)source.getOwner())) {
                    canCreate = false;
                }
            } else {
                canCreate = false;
            }
        } else if (source instanceof InitialNode) {
            canCreate = false;
        } else if (source instanceof FinalNode) {
            canCreate = false;
        } else if (source instanceof JoinNode) {
            if (!source.getOutgoings().isEmpty()) {
                canCreate = false;
            }
        } else if (source instanceof ForkNode) {
            canCreate = this.checkNoIncomingOrOutgoingControlFlow(source);
        } else if (source instanceof MergeNode) {
            canCreate = !source.getOutgoings().isEmpty() ? false : this.checkNoIncomingOrOutgoingControlFlow(source);
        } else if (source instanceof DecisionNode) {
            canCreate = this.checkNoIncomingOrOutgoingControlFlow(source);
        } else if (source instanceof ActivityParameterNode && !(incomings = source.getIncomings()).isEmpty()) {
            canCreate = false;
        }
        return canCreate;
    }

    private boolean checkNoIncomingOrOutgoingControlFlow(ActivityNode source) {
        ActivityEdge outgoingControlFlow = source.getOutgoing(null, true, UMLPackage.eINSTANCE.getControlFlow());
        ActivityEdge incomingControlFlow = source.getIncoming(null, true, UMLPackage.eINSTANCE.getControlFlow());
        return outgoingControlFlow == null && incomingControlFlow == null;
    }

    private boolean canCreateToTarget(ActivityNode source, ActivityNode target) {
        EList outgoings;
        boolean canCreate = true;
        if (target instanceof Action) {
            if (!this.canEndNewObjectFlowByAddingPin((Action)target)) {
                canCreate = false;
            }
        } else if (target instanceof OutputPin) {
            if (this.isStructuredActivityNode(target.getOwner())) {
                if (source != null && !this.isPinOwnedByStructuredActivityNode(source, (StructuredActivityNode)target.getOwner())) {
                    canCreate = false;
                }
            } else {
                canCreate = false;
            }
        } else if (target instanceof InitialNode) {
            canCreate = false;
        } else if (target instanceof JoinNode) {
            ActivityEdge outgoingControlFlow = target.getOutgoing(null, true, UMLPackage.eINSTANCE.getControlFlow());
            if (outgoingControlFlow != null) {
                canCreate = false;
            }
        } else if (target instanceof ForkNode) {
            canCreate = !target.getIncomings().isEmpty() ? false : this.checkNoIncomingOrOutgoingControlFlow(target);
        } else if (target instanceof MergeNode) {
            canCreate = this.checkNoIncomingOrOutgoingControlFlow(target);
        } else if (target instanceof DecisionNode) {
            if (target.getIncomings().size() >= 2) {
                canCreate = false;
            } else {
                ActivityEdge outgoingControlFlow = target.getOutgoing(null, true, UMLPackage.eINSTANCE.getControlFlow());
                ActivityEdge incomingControlFlow = target.getIncoming(null, true, UMLPackage.eINSTANCE.getControlFlow());
                if ((outgoingControlFlow != null || incomingControlFlow != null) && target.getIncoming(null, true, UMLPackage.eINSTANCE.getObjectFlow()) != null) {
                    canCreate = false;
                }
            }
        } else if (target instanceof ActivityParameterNode && !(outgoings = target.getOutgoings()).isEmpty()) {
            canCreate = false;
        }
        return canCreate;
    }

    private boolean isStructuredActivityNode(Element owner) {
        return Optional.ofNullable(owner).filter(element -> UMLPackage.eINSTANCE.getStructuredActivityNode().isInstance(element)).isPresent();
    }

    private boolean isPinOwnedByStructuredActivityNode(ActivityNode pin, StructuredActivityNode owner) {
        EList nodes;
        return pin instanceof Pin && (nodes = owner.allOwnedNodes()).contains((Object)pin);
    }

    private boolean canStartNewObjectFlowByAddingPin(Action action) {
        return action instanceof OpaqueAction;
    }

    private boolean canEndNewObjectFlowByAddingPin(Action action) {
        return action instanceof OpaqueAction;
    }
}

