/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.model2doc.integration.emf.documentstructuretemplate.representation.architecture.commands;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.resource.NotFoundException;
import org.eclipse.papyrus.infra.core.sashwindows.di.service.IPageManager;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.core.utils.ServiceUtils;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.model2doc.core.logger.IModel2DocLogger;
import org.eclipse.papyrus.model2doc.emf.documentstructuretemplate.DocumentTemplate;
import org.eclipse.papyrus.model2doc.integration.emf.documentstructuretemplate.representation.architecture.Activator;
import org.eclipse.papyrus.model2doc.integration.emf.documentstructuretemplate.ui.modelresource.DocumentTemplateModel;

public abstract class AbstractCreatePapyrusEditorViewCommand<T extends EObject>
extends RecordingCommand {
    protected final EObject semanticContext;
    protected final EObject graphicalContext;
    protected final boolean openAfterCreation;
    protected final String editorViewName;
    protected T createdEditorView;
    protected IModel2DocLogger logger;

    public AbstractCreatePapyrusEditorViewCommand(TransactionalEditingDomain domain, String label, String editorViewName, EObject semanticContext, EObject graphicalContext, boolean openAfterCreation, IModel2DocLogger logger) {
        super(domain, label);
        this.semanticContext = semanticContext;
        this.graphicalContext = graphicalContext != null ? graphicalContext : semanticContext;
        this.openAfterCreation = openAfterCreation;
        this.editorViewName = editorViewName;
        this.logger = logger;
    }

    public AbstractCreatePapyrusEditorViewCommand(TransactionalEditingDomain domain, String label, String editorViewName, EObject semanticContext, boolean openAfterCreation, IModel2DocLogger logger) {
        this(domain, label, editorViewName, semanticContext, null, openAfterCreation, logger);
    }

    public final T getCreatedEditorView() {
        return this.createdEditorView;
    }

    protected final void attachToResource(EObject modelElement, DocumentTemplate docTemplate) {
        ServicesRegistry sReg = this.getServiceRegistry(modelElement);
        if (sReg == null) {
            return;
        }
        ModelSet modelSet = this.getModelSet(sReg);
        if (modelSet == null) {
            return;
        }
        DocumentTemplateModel model = null;
        try {
            model = (DocumentTemplateModel)modelSet.getModelChecked("org.eclipse.papyrus.model2doc.integration.emf.documentstructuretemplate.ui.DocumentTemplate");
        }
        catch (NotFoundException e) {
            Activator.log.error("DocumentTemplateModel not found", (Throwable)e);
            return;
        }
        model.addDocument(docTemplate, modelElement);
    }

    protected final ServicesRegistry getServiceRegistry(EObject modelElement) {
        try {
            return ServiceUtilsForEObject.getInstance().getServiceRegistry(modelElement);
        }
        catch (ServiceException e) {
            Activator.log.error("ServicesRegistry not found", (Throwable)e);
            return null;
        }
    }

    private ModelSet getModelSet(ServicesRegistry servicesRegistry) {
        try {
            return ServiceUtils.getInstance().getModelSet((Object)servicesRegistry);
        }
        catch (ServiceException e) {
            Activator.log.error("ModelSet not found", (Throwable)e);
            return null;
        }
    }

    private IPageManager getPageManager(ServicesRegistry servicesRegistry) {
        try {
            return (IPageManager)ServiceUtils.getInstance().getService(IPageManager.class, (Object)servicesRegistry);
        }
        catch (ServiceException e) {
            Activator.log.error("IPageManager not found", (Throwable)e);
            return null;
        }
    }

    protected final void openEditor(DocumentTemplate template) {
        ServicesRegistry sReg = this.getServiceRegistry(template.getSemanticContext());
        if (sReg == null) {
            return;
        }
        IPageManager pageManager = this.getPageManager(sReg);
        if (pageManager == null) {
            return;
        }
        pageManager.openPage((Object)template);
    }

    public Collection<?> getResult() {
        if (this.createdEditorView != null) {
            return Collections.singleton(this.createdEditorView);
        }
        return Collections.emptyList();
    }
}

