/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.model2doc.emf.template2structure.internal.command;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.model2doc.core.generatorconfiguration.IDocumentStructureGeneratorConfiguration;
import org.eclipse.papyrus.model2doc.core.logger.IModel2DocLogger;
import org.eclipse.papyrus.model2doc.emf.documentstructure.Document;
import org.eclipse.papyrus.model2doc.emf.documentstructure.Version;
import org.eclipse.papyrus.model2doc.emf.documentstructuretemplate.DocumentTemplate;
import org.eclipse.papyrus.model2doc.emf.template2structure.generator.ITemplate2StructureGenerator;
import org.eclipse.papyrus.model2doc.emf.template2structure.generator.Template2StructureRegistry;

public class GenerateDocumentStructureCommand
extends RecordingCommand {
    private final Collection<Document> result = new ArrayList<Document>();
    private DocumentTemplate documentTemplate;
    private ITemplate2StructureGenerator generator;
    private String documentVersion;
    private IModel2DocLogger logger;

    public GenerateDocumentStructureCommand(TransactionalEditingDomain domain, DocumentTemplate docTemplate, String version) {
        super(domain, "Generate Document Structure Command", "Create the Document Structure Object and store it in a new file");
        this.documentTemplate = docTemplate;
        this.documentVersion = version;
    }

    protected void doExecute() {
        Document document = this.generator.generate(this.documentTemplate, this.documentVersion, this.logger);
        if (document == null) {
            return;
        }
        URI documentStructureURI = null;
        IDocumentStructureGeneratorConfiguration configuration = this.documentTemplate.getDocumentStructureGeneratorConfiguration();
        if (configuration == null) {
            this.logger.warn("The document structure can't be generated, the configuration is not defined in your model.");
            return;
        }
        Version version = document.getVersion();
        documentStructureURI = configuration.createDocumentStructureOutputAccessor().createOutputFileURI(configuration.getDocumentName(), "pds", version != null ? version.getVersion() : null);
        if (documentStructureURI == null) {
            this.logger.warn("The document structure URI file can't be created.");
            return;
        }
        ResourceSetImpl structureResourceSet = new ResourceSetImpl();
        Resource structureResource = structureResourceSet.createResource(documentStructureURI);
        structureResource.getContents().add((Object)document);
        try {
            structureResource.save(Collections.emptyMap());
        }
        catch (IOException e) {
            this.logger.error((Throwable)e);
        }
        this.result.add(document);
        this.refreshWorkspace();
    }

    public boolean canExecute() {
        return super.canExecute();
    }

    protected boolean prepare() {
        boolean res = super.prepare();
        if (res) {
            this.generator = Template2StructureRegistry.INSTANCE.getGenerator(this.documentTemplate);
            res = this.generator != null;
        }
        return res;
    }

    public Collection<?> getResult() {
        return this.result;
    }

    protected void refreshWorkspace() {
        GenerateDocumentStructureCommand.refreshProjects(this.documentTemplate, this.logger);
    }

    private static void refreshProjects(DocumentTemplate documentTemplate, IModel2DocLogger logger) {
        ArrayList<String> projectsToRefresh = new ArrayList<String>();
        String structureProjectToRefresh = documentTemplate.getDocumentStructureGeneratorConfiguration().createDocumentStructureOutputAccessor().getProjectName();
        String imageProjectToRefresh = documentTemplate.getDocumentStructureGeneratorConfiguration().createImageOutputAccessor().getProjectName();
        if (structureProjectToRefresh != null && structureProjectToRefresh.isEmpty()) {
            projectsToRefresh.add(structureProjectToRefresh);
        }
        if (imageProjectToRefresh != null && imageProjectToRefresh.isEmpty()) {
            projectsToRefresh.add(imageProjectToRefresh);
        }
        for (String current : projectsToRefresh) {
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(current);
            if (project == null) continue;
            try {
                project.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                logger.error(NLS.bind((String)"An exception occurred refresh the project {0}", (Object)current), (Throwable)e);
            }
        }
    }
}

