/**
 * Copyright (c) 2023 CEA LIST.
 *
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License 2.0
 *  which accompanies this distribution, and is available at
 *  https://www.eclipse.org/legal/epl-2.0/
 *
 *  SPDX-License-Identifier: EPL-2.0
 *
 *  Contributors:
 *  Vincent Lorenzo (CEA LIST) vincent.lorenzo@cea.fr - Initial API and implementation
 */
package org.eclipse.papyrus.model2doc.markup.emf.documentstructuretemplate.impl;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;

import org.eclipse.emf.ecore.impl.EPackageImpl;

import org.eclipse.papyrus.infra.emf.expressions.ExpressionsPackage;

import org.eclipse.papyrus.infra.emf.expressions.booleanexpressions.BooleanExpressionsPackage;

import org.eclipse.papyrus.model2doc.core.author.AuthorPackage;

import org.eclipse.papyrus.model2doc.core.builtintypes.BuiltInTypesPackage;

import org.eclipse.papyrus.model2doc.core.generatorconfiguration.GeneratorConfigurationPackage;

import org.eclipse.papyrus.model2doc.core.styles.StylesPackage;

import org.eclipse.papyrus.model2doc.emf.documentstructuretemplate.DocumentStructureTemplatePackage;

import org.eclipse.papyrus.model2doc.markup.emf.documentstructuretemplate.EAttributeInMarkupToFile;
import org.eclipse.papyrus.model2doc.markup.emf.documentstructuretemplate.IMarkupToFileBodyPartTemplate;
import org.eclipse.papyrus.model2doc.markup.emf.documentstructuretemplate.MarkupEMFDocumentStructureTemplateFactory;
import org.eclipse.papyrus.model2doc.markup.emf.documentstructuretemplate.MarkupEMFDocumentStructureTemplatePackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Package</b>.
 * <!-- end-user-doc -->
 *
 * @generated
 */
public class MarkupEMFDocumentStructureTemplatePackageImpl extends EPackageImpl implements MarkupEMFDocumentStructureTemplatePackage {
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	private EClass eAttributeInMarkupToFileEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	private EClass iMarkupToFileBodyPartTemplateEClass = null;

	/**
	 * Creates an instance of the model <b>Package</b>, registered with
	 * {@link org.eclipse.emf.ecore.EPackage.Registry EPackage.Registry} by the package
	 * package URI value.
	 * <p>
	 * Note: the correct way to create the package is via the static
	 * factory method {@link #init init()}, which also performs
	 * initialization of the package, or returns the registered package,
	 * if one already exists.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @see org.eclipse.emf.ecore.EPackage.Registry
	 * @see org.eclipse.papyrus.model2doc.markup.emf.documentstructuretemplate.MarkupEMFDocumentStructureTemplatePackage#eNS_URI
	 * @see #init()
	 * @generated
	 */
	private MarkupEMFDocumentStructureTemplatePackageImpl() {
		super(eNS_URI, MarkupEMFDocumentStructureTemplateFactory.eINSTANCE);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	private static boolean isInited = false;

	/**
	 * Creates, registers, and initializes the <b>Package</b> for this model, and for any others upon which it depends.
	 *
	 * <p>
	 * This method is used to initialize {@link MarkupEMFDocumentStructureTemplatePackage#eINSTANCE} when that field is accessed.
	 * Clients should not invoke it directly. Instead, they should simply access that field to obtain the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @see #eNS_URI
	 * @see #createPackageContents()
	 * @see #initializePackageContents()
	 * @generated
	 */
	public static MarkupEMFDocumentStructureTemplatePackage init() {
		if (isInited) {
			return (MarkupEMFDocumentStructureTemplatePackage) EPackage.Registry.INSTANCE.getEPackage(MarkupEMFDocumentStructureTemplatePackage.eNS_URI);
		}

		// Obtain or create and register package
		Object registeredMarkupEMFDocumentStructureTemplatePackage = EPackage.Registry.INSTANCE.get(eNS_URI);
		MarkupEMFDocumentStructureTemplatePackageImpl theMarkupEMFDocumentStructureTemplatePackage = registeredMarkupEMFDocumentStructureTemplatePackage instanceof MarkupEMFDocumentStructureTemplatePackageImpl
				? (MarkupEMFDocumentStructureTemplatePackageImpl) registeredMarkupEMFDocumentStructureTemplatePackage
				: new MarkupEMFDocumentStructureTemplatePackageImpl();

		isInited = true;

		// Initialize simple dependencies
		AuthorPackage.eINSTANCE.eClass();
		BuiltInTypesPackage.eINSTANCE.eClass();
		DocumentStructureTemplatePackage.eINSTANCE.eClass();
		EcorePackage.eINSTANCE.eClass();
		GeneratorConfigurationPackage.eINSTANCE.eClass();
		StylesPackage.eINSTANCE.eClass();
		BooleanExpressionsPackage.eINSTANCE.eClass();
		ExpressionsPackage.eINSTANCE.eClass();

		// Create package meta-data objects
		theMarkupEMFDocumentStructureTemplatePackage.createPackageContents();

		// Initialize created meta-data
		theMarkupEMFDocumentStructureTemplatePackage.initializePackageContents();

		// Mark meta-data to indicate it can't be changed
		theMarkupEMFDocumentStructureTemplatePackage.freeze();

		// Update the registry and return the package
		EPackage.Registry.INSTANCE.put(MarkupEMFDocumentStructureTemplatePackage.eNS_URI, theMarkupEMFDocumentStructureTemplatePackage);
		return theMarkupEMFDocumentStructureTemplatePackage;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public EClass getEAttributeInMarkupToFile() {
		return eAttributeInMarkupToFileEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public EClass getIMarkupToFileBodyPartTemplate() {
		return iMarkupToFileBodyPartTemplateEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public EAttribute getIMarkupToFileBodyPartTemplate_InputFormat() {
		return (EAttribute) iMarkupToFileBodyPartTemplateEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public EAttribute getIMarkupToFileBodyPartTemplate_OutputFomat() {
		return (EAttribute) iMarkupToFileBodyPartTemplateEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public MarkupEMFDocumentStructureTemplateFactory getMarkupEMFDocumentStructureTemplateFactory() {
		return (MarkupEMFDocumentStructureTemplateFactory) getEFactoryInstance();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	private boolean isCreated = false;

	/**
	 * Creates the meta-model objects for the package. This method is
	 * guarded to have no affect on any invocation but its first.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	public void createPackageContents() {
		if (isCreated) {
			return;
		}
		isCreated = true;

		// Create classes and their features
		eAttributeInMarkupToFileEClass = createEClass(EATTRIBUTE_IN_MARKUP_TO_FILE);

		iMarkupToFileBodyPartTemplateEClass = createEClass(IMARKUP_TO_FILE_BODY_PART_TEMPLATE);
		createEAttribute(iMarkupToFileBodyPartTemplateEClass, IMARKUP_TO_FILE_BODY_PART_TEMPLATE__INPUT_FORMAT);
		createEAttribute(iMarkupToFileBodyPartTemplateEClass, IMARKUP_TO_FILE_BODY_PART_TEMPLATE__OUTPUT_FOMAT);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	private boolean isInitialized = false;

	/**
	 * Complete the initialization of the package and its meta-model. This
	 * method is guarded to have no affect on any invocation but its first.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	public void initializePackageContents() {
		if (isInitialized) {
			return;
		}
		isInitialized = true;

		// Initialize package
		setName(eNAME);
		setNsPrefix(eNS_PREFIX);
		setNsURI(eNS_URI);

		// Obtain other dependent packages
		DocumentStructureTemplatePackage theDocumentStructureTemplatePackage = (DocumentStructureTemplatePackage) EPackage.Registry.INSTANCE.getEPackage(DocumentStructureTemplatePackage.eNS_URI);

		// Create type parameters

		// Set bounds for type parameters

		// Add supertypes to classes
		eAttributeInMarkupToFileEClass.getESuperTypes().add(theDocumentStructureTemplatePackage.getEAttributeTemplate());
		eAttributeInMarkupToFileEClass.getESuperTypes().add(theDocumentStructureTemplatePackage.getILeafBodyPartTemplate());
		eAttributeInMarkupToFileEClass.getESuperTypes().add(theDocumentStructureTemplatePackage.getITemplatePartView());
		eAttributeInMarkupToFileEClass.getESuperTypes().add(this.getIMarkupToFileBodyPartTemplate());
		iMarkupToFileBodyPartTemplateEClass.getESuperTypes().add(theDocumentStructureTemplatePackage.getIBodySectionPartTemplate());

		// Initialize classes, features, and operations; add parameters
		initEClass(eAttributeInMarkupToFileEClass, EAttributeInMarkupToFile.class, "EAttributeInMarkupToFile", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS); //$NON-NLS-1$

		initEClass(iMarkupToFileBodyPartTemplateEClass, IMarkupToFileBodyPartTemplate.class, "IMarkupToFileBodyPartTemplate", IS_ABSTRACT, IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS); //$NON-NLS-1$
		initEAttribute(getIMarkupToFileBodyPartTemplate_InputFormat(), ecorePackage.getEString(), "inputFormat", null, 1, 1, IMarkupToFileBodyPartTemplate.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, //$NON-NLS-1$
				!IS_ORDERED);
		initEAttribute(getIMarkupToFileBodyPartTemplate_OutputFomat(), ecorePackage.getEString(), "outputFomat", null, 1, 1, IMarkupToFileBodyPartTemplate.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, //$NON-NLS-1$
				!IS_ORDERED);

		// Create resource
		createResource(eNS_URI);

		// Create annotations
		// http://www.eclipse.org/uml2/2.0.0/UML
		createUMLAnnotations();
	}

	/**
	 * Initializes the annotations for <b>http://www.eclipse.org/uml2/2.0.0/UML</b>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	protected void createUMLAnnotations() {
		String source = "http://www.eclipse.org/uml2/2.0.0/UML"; //$NON-NLS-1$
		addAnnotation(this,
				source,
				new String[] {
						"originalName", "markupdocumentstructuretemplate" //$NON-NLS-1$ //$NON-NLS-2$
				});
	}

} // MarkupEMFDocumentStructureTemplatePackageImpl
