/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml16.diagram.parametric.dnd;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.ISpecializationType;
import org.eclipse.papyrus.infra.gmfdiag.dnd.strategy.ExpansionElementDropStrategy;
import org.eclipse.papyrus.sysml16.diagram.parametric.dnd.IParametricDropStrategy;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;

public class ConstraintDropStrategy
extends ExpansionElementDropStrategy
implements IParametricDropStrategy {
    public String getCategoryID() {
        return "org.eclipse.papyrus.sysml16.diagram.parametric";
    }

    public String getCategoryLabel() {
        return "Parameter drag and drop";
    }

    public String getLabel() {
        return "Constraint drag and drop inside Constraint Property";
    }

    public String getID() {
        return "org.eclipse.papyrus.sysml16.diagram.parametric.dnd.ConstraintDropStrategy";
    }

    public String getDescription() {
        return "This strategy is is a specialization in order to be able to drop a Constraint inside constraint Property.";
    }

    public Command doGetCommand(Request request, EditPart targetEditPart) {
        if ("move children".equals(request.getType())) {
            return null;
        }
        CompositeCommand cc = new CompositeCommand(this.getLabel());
        if (targetEditPart instanceof GraphicalEditPart) {
            IGraphicalEditPart graphicalEditPart = (IGraphicalEditPart)targetEditPart;
            List sourceElements = this.getSourceEObjects(request);
            if (sourceElements.isEmpty()) {
                return null;
            }
            ArrayList valuesToAdd = new ArrayList(sourceElements.size());
            ISpecializationType constraintPropertyElementType = (ISpecializationType)ElementTypeRegistry.getInstance().getType("org.eclipse.papyrus.SysML16.ConstraintProperty");
            EObject target = graphicalEditPart.resolveSemanticElement();
            if (constraintPropertyElementType.getMatcher().matches(target) && target instanceof Property && ((Property)target).getType() != null) {
                Type targetType = ((Property)target).getType();
                for (EObject sourceElement : sourceElements) {
                    if (!(sourceElement instanceof Constraint) || !sourceElement.eContainer().equals(targetType)) continue;
                    this.addCommandDrop(targetEditPart, cc, valuesToAdd, sourceElement, (ISpecializationType)ElementTypeRegistry.getInstance().getType("org.eclipse.papyrus.sysml16di.Constraint_Label"));
                }
            }
        }
        return cc.canExecute() ? new ICommandProxy(cc.reduce()) : null;
    }
}

