/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.animation.engine.animators;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.moka.animation.engine.animators.Animator;
import org.eclipse.papyrus.moka.animation.engine.rendering.AnimationKind;
import org.eclipse.papyrus.moka.fuml.Semantics.Actions.BasicActions.ICallActionActivation;
import org.eclipse.papyrus.moka.fuml.Semantics.Actions.CompleteActions.IAcceptEventActionActivation;
import org.eclipse.papyrus.moka.fuml.Semantics.Activities.IntermediateActivities.IActivityEdgeInstance;
import org.eclipse.papyrus.moka.fuml.Semantics.Activities.IntermediateActivities.IActivityNodeActivation;
import org.eclipse.papyrus.moka.fuml.Semantics.Loci.LociL1.ISemanticVisitor;
import org.eclipse.papyrus.moka.utils.constants.MokaConstants;

public class ActivityAnimator
extends Animator {
    public void nodeVisited(ISemanticVisitor nodeVisitor) {
        IActivityEdgeInstance edgeInstance;
        if (nodeVisitor instanceof IActivityNodeActivation) {
            IActivityNodeActivation activation = (IActivityNodeActivation)nodeVisitor;
            if (activation.getNode() != null) {
                if (activation instanceof IAcceptEventActionActivation | activation instanceof ICallActionActivation) {
                    this.renderAs((EObject)activation.getNode(), activation.getExecutionContext(), AnimationKind.ANIMATED);
                } else {
                    this.renderAs((EObject)activation.getNode(), activation.getExecutionContext(), AnimationKind.ANIMATED, AnimationKind.VISITED, MokaConstants.MOKA_ANIMATION_DELAY);
                }
            }
        } else if (nodeVisitor instanceof IActivityEdgeInstance && (edgeInstance = (IActivityEdgeInstance)nodeVisitor).getEdge() != null) {
            this.engine.startRendering((EObject)edgeInstance.getEdge(), edgeInstance.getGroup().getActivityExecution().getContext(), AnimationKind.ANIMATED);
        }
    }

    public void nodeLeft(ISemanticVisitor nodeVisitor) {
        IActivityEdgeInstance edgeInstance;
        if (nodeVisitor instanceof IActivityNodeActivation) {
            IActivityNodeActivation activation = (IActivityNodeActivation)nodeVisitor;
            if (activation.getNode() != null && activation instanceof IAcceptEventActionActivation | activation instanceof ICallActionActivation) {
                this.renderAs((EObject)activation.getNode(), activation.getExecutionContext(), AnimationKind.VISITED);
            }
        } else if (nodeVisitor instanceof IActivityEdgeInstance && (edgeInstance = (IActivityEdgeInstance)nodeVisitor).getEdge() != null) {
            this.renderAs((EObject)edgeInstance.getEdge(), edgeInstance.getGroup().getActivityExecution().getContext(), AnimationKind.VISITED);
        }
    }

    @Override
    public boolean accept(ISemanticVisitor visitor) {
        return visitor instanceof IActivityNodeActivation || visitor instanceof IActivityEdgeInstance;
    }
}

