/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.model2doc.integration.gmf.documentstructuretemplate;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ContextFilterBehavior implements Enumerator
{
    SEMANTIC_CONTEXT(0, "SEMANTIC_CONTEXT", "SEMANTIC_CONTEXT"),
    GRAPHICAL_CONTEXT(1, "GRAPHICAL_CONTEXT", "GRAPHICAL_CONTEXT"),
    BOTH(2, "BOTH", "BOTH");

    public static final int SEMANTIC_CONTEXT_VALUE = 0;
    public static final int GRAPHICAL_CONTEXT_VALUE = 1;
    public static final int BOTH_VALUE = 2;
    private static final ContextFilterBehavior[] VALUES_ARRAY;
    public static final List<ContextFilterBehavior> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ContextFilterBehavior[]{SEMANTIC_CONTEXT, GRAPHICAL_CONTEXT, BOTH};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ContextFilterBehavior get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ContextFilterBehavior result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ContextFilterBehavior getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ContextFilterBehavior result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ContextFilterBehavior get(int value) {
        switch (value) {
            case 0: {
                return SEMANTIC_CONTEXT;
            }
            case 1: {
                return GRAPHICAL_CONTEXT;
            }
            case 2: {
                return BOTH;
            }
        }
        return null;
    }

    private ContextFilterBehavior(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

