/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml.diagram.parametric.commands;

import java.util.Collection;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.sysml.diagram.parametric.commands.ReorientReferenceRelationshipRequestWithGraphical;
import org.eclipse.papyrus.uml.service.types.utils.NamedElementHelper;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;

public class CustomParametricContextLinkReorientCommand
extends EditElementCommand {
    private final int reorientDirection;
    protected ReorientReferenceRelationshipRequestWithGraphical request;
    protected EObject referenceOwner;
    protected EObject oldSource;
    protected EObject newSource;
    protected EObject oldTarget;
    protected EObject newTarget;

    public CustomParametricContextLinkReorientCommand(ReorientReferenceRelationshipRequestWithGraphical request) {
        super(request.getLabel(), null, (IEditCommandRequest)request);
        this.request = request;
        this.reorientDirection = request.getDirection();
        this.referenceOwner = request.getReferenceOwner();
        this.oldSource = this.reorientDirection == 1 ? request.getOldRelationshipEnd() : request.getReferenceOwner();
        this.newSource = this.reorientDirection == 1 ? request.getNewRelationshipEnd() : request.getReferenceOwner();
        this.oldTarget = this.reorientDirection == 1 ? request.getReferenceOwner() : request.getOldRelationshipEnd();
        this.newTarget = this.reorientDirection == 1 ? request.getReferenceOwner() : request.getNewRelationshipEnd();
    }

    public boolean canExecute() {
        return this.getNewSource() instanceof Constraint && this.resolveNamespace(this.getNewTarget()) instanceof Namespace;
    }

    protected Namespace resolveNamespace(Element element) {
        Type type;
        if (element instanceof Namespace) {
            return (Namespace)element;
        }
        if (element instanceof Property && (type = ((Property)element).getType()) instanceof Namespace) {
            return (Namespace)type;
        }
        return null;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (!this.canExecute()) {
            throw new ExecutionException("Invalid arguments in reorient link command");
        }
        if (this.reorientDirection == 1) {
            return this.reorientSource();
        }
        if (this.reorientDirection == 2) {
            return this.reorientTarget();
        }
        throw new IllegalStateException();
    }

    protected CommandResult reorientSource() {
        EditPart sourceEditPart = this.request.getSourceEditPart();
        Namespace nearestNamespace = this.getNearestNamespace(sourceEditPart);
        this.getOldSource().setContext(nearestNamespace);
        Namespace context = this.resolveNamespace(this.getNewTarget());
        String defaultNameWithIncrementFromBase = NamedElementHelper.getDefaultNameWithIncrementFromBase((String)Constraint.class.getSimpleName(), (Collection)context.getOwnedRules(), (EObject)this.getNewSource());
        ((Constraint)this.getNewSource()).setName(defaultNameWithIncrementFromBase);
        ((Constraint)this.getNewSource()).setContext(this.resolveNamespace(this.getNewTarget()));
        return CommandResult.newOKCommandResult((Object)this.referenceOwner);
    }

    private Namespace getNearestNamespace(EditPart editPart) {
        EObject semanticElement;
        if (editPart != null && (semanticElement = ViewUtil.resolveSemanticElement((View)((View)editPart.getModel()))) != null) {
            Namespace resolvedNamespace = this.resolveNamespace((Element)semanticElement);
            if (resolvedNamespace instanceof Namespace) {
                return resolvedNamespace;
            }
            return this.getNearestNamespace(editPart.getParent());
        }
        return null;
    }

    protected CommandResult reorientTarget() {
        Namespace context = this.resolveNamespace(this.getNewTarget());
        String defaultNameWithIncrementFromBase = NamedElementHelper.getDefaultNameWithIncrementFromBase((String)Constraint.class.getSimpleName(), (Collection)context.getOwnedRules(), (EObject)this.getNewSource());
        ((Constraint)this.getNewSource()).setName(defaultNameWithIncrementFromBase);
        ((Constraint)this.getNewSource()).setContext(context);
        return CommandResult.newOKCommandResult((Object)this.referenceOwner);
    }

    protected Constraint getOldSource() {
        return (Constraint)this.oldSource;
    }

    protected Element getNewSource() {
        return (Element)this.newSource;
    }

    protected Element getOldTarget() {
        return (Element)this.oldTarget;
    }

    protected Element getNewTarget() {
        return (Element)this.newTarget;
    }
}

