/**
 *   Copyright (c) 2016 CEA LIST and others.
 *   
 *   All rights reserved. This program and the accompanying materials
 *   are made available under the terms of the Eclipse Public License v1.0
 *   which accompanies this distribution, and is available at
 *   http://www.eclipse.org/legal/epl-v10.html
 *  
 *   Contributors:
 *     CEA LIST - Initial API and implementation
 * 
 */
package org.eclipse.papyrus.interoperability.rpy.rpymetamodel.util;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;

import org.eclipse.emf.common.notify.impl.AdapterFactoryImpl;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;

import org.eclipse.papyrus.interoperability.rpy.rpymetamodel.*;

/**
 * <!-- begin-user-doc -->
 * The <b>Adapter Factory</b> for the model.
 * It provides an adapter <code>createXXX</code> method for each class of the model.
 * <!-- end-user-doc -->
 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.UMLRpyPackage
 * @generated
 */
public class UMLRpyAdapterFactory extends AdapterFactoryImpl {
	/**
	 * The cached model package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static UMLRpyPackage modelPackage;

	/**
	 * Creates an instance of the adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public UMLRpyAdapterFactory() {
		if (modelPackage == null) {
			modelPackage = UMLRpyPackage.eINSTANCE;
		}
	}

	/**
	 * Returns whether this factory is applicable for the type of the object.
	 * <!-- begin-user-doc -->
	 * This implementation returns <code>true</code> if the object is either the model's package or is an instance object of the model.
	 * <!-- end-user-doc -->
	 * @return whether this factory is applicable for the type of the object.
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object object) {
		if (object == modelPackage) {
			return true;
		}
		if (object instanceof EObject) {
			return ((EObject)object).eClass().getEPackage() == modelPackage;
		}
		return false;
	}

	/**
	 * The switch that delegates to the <code>createXXX</code> methods.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected UMLRpySwitch<Adapter> modelSwitch =
		new UMLRpySwitch<Adapter>() {
			@Override
			public Adapter caseAssociationsType(AssociationsType object) {
				return createAssociationsTypeAdapter();
			}
			@Override
			public Adapter caseCCollaborationChart(CCollaborationChart object) {
				return createCCollaborationChartAdapter();
			}
			@Override
			public Adapter caseCGIActionState(CGIActionState object) {
				return createCGIActionStateAdapter();
			}
			@Override
			public Adapter caseCGIActiveX(CGIActiveX object) {
				return createCGIActiveXAdapter();
			}
			@Override
			public Adapter caseCGIAnchor(CGIAnchor object) {
				return createCGIAnchorAdapter();
			}
			@Override
			public Adapter caseCGIAnnotation(CGIAnnotation object) {
				return createCGIAnnotationAdapter();
			}
			@Override
			public Adapter caseCGIArrow(CGIArrow object) {
				return createCGIArrowAdapter();
			}
			@Override
			public Adapter caseCGIAssociationEnd(CGIAssociationEnd object) {
				return createCGIAssociationEndAdapter();
			}
			@Override
			public Adapter caseCGIAssociationRole(CGIAssociationRole object) {
				return createCGIAssociationRoleAdapter();
			}
			@Override
			public Adapter caseCGIBasicClass(CGIBasicClass object) {
				return createCGIBasicClassAdapter();
			}
			@Override
			public Adapter caseCGIBlockState(CGIBlockState object) {
				return createCGIBlockStateAdapter();
			}
			@Override
			public Adapter caseCGIBox(CGIBox object) {
				return createCGIBoxAdapter();
			}
			@Override
			public Adapter caseCGIButtonArray(CGIButtonArray object) {
				return createCGIButtonArrayAdapter();
			}
			@Override
			public Adapter caseCGIClass(CGIClass object) {
				return createCGIClassAdapter();
			}
			@Override
			public Adapter caseCGIClassChart(CGIClassChart object) {
				return createCGIClassChartAdapter();
			}
			@Override
			public Adapter caseCGIClassifierRole(CGIClassifierRole object) {
				return createCGIClassifierRoleAdapter();
			}
			@Override
			public Adapter caseCGICompartment(CGICompartment object) {
				return createCGICompartmentAdapter();
			}
			@Override
			public Adapter caseCGIComponent(CGIComponent object) {
				return createCGIComponentAdapter();
			}
			@Override
			public Adapter caseCGICompositeClass(CGICompositeClass object) {
				return createCGICompositeClassAdapter();
			}
			@Override
			public Adapter caseCGIConnector(CGIConnector object) {
				return createCGIConnectorAdapter();
			}
			@Override
			public Adapter caseCGIContainArrow(CGIContainArrow object) {
				return createCGIContainArrowAdapter();
			}
			@Override
			public Adapter caseCGIDiagramFrame(CGIDiagramFrame object) {
				return createCGIDiagramFrameAdapter();
			}
			@Override
			public Adapter caseCGIFreeShape(CGIFreeShape object) {
				return createCGIFreeShapeAdapter();
			}
			@Override
			public Adapter caseCGIFreeText(CGIFreeText object) {
				return createCGIFreeTextAdapter();
			}
			@Override
			public Adapter caseCGIGenericElement(CGIGenericElement object) {
				return createCGIGenericElementAdapter();
			}
			@Override
			public Adapter caseCGIImage(CGIImage object) {
				return createCGIImageAdapter();
			}
			@Override
			public Adapter caseCGIImageData(CGIImageData object) {
				return createCGIImageDataAdapter();
			}
			@Override
			public Adapter caseCGIInformationFlow(CGIInformationFlow object) {
				return createCGIInformationFlowAdapter();
			}
			@Override
			public Adapter caseCGIInheritance(CGIInheritance object) {
				return createCGIInheritanceAdapter();
			}
			@Override
			public Adapter caseCGIMFCCtrl(CGIMFCCtrl object) {
				return createCGIMFCCtrlAdapter();
			}
			@Override
			public Adapter caseCGIMessageLabel(CGIMessageLabel object) {
				return createCGIMessageLabelAdapter();
			}
			@Override
			public Adapter caseCGIMscChart(CGIMscChart object) {
				return createCGIMscChartAdapter();
			}
			@Override
			public Adapter caseCGIMscColumnCR(CGIMscColumnCR object) {
				return createCGIMscColumnCRAdapter();
			}
			@Override
			public Adapter caseCGIMscConditionMark(CGIMscConditionMark object) {
				return createCGIMscConditionMarkAdapter();
			}
			@Override
			public Adapter caseCGIMscExecutionOccurrence(CGIMscExecutionOccurrence object) {
				return createCGIMscExecutionOccurrenceAdapter();
			}
			@Override
			public Adapter caseCGIMscInteractionOccurrence(CGIMscInteractionOccurrence object) {
				return createCGIMscInteractionOccurrenceAdapter();
			}
			@Override
			public Adapter caseCGIMscInteractionOperand(CGIMscInteractionOperand object) {
				return createCGIMscInteractionOperandAdapter();
			}
			@Override
			public Adapter caseCGIMscInteractionOperator(CGIMscInteractionOperator object) {
				return createCGIMscInteractionOperatorAdapter();
			}
			@Override
			public Adapter caseCGIMscMessage(CGIMscMessage object) {
				return createCGIMscMessageAdapter();
			}
			@Override
			public Adapter caseCGIObjectInstance(CGIObjectInstance object) {
				return createCGIObjectInstanceAdapter();
			}
			@Override
			public Adapter caseCGIObjectLink(CGIObjectLink object) {
				return createCGIObjectLinkAdapter();
			}
			@Override
			public Adapter caseCGIPackage(CGIPackage object) {
				return createCGIPackageAdapter();
			}
			@Override
			public Adapter caseCGIPartition(CGIPartition object) {
				return createCGIPartitionAdapter();
			}
			@Override
			public Adapter caseCGIPortConnector(CGIPortConnector object) {
				return createCGIPortConnectorAdapter();
			}
			@Override
			public Adapter caseCGIState(CGIState object) {
				return createCGIStateAdapter();
			}
			@Override
			public Adapter caseCGIStateChart(CGIStateChart object) {
				return createCGIStateChartAdapter();
			}
			@Override
			public Adapter caseCGISwimlaneFrame(CGISwimlaneFrame object) {
				return createCGISwimlaneFrameAdapter();
			}
			@Override
			public Adapter caseCGIText(CGIText object) {
				return createCGITextAdapter();
			}
			@Override
			public Adapter caseCGITextBox(CGITextBox object) {
				return createCGITextBoxAdapter();
			}
			@Override
			public Adapter caseCGITrans(CGITrans object) {
				return createCGITransAdapter();
			}
			@Override
			public Adapter caseCollEvent(CollEvent object) {
				return createCollEventAdapter();
			}
			@Override
			public Adapter caseCompartmentsType(CompartmentsType object) {
				return createCompartmentsTypeAdapter();
			}
			@Override
			public Adapter caseComponentsType(ComponentsType object) {
				return createComponentsTypeAdapter();
			}
			@Override
			public Adapter caseConveyedType(ConveyedType object) {
				return createConveyedTypeAdapter();
			}
			@Override
			public Adapter caseDeclarativesType(DeclarativesType object) {
				return createDeclarativesTypeAdapter();
			}
			@Override
			public Adapter caseDefaultSubsystemType(DefaultSubsystemType object) {
				return createDefaultSubsystemTypeAdapter();
			}
			@Override
			public Adapter caseDefaultTransType(DefaultTransType object) {
				return createDefaultTransTypeAdapter();
			}
			@Override
			public Adapter caseDependsOnType(DependsOnType object) {
				return createDependsOnTypeAdapter();
			}
			@Override
			public Adapter caseDescriptionType(DescriptionType object) {
				return createDescriptionTypeAdapter();
			}
			@Override
			public Adapter caseElementsType(ElementsType object) {
				return createElementsTypeAdapter();
			}
			@Override
			public Adapter caseEmbededFilesType(EmbededFilesType object) {
				return createEmbededFilesTypeAdapter();
			}
			@Override
			public Adapter caseEnd1_Type(End1_Type object) {
				return createEnd1_TypeAdapter();
			}
			@Override
			public Adapter caseEnd2_Type(End2_Type object) {
				return createEnd2_TypeAdapter();
			}
			@Override
			public Adapter caseFilesType(FilesType object) {
				return createFilesTypeAdapter();
			}
			@Override
			public Adapter caseFromLinkType(FromLinkType object) {
				return createFromLinkTypeAdapter();
			}
			@Override
			public Adapter caseGraphElementsType(GraphElementsType object) {
				return createGraphElementsTypeAdapter();
			}
			@Override
			public Adapter caseGraphicChartType(GraphicChartType object) {
				return createGraphicChartTypeAdapter();
			}
			@Override
			public Adapter caseHyperLinksType(HyperLinksType object) {
				return createHyperLinksTypeAdapter();
			}
			@Override
			public Adapter caseIAcceptEventAction(IAcceptEventAction object) {
				return createIAcceptEventActionAdapter();
			}
			@Override
			public Adapter caseIAcceptTimeEvent(IAcceptTimeEvent object) {
				return createIAcceptTimeEventAdapter();
			}
			@Override
			public Adapter caseIAction(IAction object) {
				return createIActionAdapter();
			}
			@Override
			public Adapter caseIActivityDiagram(IActivityDiagram object) {
				return createIActivityDiagramAdapter();
			}
			@Override
			public Adapter caseIActivityGraph(IActivityGraph object) {
				return createIActivityGraphAdapter();
			}
			@Override
			public Adapter caseIActor(IActor object) {
				return createIActorAdapter();
			}
			@Override
			public Adapter caseIAnchor(IAnchor object) {
				return createIAnchorAdapter();
			}
			@Override
			public Adapter caseIAnnotation(IAnnotation object) {
				return createIAnnotationAdapter();
			}
			@Override
			public Adapter caseIArgument(IArgument object) {
				return createIArgumentAdapter();
			}
			@Override
			public Adapter caseIAssociationClass(IAssociationClass object) {
				return createIAssociationClassAdapter();
			}
			@Override
			public Adapter caseIAssociationEnd(IAssociationEnd object) {
				return createIAssociationEndAdapter();
			}
			@Override
			public Adapter caseIAssociationEndHandle(IAssociationEndHandle object) {
				return createIAssociationEndHandleAdapter();
			}
			@Override
			public Adapter caseIAssociationRole(IAssociationRole object) {
				return createIAssociationRoleAdapter();
			}
			@Override
			public Adapter caseIAttribute(IAttribute object) {
				return createIAttributeAdapter();
			}
			@Override
			public Adapter caseIBlock(IBlock object) {
				return createIBlockAdapter();
			}
			@Override
			public Adapter caseIBody(IBody object) {
				return createIBodyAdapter();
			}
			@Override
			public Adapter caseIBranch(IBranch object) {
				return createIBranchAdapter();
			}
			@Override
			public Adapter caseICallAction(ICallAction object) {
				return createICallActionAdapter();
			}
			@Override
			public Adapter caseICallOperation(ICallOperation object) {
				return createICallOperationAdapter();
			}
			@Override
			public Adapter caseIClass(IClass object) {
				return createIClassAdapter();
			}
			@Override
			public Adapter caseIClassHandle(IClassHandle object) {
				return createIClassHandleAdapter();
			}
			@Override
			public Adapter caseIClassInstance(IClassInstance object) {
				return createIClassInstanceAdapter();
			}
			@Override
			public Adapter caseIClassifier(IClassifier object) {
				return createIClassifierAdapter();
			}
			@Override
			public Adapter caseIClassifierRole(IClassifierRole object) {
				return createIClassifierRoleAdapter();
			}
			@Override
			public Adapter caseICodeGenConfigInfo(ICodeGenConfigInfo object) {
				return createICodeGenConfigInfoAdapter();
			}
			@Override
			public Adapter caseICodeGenConfigInfoHandle(ICodeGenConfigInfoHandle object) {
				return createICodeGenConfigInfoHandleAdapter();
			}
			@Override
			public Adapter caseICollaboration(ICollaboration object) {
				return createICollaborationAdapter();
			}
			@Override
			public Adapter caseICollaborationDiagram(ICollaborationDiagram object) {
				return createICollaborationDiagramAdapter();
			}
			@Override
			public Adapter caseIColor(IColor object) {
				return createIColorAdapter();
			}
			@Override
			public Adapter caseICombinedFragment(ICombinedFragment object) {
				return createICombinedFragmentAdapter();
			}
			@Override
			public Adapter caseIComment(IComment object) {
				return createICommentAdapter();
			}
			@Override
			public Adapter caseIComponent(IComponent object) {
				return createIComponentAdapter();
			}
			@Override
			public Adapter caseIComponentDiagram(IComponentDiagram object) {
				return createIComponentDiagramAdapter();
			}
			@Override
			public Adapter caseIComponentInstance(IComponentInstance object) {
				return createIComponentInstanceAdapter();
			}
			@Override
			public Adapter caseIConfiguration(IConfiguration object) {
				return createIConfigurationAdapter();
			}
			@Override
			public Adapter caseIConnector(IConnector object) {
				return createIConnectorAdapter();
			}
			@Override
			public Adapter caseIConstraint(IConstraint object) {
				return createIConstraintAdapter();
			}
			@Override
			public Adapter caseIConstructor(IConstructor object) {
				return createIConstructorAdapter();
			}
			@Override
			public Adapter caseIContextSpecification(IContextSpecification object) {
				return createIContextSpecificationAdapter();
			}
			@Override
			public Adapter caseIControlledFile(IControlledFile object) {
				return createIControlledFileAdapter();
			}
			@Override
			public Adapter caseIDefaultDrvdTrans(IDefaultDrvdTrans object) {
				return createIDefaultDrvdTransAdapter();
			}
			@Override
			public Adapter caseIDependency(IDependency object) {
				return createIDependencyAdapter();
			}
			@Override
			public Adapter caseIDeploymentDiagram(IDeploymentDiagram object) {
				return createIDeploymentDiagramAdapter();
			}
			@Override
			public Adapter caseIDescription(IDescription object) {
				return createIDescriptionAdapter();
			}
			@Override
			public Adapter caseIDestructor(IDestructor object) {
				return createIDestructorAdapter();
			}
			@Override
			public Adapter caseIDiagram(IDiagram object) {
				return createIDiagramAdapter();
			}
			@Override
			public Adapter caseIEmbededFile(IEmbededFile object) {
				return createIEmbededFileAdapter();
			}
			@Override
			public Adapter caseIEnumerationLiteral(IEnumerationLiteral object) {
				return createIEnumerationLiteralAdapter();
			}
			@Override
			public Adapter caseIEvent(IEvent object) {
				return createIEventAdapter();
			}
			@Override
			public Adapter caseIEventHandle(IEventHandle object) {
				return createIEventHandleAdapter();
			}
			@Override
			public Adapter caseIEventReception(IEventReception object) {
				return createIEventReceptionAdapter();
			}
			@Override
			public Adapter caseIExecutionOccurrence(IExecutionOccurrence object) {
				return createIExecutionOccurrenceAdapter();
			}
			@Override
			public Adapter caseIExternalHyperlink(IExternalHyperlink object) {
				return createIExternalHyperlinkAdapter();
			}
			@Override
			public Adapter caseIFile(IFile object) {
				return createIFileAdapter();
			}
			@Override
			public Adapter caseIFileFragment(IFileFragment object) {
				return createIFileFragmentAdapter();
			}
			@Override
			public Adapter caseIFlow(IFlow object) {
				return createIFlowAdapter();
			}
			@Override
			public Adapter caseIFlowItem(IFlowItem object) {
				return createIFlowItemAdapter();
			}
			@Override
			public Adapter caseIFlowchart(IFlowchart object) {
				return createIFlowchartAdapter();
			}
			@Override
			public Adapter caseIFolder(IFolder object) {
				return createIFolderAdapter();
			}
			@Override
			public Adapter caseIFork(IFork object) {
				return createIForkAdapter();
			}
			@Override
			public Adapter caseIGeneralization(IGeneralization object) {
				return createIGeneralizationAdapter();
			}
			@Override
			public Adapter caseIGuard(IGuard object) {
				return createIGuardAdapter();
			}
			@Override
			public Adapter caseIHandleWithData(IHandleWithData object) {
				return createIHandleWithDataAdapter();
			}
			@Override
			public Adapter caseIHistoryConnector(IHistoryConnector object) {
				return createIHistoryConnectorAdapter();
			}
			@Override
			public Adapter caseIHyperLink(IHyperLink object) {
				return createIHyperLinkAdapter();
			}
			@Override
			public Adapter caseIInformationFlow(IInformationFlow object) {
				return createIInformationFlowAdapter();
			}
			@Override
			public Adapter caseIInformationItem(IInformationItem object) {
				return createIInformationItemAdapter();
			}
			@Override
			public Adapter caseIInstance(IInstance object) {
				return createIInstanceAdapter();
			}
			@Override
			public Adapter caseIInstanceSlot(IInstanceSlot object) {
				return createIInstanceSlotAdapter();
			}
			@Override
			public Adapter caseIInstanceSpecification(IInstanceSpecification object) {
				return createIInstanceSpecificationAdapter();
			}
			@Override
			public Adapter caseIInstanceValue(IInstanceValue object) {
				return createIInstanceValueAdapter();
			}
			@Override
			public Adapter caseIInteractionOccurrence(IInteractionOccurrence object) {
				return createIInteractionOccurrenceAdapter();
			}
			@Override
			public Adapter caseIInteractionOperand(IInteractionOperand object) {
				return createIInteractionOperandAdapter();
			}
			@Override
			public Adapter caseIInteractionOperator(IInteractionOperator object) {
				return createIInteractionOperatorAdapter();
			}
			@Override
			public Adapter caseIInterfaceItem(IInterfaceItem object) {
				return createIInterfaceItemAdapter();
			}
			@Override
			public Adapter caseIInterfaceItemTrigger(IInterfaceItemTrigger object) {
				return createIInterfaceItemTriggerAdapter();
			}
			@Override
			public Adapter caseIInternalHyperlink(IInternalHyperlink object) {
				return createIInternalHyperlinkAdapter();
			}
			@Override
			public Adapter caseILabel(ILabel object) {
				return createILabelAdapter();
			}
			@Override
			public Adapter caseILink(ILink object) {
				return createILinkAdapter();
			}
			@Override
			public Adapter caseILinkInstance(ILinkInstance object) {
				return createILinkInstanceAdapter();
			}
			@Override
			public Adapter caseILiteralSpecification(ILiteralSpecification object) {
				return createILiteralSpecificationAdapter();
			}
			@Override
			public Adapter caseIMHyperLink(IMHyperLink object) {
				return createIMHyperLinkAdapter();
			}
			@Override
			public Adapter caseIMSC(IMSC object) {
				return createIMSCAdapter();
			}
			@Override
			public Adapter caseIMatrixInstance(IMatrixInstance object) {
				return createIMatrixInstanceAdapter();
			}
			@Override
			public Adapter caseIMatrixLayout(IMatrixLayout object) {
				return createIMatrixLayoutAdapter();
			}
			@Override
			public Adapter caseIMatrixView(IMatrixView object) {
				return createIMatrixViewAdapter();
			}
			@Override
			public Adapter caseIMessage(IMessage object) {
				return createIMessageAdapter();
			}
			@Override
			public Adapter caseIMessagePoint(IMessagePoint object) {
				return createIMessagePointAdapter();
			}
			@Override
			public Adapter caseIMetaLinkHandle(IMetaLinkHandle object) {
				return createIMetaLinkHandleAdapter();
			}
			@Override
			public Adapter caseIModelElement(IModelElement object) {
				return createIModelElementAdapter();
			}
			@Override
			public Adapter caseIModule(IModule object) {
				return createIModuleAdapter();
			}
			@Override
			public Adapter caseIMultiplicityItem(IMultiplicityItem object) {
				return createIMultiplicityItemAdapter();
			}
			@Override
			public Adapter caseINode(INode object) {
				return createINodeAdapter();
			}
			@Override
			public Adapter caseIObjectLink(IObjectLink object) {
				return createIObjectLinkAdapter();
			}
			@Override
			public Adapter caseIObjectLinkHandle(IObjectLinkHandle object) {
				return createIObjectLinkHandleAdapter();
			}
			@Override
			public Adapter caseIObjectModelDiagram(IObjectModelDiagram object) {
				return createIObjectModelDiagramAdapter();
			}
			@Override
			public Adapter caseIObjectNode(IObjectNode object) {
				return createIObjectNodeAdapter();
			}
			@Override
			public Adapter caseIOperation(IOperation object) {
				return createIOperationAdapter();
			}
			@Override
			public Adapter caseIPackage(IPackage object) {
				return createIPackageAdapter();
			}
			@Override
			public Adapter caseIPanelDiagram(IPanelDiagram object) {
				return createIPanelDiagramAdapter();
			}
			@Override
			public Adapter caseIPart(IPart object) {
				return createIPartAdapter();
			}
			@Override
			public Adapter caseIPin(IPin object) {
				return createIPinAdapter();
			}
			@Override
			public Adapter caseIPort(IPort object) {
				return createIPortAdapter();
			}
			@Override
			public Adapter caseIPrimitiveOperation(IPrimitiveOperation object) {
				return createIPrimitiveOperationAdapter();
			}
			@Override
			public Adapter caseIProfile(IProfile object) {
				return createIProfileAdapter();
			}
			@Override
			public Adapter caseIProject(IProject object) {
				return createIProjectAdapter();
			}
			@Override
			public Adapter caseIProperty(IProperty object) {
				return createIPropertyAdapter();
			}
			@Override
			public Adapter caseIPropertyContainer(IPropertyContainer object) {
				return createIPropertyContainerAdapter();
			}
			@Override
			public Adapter caseIPropertyMetaclass(IPropertyMetaclass object) {
				return createIPropertyMetaclassAdapter();
			}
			@Override
			public Adapter caseIPropertySubject(IPropertySubject object) {
				return createIPropertySubjectAdapter();
			}
			@Override
			public Adapter caseIReception(IReception object) {
				return createIReceptionAdapter();
			}
			@Override
			public Adapter caseIReferenceActivity(IReferenceActivity object) {
				return createIReferenceActivityAdapter();
			}
			@Override
			public Adapter caseIRelation(IRelation object) {
				return createIRelationAdapter();
			}
			@Override
			public Adapter caseIRequirement(IRequirement object) {
				return createIRequirementAdapter();
			}
			@Override
			public Adapter caseISendAction(ISendAction object) {
				return createISendActionAdapter();
			}
			@Override
			public Adapter caseISequenceDiagram(ISequenceDiagram object) {
				return createISequenceDiagramAdapter();
			}
			@Override
			public Adapter caseISlot(ISlot object) {
				return createISlotAdapter();
			}
			@Override
			public Adapter caseIState(IState object) {
				return createIStateAdapter();
			}
			@Override
			public Adapter caseIStateChart(IStateChart object) {
				return createIStateChartAdapter();
			}
			@Override
			public Adapter caseIStateChartDiagram(IStateChartDiagram object) {
				return createIStateChartDiagramAdapter();
			}
			@Override
			public Adapter caseIStateVertex(IStateVertex object) {
				return createIStateVertexAdapter();
			}
			@Override
			public Adapter caseIStereotype(IStereotype object) {
				return createIStereotypeAdapter();
			}
			@Override
			public Adapter caseIStructureDiagram(IStructureDiagram object) {
				return createIStructureDiagramAdapter();
			}
			@Override
			public Adapter caseISubsystem(ISubsystem object) {
				return createISubsystemAdapter();
			}
			@Override
			public Adapter caseISwimlane(ISwimlane object) {
				return createISwimlaneAdapter();
			}
			@Override
			public Adapter caseISysMLPort(ISysMLPort object) {
				return createISysMLPortAdapter();
			}
			@Override
			public Adapter caseITableInstance(ITableInstance object) {
				return createITableInstanceAdapter();
			}
			@Override
			public Adapter caseITableLayout(ITableLayout object) {
				return createITableLayoutAdapter();
			}
			@Override
			public Adapter caseITableView(ITableView object) {
				return createITableViewAdapter();
			}
			@Override
			public Adapter caseITag(ITag object) {
				return createITagAdapter();
			}
			@Override
			public Adapter caseITemplateInst(ITemplateInst object) {
				return createITemplateInstAdapter();
			}
			@Override
			public Adapter caseITemplateInstParam(ITemplateInstParam object) {
				return createITemplateInstParamAdapter();
			}
			@Override
			public Adapter caseITemplateInstantiation(ITemplateInstantiation object) {
				return createITemplateInstantiationAdapter();
			}
			@Override
			public Adapter caseITemplateInstantiationParameter(ITemplateInstantiationParameter object) {
				return createITemplateInstantiationParameterAdapter();
			}
			@Override
			public Adapter caseITemplateParameter(ITemplateParameter object) {
				return createITemplateParameterAdapter();
			}
			@Override
			public Adapter caseITimeEvent(ITimeEvent object) {
				return createITimeEventAdapter();
			}
			@Override
			public Adapter caseITimeout(ITimeout object) {
				return createITimeoutAdapter();
			}
			@Override
			public Adapter caseITransition(ITransition object) {
				return createITransitionAdapter();
			}
			@Override
			public Adapter caseITrigger(ITrigger object) {
				return createITriggerAdapter();
			}
			@Override
			public Adapter caseITriggered(ITriggered object) {
				return createITriggeredAdapter();
			}
			@Override
			public Adapter caseIType(IType object) {
				return createITypeAdapter();
			}
			@Override
			public Adapter caseIUCDiagram(IUCDiagram object) {
				return createIUCDiagramAdapter();
			}
			@Override
			public Adapter caseIUnit(IUnit object) {
				return createIUnitAdapter();
			}
			@Override
			public Adapter caseIUseCase(IUseCase object) {
				return createIUseCaseAdapter();
			}
			@Override
			public Adapter caseIUseCaseDiagram(IUseCaseDiagram object) {
				return createIUseCaseDiagramAdapter();
			}
			@Override
			public Adapter caseIUseCaseStereoType(IUseCaseStereoType object) {
				return createIUseCaseStereoTypeAdapter();
			}
			@Override
			public Adapter caseIValueSpecification(IValueSpecification object) {
				return createIValueSpecificationAdapter();
			}
			@Override
			public Adapter caseIVariable(IVariable object) {
				return createIVariableAdapter();
			}
			@Override
			public Adapter caseInverseType(InverseType object) {
				return createInverseTypeAdapter();
			}
			@Override
			public Adapter caseItemsType(ItemsType object) {
				return createItemsTypeAdapter();
			}
			@Override
			public Adapter caseItsLabelType(ItsLabelType object) {
				return createItsLabelTypeAdapter();
			}
			@Override
			public Adapter caseItsStateChartType(ItsStateChartType object) {
				return createItsStateChartTypeAdapter();
			}
			@Override
			public Adapter caseItsTargetType(ItsTargetType object) {
				return createItsTargetTypeAdapter();
			}
			@Override
			public Adapter caseItsTriggerType(ItsTriggerType object) {
				return createItsTriggerTypeAdapter();
			}
			@Override
			public Adapter caseLinksType(LinksType object) {
				return createLinksTypeAdapter();
			}
			@Override
			public Adapter caseM_hTargetType(M_hTargetType object) {
				return createM_hTargetTypeAdapter();
			}
			@Override
			public Adapter caseM_pBaseType(M_pBaseType object) {
				return createM_pBaseTypeAdapter();
			}
			@Override
			public Adapter caseM_pFormalMessageType(M_pFormalMessageType object) {
				return createM_pFormalMessageTypeAdapter();
			}
			@Override
			public Adapter caseM_pModelObjectType(M_pModelObjectType object) {
				return createM_pModelObjectTypeAdapter();
			}
			@Override
			public Adapter caseM_pRootType(M_pRootType object) {
				return createM_pRootTypeAdapter();
			}
			@Override
			public Adapter caseM_subjectType(M_subjectType object) {
				return createM_subjectTypeAdapter();
			}
			@Override
			public Adapter caseMatrixInstancesType(MatrixInstancesType object) {
				return createMatrixInstancesTypeAdapter();
			}
			@Override
			public Adapter caseNestedStateChartType(NestedStateChartType object) {
				return createNestedStateChartTypeAdapter();
			}
			@Override
			public Adapter caseObjectLinksType(ObjectLinksType object) {
				return createObjectLinksTypeAdapter();
			}
			@Override
			public Adapter caseOperationsType(OperationsType object) {
				return createOperationsTypeAdapter();
			}
			@Override
			public Adapter caseOwnerHandleType(OwnerHandleType object) {
				return createOwnerHandleTypeAdapter();
			}
			@Override
			public Adapter caseP_MessageHandlerType(P_MessageHandlerType object) {
				return createP_MessageHandlerTypeAdapter();
			}
			@Override
			public Adapter caseParentType(ParentType object) {
				return createParentTypeAdapter();
			}
			@Override
			public Adapter casePropertiesType(PropertiesType object) {
				return createPropertiesTypeAdapter();
			}
			@Override
			public Adapter caseTableDataDefinition(TableDataDefinition object) {
				return createTableDataDefinitionAdapter();
			}
			@Override
			public Adapter caseTableInstancesType(TableInstancesType object) {
				return createTableInstancesTypeAdapter();
			}
			@Override
			public Adapter caseTargetType(TargetType object) {
				return createTargetTypeAdapter();
			}
			@Override
			public Adapter caseTheMainDiagramType(TheMainDiagramType object) {
				return createTheMainDiagramTypeAdapter();
			}
			@Override
			public Adapter caseToLinkType(ToLinkType object) {
				return createToLinkTypeAdapter();
			}
			@Override
			public Adapter caseTransitionsType(TransitionsType object) {
				return createTransitionsTypeAdapter();
			}
			@Override
			public Adapter caseUnknownType(UnknownType object) {
				return createUnknownTypeAdapter();
			}
			@Override
			public Adapter caseValueType(ValueType object) {
				return createValueTypeAdapter();
			}
			@Override
			public Adapter caseEModelElement(EModelElement object) {
				return createEModelElementAdapter();
			}
			@Override
			public Adapter defaultCase(EObject object) {
				return createEObjectAdapter();
			}
		};

	/**
	 * Creates an adapter for the <code>target</code>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param target the object to adapt.
	 * @return the adapter for the <code>target</code>.
	 * @generated
	 */
	@Override
	public Adapter createAdapter(Notifier target) {
		return modelSwitch.doSwitch((EObject)target);
	}


	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.AssociationsType <em>Associations Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.AssociationsType
	 * @generated
	 */
	public Adapter createAssociationsTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CCollaborationChart <em>CCollaboration Chart</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CCollaborationChart
	 * @generated
	 */
	public Adapter createCCollaborationChartAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIActionState <em>CGI Action State</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIActionState
	 * @generated
	 */
	public Adapter createCGIActionStateAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIActiveX <em>CGI Active X</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIActiveX
	 * @generated
	 */
	public Adapter createCGIActiveXAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAnchor <em>CGI Anchor</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAnchor
	 * @generated
	 */
	public Adapter createCGIAnchorAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAnnotation <em>CGI Annotation</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAnnotation
	 * @generated
	 */
	public Adapter createCGIAnnotationAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIArrow <em>CGI Arrow</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIArrow
	 * @generated
	 */
	public Adapter createCGIArrowAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAssociationEnd <em>CGI Association End</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAssociationEnd
	 * @generated
	 */
	public Adapter createCGIAssociationEndAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAssociationRole <em>CGI Association Role</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIAssociationRole
	 * @generated
	 */
	public Adapter createCGIAssociationRoleAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIBasicClass <em>CGI Basic Class</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIBasicClass
	 * @generated
	 */
	public Adapter createCGIBasicClassAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIBlockState <em>CGI Block State</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIBlockState
	 * @generated
	 */
	public Adapter createCGIBlockStateAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIBox <em>CGI Box</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIBox
	 * @generated
	 */
	public Adapter createCGIBoxAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIButtonArray <em>CGI Button Array</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIButtonArray
	 * @generated
	 */
	public Adapter createCGIButtonArrayAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIClass <em>CGI Class</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIClass
	 * @generated
	 */
	public Adapter createCGIClassAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIClassChart <em>CGI Class Chart</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIClassChart
	 * @generated
	 */
	public Adapter createCGIClassChartAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIClassifierRole <em>CGI Classifier Role</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIClassifierRole
	 * @generated
	 */
	public Adapter createCGIClassifierRoleAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGICompartment <em>CGI Compartment</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGICompartment
	 * @generated
	 */
	public Adapter createCGICompartmentAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIComponent <em>CGI Component</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIComponent
	 * @generated
	 */
	public Adapter createCGIComponentAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGICompositeClass <em>CGI Composite Class</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGICompositeClass
	 * @generated
	 */
	public Adapter createCGICompositeClassAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIConnector <em>CGI Connector</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIConnector
	 * @generated
	 */
	public Adapter createCGIConnectorAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIContainArrow <em>CGI Contain Arrow</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIContainArrow
	 * @generated
	 */
	public Adapter createCGIContainArrowAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIDiagramFrame <em>CGI Diagram Frame</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIDiagramFrame
	 * @generated
	 */
	public Adapter createCGIDiagramFrameAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIFreeShape <em>CGI Free Shape</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIFreeShape
	 * @generated
	 */
	public Adapter createCGIFreeShapeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIFreeText <em>CGI Free Text</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIFreeText
	 * @generated
	 */
	public Adapter createCGIFreeTextAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIGenericElement <em>CGI Generic Element</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIGenericElement
	 * @generated
	 */
	public Adapter createCGIGenericElementAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIImage <em>CGI Image</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIImage
	 * @generated
	 */
	public Adapter createCGIImageAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIImageData <em>CGI Image Data</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIImageData
	 * @generated
	 */
	public Adapter createCGIImageDataAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIInformationFlow <em>CGI Information Flow</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIInformationFlow
	 * @generated
	 */
	public Adapter createCGIInformationFlowAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIInheritance <em>CGI Inheritance</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIInheritance
	 * @generated
	 */
	public Adapter createCGIInheritanceAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIMFCCtrl <em>CGIMFC Ctrl</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIMFCCtrl
	 * @generated
	 */
	public Adapter createCGIMFCCtrlAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIMessageLabel <em>CGI Message Label</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIMessageLabel
	 * @generated
	 */
	public Adapter createCGIMessageLabelAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIMscChart <em>CGI Msc Chart</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIMscChart
	 * @generated
	 */
	public Adapter createCGIMscChartAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIMscColumnCR <em>CGI Msc Column CR</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIMscColumnCR
	 * @generated
	 */
	public Adapter createCGIMscColumnCRAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIMscConditionMark <em>CGI Msc Condition Mark</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIMscConditionMark
	 * @generated
	 */
	public Adapter createCGIMscConditionMarkAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIMscExecutionOccurrence <em>CGI Msc Execution Occurrence</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIMscExecutionOccurrence
	 * @generated
	 */
	public Adapter createCGIMscExecutionOccurrenceAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIMscInteractionOccurrence <em>CGI Msc Interaction Occurrence</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIMscInteractionOccurrence
	 * @generated
	 */
	public Adapter createCGIMscInteractionOccurrenceAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIMscInteractionOperand <em>CGI Msc Interaction Operand</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIMscInteractionOperand
	 * @generated
	 */
	public Adapter createCGIMscInteractionOperandAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIMscInteractionOperator <em>CGI Msc Interaction Operator</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIMscInteractionOperator
	 * @generated
	 */
	public Adapter createCGIMscInteractionOperatorAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIMscMessage <em>CGI Msc Message</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIMscMessage
	 * @generated
	 */
	public Adapter createCGIMscMessageAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIObjectInstance <em>CGI Object Instance</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIObjectInstance
	 * @generated
	 */
	public Adapter createCGIObjectInstanceAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIObjectLink <em>CGI Object Link</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIObjectLink
	 * @generated
	 */
	public Adapter createCGIObjectLinkAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIPackage <em>CGI Package</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIPackage
	 * @generated
	 */
	public Adapter createCGIPackageAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIPartition <em>CGI Partition</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIPartition
	 * @generated
	 */
	public Adapter createCGIPartitionAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIPortConnector <em>CGI Port Connector</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIPortConnector
	 * @generated
	 */
	public Adapter createCGIPortConnectorAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIState <em>CGI State</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIState
	 * @generated
	 */
	public Adapter createCGIStateAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIStateChart <em>CGI State Chart</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIStateChart
	 * @generated
	 */
	public Adapter createCGIStateChartAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGISwimlaneFrame <em>CGI Swimlane Frame</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGISwimlaneFrame
	 * @generated
	 */
	public Adapter createCGISwimlaneFrameAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIText <em>CGI Text</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIText
	 * @generated
	 */
	public Adapter createCGITextAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGITextBox <em>CGI Text Box</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGITextBox
	 * @generated
	 */
	public Adapter createCGITextBoxAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGITrans <em>CGI Trans</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGITrans
	 * @generated
	 */
	public Adapter createCGITransAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CollEvent <em>Coll Event</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CollEvent
	 * @generated
	 */
	public Adapter createCollEventAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CompartmentsType <em>Compartments Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CompartmentsType
	 * @generated
	 */
	public Adapter createCompartmentsTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ComponentsType <em>Components Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ComponentsType
	 * @generated
	 */
	public Adapter createComponentsTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ConveyedType <em>Conveyed Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ConveyedType
	 * @generated
	 */
	public Adapter createConveyedTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.DeclarativesType <em>Declaratives Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.DeclarativesType
	 * @generated
	 */
	public Adapter createDeclarativesTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.DefaultSubsystemType <em>Default Subsystem Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.DefaultSubsystemType
	 * @generated
	 */
	public Adapter createDefaultSubsystemTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.DefaultTransType <em>Default Trans Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.DefaultTransType
	 * @generated
	 */
	public Adapter createDefaultTransTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.DependsOnType <em>Depends On Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.DependsOnType
	 * @generated
	 */
	public Adapter createDependsOnTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.DescriptionType <em>Description Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.DescriptionType
	 * @generated
	 */
	public Adapter createDescriptionTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ElementsType <em>Elements Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ElementsType
	 * @generated
	 */
	public Adapter createElementsTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.EmbededFilesType <em>Embeded Files Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.EmbededFilesType
	 * @generated
	 */
	public Adapter createEmbededFilesTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.End1_Type <em>End1 Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.End1_Type
	 * @generated
	 */
	public Adapter createEnd1_TypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.End2_Type <em>End2 Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.End2_Type
	 * @generated
	 */
	public Adapter createEnd2_TypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.FilesType <em>Files Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.FilesType
	 * @generated
	 */
	public Adapter createFilesTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.FromLinkType <em>From Link Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.FromLinkType
	 * @generated
	 */
	public Adapter createFromLinkTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.GraphElementsType <em>Graph Elements Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.GraphElementsType
	 * @generated
	 */
	public Adapter createGraphElementsTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.GraphicChartType <em>Graphic Chart Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.GraphicChartType
	 * @generated
	 */
	public Adapter createGraphicChartTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.HyperLinksType <em>Hyper Links Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.HyperLinksType
	 * @generated
	 */
	public Adapter createHyperLinksTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IAcceptEventAction <em>IAccept Event Action</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IAcceptEventAction
	 * @generated
	 */
	public Adapter createIAcceptEventActionAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IAcceptTimeEvent <em>IAccept Time Event</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IAcceptTimeEvent
	 * @generated
	 */
	public Adapter createIAcceptTimeEventAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IAction <em>IAction</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IAction
	 * @generated
	 */
	public Adapter createIActionAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IActivityDiagram <em>IActivity Diagram</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IActivityDiagram
	 * @generated
	 */
	public Adapter createIActivityDiagramAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IActivityGraph <em>IActivity Graph</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IActivityGraph
	 * @generated
	 */
	public Adapter createIActivityGraphAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IActor <em>IActor</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IActor
	 * @generated
	 */
	public Adapter createIActorAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IAnchor <em>IAnchor</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IAnchor
	 * @generated
	 */
	public Adapter createIAnchorAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IAnnotation <em>IAnnotation</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IAnnotation
	 * @generated
	 */
	public Adapter createIAnnotationAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IArgument <em>IArgument</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IArgument
	 * @generated
	 */
	public Adapter createIArgumentAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IAssociationClass <em>IAssociation Class</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IAssociationClass
	 * @generated
	 */
	public Adapter createIAssociationClassAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IAssociationEnd <em>IAssociation End</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IAssociationEnd
	 * @generated
	 */
	public Adapter createIAssociationEndAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IAssociationEndHandle <em>IAssociation End Handle</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IAssociationEndHandle
	 * @generated
	 */
	public Adapter createIAssociationEndHandleAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IAssociationRole <em>IAssociation Role</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IAssociationRole
	 * @generated
	 */
	public Adapter createIAssociationRoleAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IAttribute <em>IAttribute</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IAttribute
	 * @generated
	 */
	public Adapter createIAttributeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IBlock <em>IBlock</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IBlock
	 * @generated
	 */
	public Adapter createIBlockAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IBody <em>IBody</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IBody
	 * @generated
	 */
	public Adapter createIBodyAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IBranch <em>IBranch</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IBranch
	 * @generated
	 */
	public Adapter createIBranchAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ICallAction <em>ICall Action</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ICallAction
	 * @generated
	 */
	public Adapter createICallActionAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ICallOperation <em>ICall Operation</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ICallOperation
	 * @generated
	 */
	public Adapter createICallOperationAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IClass <em>IClass</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IClass
	 * @generated
	 */
	public Adapter createIClassAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IClassHandle <em>IClass Handle</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IClassHandle
	 * @generated
	 */
	public Adapter createIClassHandleAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IClassInstance <em>IClass Instance</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IClassInstance
	 * @generated
	 */
	public Adapter createIClassInstanceAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IClassifier <em>IClassifier</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IClassifier
	 * @generated
	 */
	public Adapter createIClassifierAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IClassifierRole <em>IClassifier Role</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IClassifierRole
	 * @generated
	 */
	public Adapter createIClassifierRoleAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ICodeGenConfigInfo <em>ICode Gen Config Info</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ICodeGenConfigInfo
	 * @generated
	 */
	public Adapter createICodeGenConfigInfoAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ICodeGenConfigInfoHandle <em>ICode Gen Config Info Handle</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ICodeGenConfigInfoHandle
	 * @generated
	 */
	public Adapter createICodeGenConfigInfoHandleAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ICollaboration <em>ICollaboration</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ICollaboration
	 * @generated
	 */
	public Adapter createICollaborationAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ICollaborationDiagram <em>ICollaboration Diagram</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ICollaborationDiagram
	 * @generated
	 */
	public Adapter createICollaborationDiagramAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IColor <em>IColor</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IColor
	 * @generated
	 */
	public Adapter createIColorAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ICombinedFragment <em>ICombined Fragment</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ICombinedFragment
	 * @generated
	 */
	public Adapter createICombinedFragmentAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IComment <em>IComment</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IComment
	 * @generated
	 */
	public Adapter createICommentAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IComponent <em>IComponent</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IComponent
	 * @generated
	 */
	public Adapter createIComponentAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IComponentDiagram <em>IComponent Diagram</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IComponentDiagram
	 * @generated
	 */
	public Adapter createIComponentDiagramAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IComponentInstance <em>IComponent Instance</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IComponentInstance
	 * @generated
	 */
	public Adapter createIComponentInstanceAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IConfiguration <em>IConfiguration</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IConfiguration
	 * @generated
	 */
	public Adapter createIConfigurationAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IConnector <em>IConnector</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IConnector
	 * @generated
	 */
	public Adapter createIConnectorAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IConstraint <em>IConstraint</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IConstraint
	 * @generated
	 */
	public Adapter createIConstraintAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IConstructor <em>IConstructor</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IConstructor
	 * @generated
	 */
	public Adapter createIConstructorAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IContextSpecification <em>IContext Specification</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IContextSpecification
	 * @generated
	 */
	public Adapter createIContextSpecificationAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IControlledFile <em>IControlled File</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IControlledFile
	 * @generated
	 */
	public Adapter createIControlledFileAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IDefaultDrvdTrans <em>IDefault Drvd Trans</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IDefaultDrvdTrans
	 * @generated
	 */
	public Adapter createIDefaultDrvdTransAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IDependency <em>IDependency</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IDependency
	 * @generated
	 */
	public Adapter createIDependencyAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IDeploymentDiagram <em>IDeployment Diagram</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IDeploymentDiagram
	 * @generated
	 */
	public Adapter createIDeploymentDiagramAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IDescription <em>IDescription</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IDescription
	 * @generated
	 */
	public Adapter createIDescriptionAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IDestructor <em>IDestructor</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IDestructor
	 * @generated
	 */
	public Adapter createIDestructorAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IDiagram <em>IDiagram</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IDiagram
	 * @generated
	 */
	public Adapter createIDiagramAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IEmbededFile <em>IEmbeded File</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IEmbededFile
	 * @generated
	 */
	public Adapter createIEmbededFileAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IEnumerationLiteral <em>IEnumeration Literal</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IEnumerationLiteral
	 * @generated
	 */
	public Adapter createIEnumerationLiteralAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IEvent <em>IEvent</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IEvent
	 * @generated
	 */
	public Adapter createIEventAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IEventHandle <em>IEvent Handle</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IEventHandle
	 * @generated
	 */
	public Adapter createIEventHandleAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IEventReception <em>IEvent Reception</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IEventReception
	 * @generated
	 */
	public Adapter createIEventReceptionAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IExecutionOccurrence <em>IExecution Occurrence</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IExecutionOccurrence
	 * @generated
	 */
	public Adapter createIExecutionOccurrenceAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IExternalHyperlink <em>IExternal Hyperlink</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IExternalHyperlink
	 * @generated
	 */
	public Adapter createIExternalHyperlinkAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IFile <em>IFile</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IFile
	 * @generated
	 */
	public Adapter createIFileAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IFileFragment <em>IFile Fragment</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IFileFragment
	 * @generated
	 */
	public Adapter createIFileFragmentAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IFlow <em>IFlow</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IFlow
	 * @generated
	 */
	public Adapter createIFlowAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IFlowItem <em>IFlow Item</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IFlowItem
	 * @generated
	 */
	public Adapter createIFlowItemAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IFlowchart <em>IFlowchart</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IFlowchart
	 * @generated
	 */
	public Adapter createIFlowchartAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IFolder <em>IFolder</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IFolder
	 * @generated
	 */
	public Adapter createIFolderAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IFork <em>IFork</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IFork
	 * @generated
	 */
	public Adapter createIForkAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IGeneralization <em>IGeneralization</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IGeneralization
	 * @generated
	 */
	public Adapter createIGeneralizationAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IGuard <em>IGuard</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IGuard
	 * @generated
	 */
	public Adapter createIGuardAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IHandleWithData <em>IHandle With Data</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IHandleWithData
	 * @generated
	 */
	public Adapter createIHandleWithDataAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IHistoryConnector <em>IHistory Connector</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IHistoryConnector
	 * @generated
	 */
	public Adapter createIHistoryConnectorAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IHyperLink <em>IHyper Link</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IHyperLink
	 * @generated
	 */
	public Adapter createIHyperLinkAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IInformationFlow <em>IInformation Flow</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IInformationFlow
	 * @generated
	 */
	public Adapter createIInformationFlowAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IInformationItem <em>IInformation Item</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IInformationItem
	 * @generated
	 */
	public Adapter createIInformationItemAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IInstance <em>IInstance</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IInstance
	 * @generated
	 */
	public Adapter createIInstanceAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IInstanceSlot <em>IInstance Slot</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IInstanceSlot
	 * @generated
	 */
	public Adapter createIInstanceSlotAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IInstanceSpecification <em>IInstance Specification</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IInstanceSpecification
	 * @generated
	 */
	public Adapter createIInstanceSpecificationAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IInstanceValue <em>IInstance Value</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IInstanceValue
	 * @generated
	 */
	public Adapter createIInstanceValueAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IInteractionOccurrence <em>IInteraction Occurrence</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IInteractionOccurrence
	 * @generated
	 */
	public Adapter createIInteractionOccurrenceAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IInteractionOperand <em>IInteraction Operand</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IInteractionOperand
	 * @generated
	 */
	public Adapter createIInteractionOperandAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IInteractionOperator <em>IInteraction Operator</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IInteractionOperator
	 * @generated
	 */
	public Adapter createIInteractionOperatorAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IInterfaceItem <em>IInterface Item</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IInterfaceItem
	 * @generated
	 */
	public Adapter createIInterfaceItemAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IInterfaceItemTrigger <em>IInterface Item Trigger</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IInterfaceItemTrigger
	 * @generated
	 */
	public Adapter createIInterfaceItemTriggerAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IInternalHyperlink <em>IInternal Hyperlink</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IInternalHyperlink
	 * @generated
	 */
	public Adapter createIInternalHyperlinkAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ILabel <em>ILabel</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ILabel
	 * @generated
	 */
	public Adapter createILabelAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ILink <em>ILink</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ILink
	 * @generated
	 */
	public Adapter createILinkAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ILinkInstance <em>ILink Instance</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ILinkInstance
	 * @generated
	 */
	public Adapter createILinkInstanceAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ILiteralSpecification <em>ILiteral Specification</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ILiteralSpecification
	 * @generated
	 */
	public Adapter createILiteralSpecificationAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IMHyperLink <em>IM Hyper Link</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IMHyperLink
	 * @generated
	 */
	public Adapter createIMHyperLinkAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IMSC <em>IMSC</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IMSC
	 * @generated
	 */
	public Adapter createIMSCAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IMatrixInstance <em>IMatrix Instance</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IMatrixInstance
	 * @generated
	 */
	public Adapter createIMatrixInstanceAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IMatrixLayout <em>IMatrix Layout</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IMatrixLayout
	 * @generated
	 */
	public Adapter createIMatrixLayoutAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IMatrixView <em>IMatrix View</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IMatrixView
	 * @generated
	 */
	public Adapter createIMatrixViewAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IMessage <em>IMessage</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IMessage
	 * @generated
	 */
	public Adapter createIMessageAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IMessagePoint <em>IMessage Point</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IMessagePoint
	 * @generated
	 */
	public Adapter createIMessagePointAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IMetaLinkHandle <em>IMeta Link Handle</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IMetaLinkHandle
	 * @generated
	 */
	public Adapter createIMetaLinkHandleAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IModelElement <em>IModel Element</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IModelElement
	 * @generated
	 */
	public Adapter createIModelElementAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IModule <em>IModule</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IModule
	 * @generated
	 */
	public Adapter createIModuleAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IMultiplicityItem <em>IMultiplicity Item</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IMultiplicityItem
	 * @generated
	 */
	public Adapter createIMultiplicityItemAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.INode <em>INode</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.INode
	 * @generated
	 */
	public Adapter createINodeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IObjectLink <em>IObject Link</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IObjectLink
	 * @generated
	 */
	public Adapter createIObjectLinkAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IObjectLinkHandle <em>IObject Link Handle</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IObjectLinkHandle
	 * @generated
	 */
	public Adapter createIObjectLinkHandleAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IObjectModelDiagram <em>IObject Model Diagram</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IObjectModelDiagram
	 * @generated
	 */
	public Adapter createIObjectModelDiagramAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IObjectNode <em>IObject Node</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IObjectNode
	 * @generated
	 */
	public Adapter createIObjectNodeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IOperation <em>IOperation</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IOperation
	 * @generated
	 */
	public Adapter createIOperationAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IPackage <em>IPackage</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IPackage
	 * @generated
	 */
	public Adapter createIPackageAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IPanelDiagram <em>IPanel Diagram</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IPanelDiagram
	 * @generated
	 */
	public Adapter createIPanelDiagramAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IPart <em>IPart</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IPart
	 * @generated
	 */
	public Adapter createIPartAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IPin <em>IPin</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IPin
	 * @generated
	 */
	public Adapter createIPinAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IPort <em>IPort</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IPort
	 * @generated
	 */
	public Adapter createIPortAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IPrimitiveOperation <em>IPrimitive Operation</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IPrimitiveOperation
	 * @generated
	 */
	public Adapter createIPrimitiveOperationAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IProfile <em>IProfile</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IProfile
	 * @generated
	 */
	public Adapter createIProfileAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IProject <em>IProject</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IProject
	 * @generated
	 */
	public Adapter createIProjectAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IProperty <em>IProperty</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IProperty
	 * @generated
	 */
	public Adapter createIPropertyAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IPropertyContainer <em>IProperty Container</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IPropertyContainer
	 * @generated
	 */
	public Adapter createIPropertyContainerAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IPropertyMetaclass <em>IProperty Metaclass</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IPropertyMetaclass
	 * @generated
	 */
	public Adapter createIPropertyMetaclassAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IPropertySubject <em>IProperty Subject</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IPropertySubject
	 * @generated
	 */
	public Adapter createIPropertySubjectAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IReception <em>IReception</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IReception
	 * @generated
	 */
	public Adapter createIReceptionAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IReferenceActivity <em>IReference Activity</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IReferenceActivity
	 * @generated
	 */
	public Adapter createIReferenceActivityAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IRelation <em>IRelation</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IRelation
	 * @generated
	 */
	public Adapter createIRelationAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IRequirement <em>IRequirement</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IRequirement
	 * @generated
	 */
	public Adapter createIRequirementAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ISendAction <em>ISend Action</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ISendAction
	 * @generated
	 */
	public Adapter createISendActionAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ISequenceDiagram <em>ISequence Diagram</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ISequenceDiagram
	 * @generated
	 */
	public Adapter createISequenceDiagramAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ISlot <em>ISlot</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ISlot
	 * @generated
	 */
	public Adapter createISlotAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IState <em>IState</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IState
	 * @generated
	 */
	public Adapter createIStateAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IStateChart <em>IState Chart</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IStateChart
	 * @generated
	 */
	public Adapter createIStateChartAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IStateChartDiagram <em>IState Chart Diagram</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IStateChartDiagram
	 * @generated
	 */
	public Adapter createIStateChartDiagramAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IStateVertex <em>IState Vertex</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IStateVertex
	 * @generated
	 */
	public Adapter createIStateVertexAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IStereotype <em>IStereotype</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IStereotype
	 * @generated
	 */
	public Adapter createIStereotypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IStructureDiagram <em>IStructure Diagram</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IStructureDiagram
	 * @generated
	 */
	public Adapter createIStructureDiagramAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ISubsystem <em>ISubsystem</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ISubsystem
	 * @generated
	 */
	public Adapter createISubsystemAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ISwimlane <em>ISwimlane</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ISwimlane
	 * @generated
	 */
	public Adapter createISwimlaneAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ISysMLPort <em>ISys ML Port</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ISysMLPort
	 * @generated
	 */
	public Adapter createISysMLPortAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ITableInstance <em>ITable Instance</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ITableInstance
	 * @generated
	 */
	public Adapter createITableInstanceAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ITableLayout <em>ITable Layout</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ITableLayout
	 * @generated
	 */
	public Adapter createITableLayoutAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ITableView <em>ITable View</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ITableView
	 * @generated
	 */
	public Adapter createITableViewAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ITag <em>ITag</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ITag
	 * @generated
	 */
	public Adapter createITagAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ITemplateInst <em>ITemplate Inst</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ITemplateInst
	 * @generated
	 */
	public Adapter createITemplateInstAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ITemplateInstParam <em>ITemplate Inst Param</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ITemplateInstParam
	 * @generated
	 */
	public Adapter createITemplateInstParamAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ITemplateInstantiation <em>ITemplate Instantiation</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ITemplateInstantiation
	 * @generated
	 */
	public Adapter createITemplateInstantiationAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ITemplateInstantiationParameter <em>ITemplate Instantiation Parameter</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ITemplateInstantiationParameter
	 * @generated
	 */
	public Adapter createITemplateInstantiationParameterAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ITemplateParameter <em>ITemplate Parameter</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ITemplateParameter
	 * @generated
	 */
	public Adapter createITemplateParameterAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ITimeEvent <em>ITime Event</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ITimeEvent
	 * @generated
	 */
	public Adapter createITimeEventAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ITimeout <em>ITimeout</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ITimeout
	 * @generated
	 */
	public Adapter createITimeoutAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ITransition <em>ITransition</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ITransition
	 * @generated
	 */
	public Adapter createITransitionAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ITrigger <em>ITrigger</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ITrigger
	 * @generated
	 */
	public Adapter createITriggerAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ITriggered <em>ITriggered</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ITriggered
	 * @generated
	 */
	public Adapter createITriggeredAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IType <em>IType</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IType
	 * @generated
	 */
	public Adapter createITypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IUCDiagram <em>IUC Diagram</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IUCDiagram
	 * @generated
	 */
	public Adapter createIUCDiagramAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IUnit <em>IUnit</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IUnit
	 * @generated
	 */
	public Adapter createIUnitAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IUseCase <em>IUse Case</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IUseCase
	 * @generated
	 */
	public Adapter createIUseCaseAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IUseCaseDiagram <em>IUse Case Diagram</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IUseCaseDiagram
	 * @generated
	 */
	public Adapter createIUseCaseDiagramAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IUseCaseStereoType <em>IUse Case Stereo Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IUseCaseStereoType
	 * @generated
	 */
	public Adapter createIUseCaseStereoTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IValueSpecification <em>IValue Specification</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IValueSpecification
	 * @generated
	 */
	public Adapter createIValueSpecificationAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IVariable <em>IVariable</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IVariable
	 * @generated
	 */
	public Adapter createIVariableAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.InverseType <em>Inverse Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.InverseType
	 * @generated
	 */
	public Adapter createInverseTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ItemsType <em>Items Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ItemsType
	 * @generated
	 */
	public Adapter createItemsTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ItsLabelType <em>Its Label Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ItsLabelType
	 * @generated
	 */
	public Adapter createItsLabelTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ItsStateChartType <em>Its State Chart Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ItsStateChartType
	 * @generated
	 */
	public Adapter createItsStateChartTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ItsTargetType <em>Its Target Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ItsTargetType
	 * @generated
	 */
	public Adapter createItsTargetTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ItsTriggerType <em>Its Trigger Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ItsTriggerType
	 * @generated
	 */
	public Adapter createItsTriggerTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.LinksType <em>Links Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.LinksType
	 * @generated
	 */
	public Adapter createLinksTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.M_hTargetType <em>MhTarget Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.M_hTargetType
	 * @generated
	 */
	public Adapter createM_hTargetTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.M_pBaseType <em>MpBase Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.M_pBaseType
	 * @generated
	 */
	public Adapter createM_pBaseTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.M_pFormalMessageType <em>MpFormal Message Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.M_pFormalMessageType
	 * @generated
	 */
	public Adapter createM_pFormalMessageTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.M_pModelObjectType <em>MpModel Object Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.M_pModelObjectType
	 * @generated
	 */
	public Adapter createM_pModelObjectTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.M_pRootType <em>MpRoot Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.M_pRootType
	 * @generated
	 */
	public Adapter createM_pRootTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.M_subjectType <em>Msubject Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.M_subjectType
	 * @generated
	 */
	public Adapter createM_subjectTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.MatrixInstancesType <em>Matrix Instances Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.MatrixInstancesType
	 * @generated
	 */
	public Adapter createMatrixInstancesTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.NestedStateChartType <em>Nested State Chart Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.NestedStateChartType
	 * @generated
	 */
	public Adapter createNestedStateChartTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ObjectLinksType <em>Object Links Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ObjectLinksType
	 * @generated
	 */
	public Adapter createObjectLinksTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.OperationsType <em>Operations Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.OperationsType
	 * @generated
	 */
	public Adapter createOperationsTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.OwnerHandleType <em>Owner Handle Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.OwnerHandleType
	 * @generated
	 */
	public Adapter createOwnerHandleTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.P_MessageHandlerType <em>PMessage Handler Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.P_MessageHandlerType
	 * @generated
	 */
	public Adapter createP_MessageHandlerTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ParentType <em>Parent Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ParentType
	 * @generated
	 */
	public Adapter createParentTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.PropertiesType <em>Properties Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.PropertiesType
	 * @generated
	 */
	public Adapter createPropertiesTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.TableDataDefinition <em>Table Data Definition</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.TableDataDefinition
	 * @generated
	 */
	public Adapter createTableDataDefinitionAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.TableInstancesType <em>Table Instances Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.TableInstancesType
	 * @generated
	 */
	public Adapter createTableInstancesTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.TargetType <em>Target Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.TargetType
	 * @generated
	 */
	public Adapter createTargetTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.TheMainDiagramType <em>The Main Diagram Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.TheMainDiagramType
	 * @generated
	 */
	public Adapter createTheMainDiagramTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ToLinkType <em>To Link Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ToLinkType
	 * @generated
	 */
	public Adapter createToLinkTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.TransitionsType <em>Transitions Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.TransitionsType
	 * @generated
	 */
	public Adapter createTransitionsTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.UnknownType <em>Unknown Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.UnknownType
	 * @generated
	 */
	public Adapter createUnknownTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ValueType <em>Value Type</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.ValueType
	 * @generated
	 */
	public Adapter createValueTypeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.emf.ecore.EModelElement <em>EModel Element</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.emf.ecore.EModelElement
	 * @generated
	 */
	public Adapter createEModelElementAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for the default case.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @generated
	 */
	public Adapter createEObjectAdapter() {
		return null;
	}

} //UMLRpyAdapterFactory
