/**
 *   Copyright (c) 2016 CEA LIST and others.
 *   
 *   All rights reserved. This program and the accompanying materials
 *   are made available under the terms of the Eclipse Public License v1.0
 *   which accompanies this distribution, and is available at
 *   http://www.eclipse.org/legal/epl-v10.html
 *  
 *   Contributors:
 *     CEA LIST - Initial API and implementation
 * 
 */
package org.eclipse.papyrus.interoperability.rpy.rpymetamodel;

import org.eclipse.emf.ecore.EFactory;

/**
 * <!-- begin-user-doc -->
 * The <b>Factory</b> for the model.
 * It provides a create method for each non-abstract class of the model.
 * <!-- end-user-doc -->
 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.UMLRpyPackage
 * @generated
 */
public interface UMLRpyFactory extends EFactory {
	/**
	 * The singleton instance of the factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	UMLRpyFactory eINSTANCE = org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl.UMLRpyFactoryImpl.init();

	/**
	 * Returns a new object of class '<em>CCollaboration Chart</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>CCollaboration Chart</em>'.
	 * @generated
	 */
	CCollaborationChart createCCollaborationChart();

	/**
	 * Returns a new object of class '<em>CGI Action State</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>CGI Action State</em>'.
	 * @generated
	 */
	CGIActionState createCGIActionState();

	/**
	 * Returns a new object of class '<em>CGI Active X</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>CGI Active X</em>'.
	 * @generated
	 */
	CGIActiveX createCGIActiveX();

	/**
	 * Returns a new object of class '<em>CGI Anchor</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>CGI Anchor</em>'.
	 * @generated
	 */
	CGIAnchor createCGIAnchor();

	/**
	 * Returns a new object of class '<em>CGI Annotation</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>CGI Annotation</em>'.
	 * @generated
	 */
	CGIAnnotation createCGIAnnotation();

	/**
	 * Returns a new object of class '<em>CGI Arrow</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>CGI Arrow</em>'.
	 * @generated
	 */
	CGIArrow createCGIArrow();

	/**
	 * Returns a new object of class '<em>CGI Association End</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>CGI Association End</em>'.
	 * @generated
	 */
	CGIAssociationEnd createCGIAssociationEnd();

	/**
	 * Returns a new object of class '<em>CGI Association Role</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>CGI Association Role</em>'.
	 * @generated
	 */
	CGIAssociationRole createCGIAssociationRole();

	/**
	 * Returns a new object of class '<em>CGI Basic Class</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>CGI Basic Class</em>'.
	 * @generated
	 */
	CGIBasicClass createCGIBasicClass();

	/**
	 * Returns a new object of class '<em>CGI Block State</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>CGI Block State</em>'.
	 * @generated
	 */
	CGIBlockState createCGIBlockState();

	/**
	 * Returns a new object of class '<em>CGI Box</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>CGI Box</em>'.
	 * @generated
	 */
	CGIBox createCGIBox();

	/**
	 * Returns a new object of class '<em>CGI Button Array</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>CGI Button Array</em>'.
	 * @generated
	 */
	CGIButtonArray createCGIButtonArray();

	/**
	 * Returns a new object of class '<em>CGI Class</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>CGI Class</em>'.
	 * @generated
	 */
	CGIClass createCGIClass();

	/**
	 * Returns a new object of class '<em>CGI Class Chart</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>CGI Class Chart</em>'.
	 * @generated
	 */
	CGIClassChart createCGIClassChart();

	/**
	 * Returns a new object of class '<em>CGI Classifier Role</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>CGI Classifier Role</em>'.
	 * @generated
	 */
	CGIClassifierRole createCGIClassifierRole();

	/**
	 * Returns a new object of class '<em>CGI Compartment</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>CGI Compartment</em>'.
	 * @generated
	 */
	CGICompartment createCGICompartment();

	/**
	 * Returns a new object of class '<em>CGI Component</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>CGI Component</em>'.
	 * @generated
	 */
	CGIComponent createCGIComponent();

	/**
	 * Returns a new object of class '<em>CGI Composite Class</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>CGI Composite Class</em>'.
	 * @generated
	 */
	CGICompositeClass createCGICompositeClass();

	/**
	 * Returns a new object of class '<em>CGI Connector</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>CGI Connector</em>'.
	 * @generated
	 */
	CGIConnector createCGIConnector();

	/**
	 * Returns a new object of class '<em>CGI Contain Arrow</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>CGI Contain Arrow</em>'.
	 * @generated
	 */
	CGIContainArrow createCGIContainArrow();

	/**
	 * Returns a new object of class '<em>CGI Diagram Frame</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>CGI Diagram Frame</em>'.
	 * @generated
	 */
	CGIDiagramFrame createCGIDiagramFrame();

	/**
	 * Returns a new object of class '<em>CGI Free Shape</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>CGI Free Shape</em>'.
	 * @generated
	 */
	CGIFreeShape createCGIFreeShape();

	/**
	 * Returns a new object of class '<em>CGI Free Text</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>CGI Free Text</em>'.
	 * @generated
	 */
	CGIFreeText createCGIFreeText();

	/**
	 * Returns a new object of class '<em>CGI Generic Element</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>CGI Generic Element</em>'.
	 * @generated
	 */
	CGIGenericElement createCGIGenericElement();

	/**
	 * Returns a new object of class '<em>CGI Image</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>CGI Image</em>'.
	 * @generated
	 */
	CGIImage createCGIImage();

	/**
	 * Returns a new object of class '<em>CGI Image Data</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>CGI Image Data</em>'.
	 * @generated
	 */
	CGIImageData createCGIImageData();

	/**
	 * Returns a new object of class '<em>CGI Information Flow</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>CGI Information Flow</em>'.
	 * @generated
	 */
	CGIInformationFlow createCGIInformationFlow();

	/**
	 * Returns a new object of class '<em>CGI Inheritance</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>CGI Inheritance</em>'.
	 * @generated
	 */
	CGIInheritance createCGIInheritance();

	/**
	 * Returns a new object of class '<em>CGIMFC Ctrl</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>CGIMFC Ctrl</em>'.
	 * @generated
	 */
	CGIMFCCtrl createCGIMFCCtrl();

	/**
	 * Returns a new object of class '<em>CGI Message Label</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>CGI Message Label</em>'.
	 * @generated
	 */
	CGIMessageLabel createCGIMessageLabel();

	/**
	 * Returns a new object of class '<em>CGI Msc Chart</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>CGI Msc Chart</em>'.
	 * @generated
	 */
	CGIMscChart createCGIMscChart();

	/**
	 * Returns a new object of class '<em>CGI Msc Column CR</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>CGI Msc Column CR</em>'.
	 * @generated
	 */
	CGIMscColumnCR createCGIMscColumnCR();

	/**
	 * Returns a new object of class '<em>CGI Msc Condition Mark</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>CGI Msc Condition Mark</em>'.
	 * @generated
	 */
	CGIMscConditionMark createCGIMscConditionMark();

	/**
	 * Returns a new object of class '<em>CGI Msc Execution Occurrence</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>CGI Msc Execution Occurrence</em>'.
	 * @generated
	 */
	CGIMscExecutionOccurrence createCGIMscExecutionOccurrence();

	/**
	 * Returns a new object of class '<em>CGI Msc Interaction Occurrence</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>CGI Msc Interaction Occurrence</em>'.
	 * @generated
	 */
	CGIMscInteractionOccurrence createCGIMscInteractionOccurrence();

	/**
	 * Returns a new object of class '<em>CGI Msc Interaction Operand</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>CGI Msc Interaction Operand</em>'.
	 * @generated
	 */
	CGIMscInteractionOperand createCGIMscInteractionOperand();

	/**
	 * Returns a new object of class '<em>CGI Msc Interaction Operator</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>CGI Msc Interaction Operator</em>'.
	 * @generated
	 */
	CGIMscInteractionOperator createCGIMscInteractionOperator();

	/**
	 * Returns a new object of class '<em>CGI Msc Message</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>CGI Msc Message</em>'.
	 * @generated
	 */
	CGIMscMessage createCGIMscMessage();

	/**
	 * Returns a new object of class '<em>CGI Object Instance</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>CGI Object Instance</em>'.
	 * @generated
	 */
	CGIObjectInstance createCGIObjectInstance();

	/**
	 * Returns a new object of class '<em>CGI Object Link</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>CGI Object Link</em>'.
	 * @generated
	 */
	CGIObjectLink createCGIObjectLink();

	/**
	 * Returns a new object of class '<em>CGI Package</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>CGI Package</em>'.
	 * @generated
	 */
	CGIPackage createCGIPackage();

	/**
	 * Returns a new object of class '<em>CGI Partition</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>CGI Partition</em>'.
	 * @generated
	 */
	CGIPartition createCGIPartition();

	/**
	 * Returns a new object of class '<em>CGI Port Connector</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>CGI Port Connector</em>'.
	 * @generated
	 */
	CGIPortConnector createCGIPortConnector();

	/**
	 * Returns a new object of class '<em>CGI State</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>CGI State</em>'.
	 * @generated
	 */
	CGIState createCGIState();

	/**
	 * Returns a new object of class '<em>CGI State Chart</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>CGI State Chart</em>'.
	 * @generated
	 */
	CGIStateChart createCGIStateChart();

	/**
	 * Returns a new object of class '<em>CGI Swimlane Frame</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>CGI Swimlane Frame</em>'.
	 * @generated
	 */
	CGISwimlaneFrame createCGISwimlaneFrame();

	/**
	 * Returns a new object of class '<em>CGI Text</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>CGI Text</em>'.
	 * @generated
	 */
	CGIText createCGIText();

	/**
	 * Returns a new object of class '<em>CGI Text Box</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>CGI Text Box</em>'.
	 * @generated
	 */
	CGITextBox createCGITextBox();

	/**
	 * Returns a new object of class '<em>CGI Trans</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>CGI Trans</em>'.
	 * @generated
	 */
	CGITrans createCGITrans();

	/**
	 * Returns a new object of class '<em>Coll Event</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Coll Event</em>'.
	 * @generated
	 */
	CollEvent createCollEvent();

	/**
	 * Returns a new object of class '<em>IAccept Event Action</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>IAccept Event Action</em>'.
	 * @generated
	 */
	IAcceptEventAction createIAcceptEventAction();

	/**
	 * Returns a new object of class '<em>IAccept Time Event</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>IAccept Time Event</em>'.
	 * @generated
	 */
	IAcceptTimeEvent createIAcceptTimeEvent();

	/**
	 * Returns a new object of class '<em>IAction</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>IAction</em>'.
	 * @generated
	 */
	IAction createIAction();

	/**
	 * Returns a new object of class '<em>IActivity Diagram</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>IActivity Diagram</em>'.
	 * @generated
	 */
	IActivityDiagram createIActivityDiagram();

	/**
	 * Returns a new object of class '<em>IActivity Graph</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>IActivity Graph</em>'.
	 * @generated
	 */
	IActivityGraph createIActivityGraph();

	/**
	 * Returns a new object of class '<em>IActor</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>IActor</em>'.
	 * @generated
	 */
	IActor createIActor();

	/**
	 * Returns a new object of class '<em>IAnchor</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>IAnchor</em>'.
	 * @generated
	 */
	IAnchor createIAnchor();

	/**
	 * Returns a new object of class '<em>IAnnotation</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>IAnnotation</em>'.
	 * @generated
	 */
	IAnnotation createIAnnotation();

	/**
	 * Returns a new object of class '<em>IArgument</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>IArgument</em>'.
	 * @generated
	 */
	IArgument createIArgument();

	/**
	 * Returns a new object of class '<em>IAssociation Class</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>IAssociation Class</em>'.
	 * @generated
	 */
	IAssociationClass createIAssociationClass();

	/**
	 * Returns a new object of class '<em>IAssociation End</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>IAssociation End</em>'.
	 * @generated
	 */
	IAssociationEnd createIAssociationEnd();

	/**
	 * Returns a new object of class '<em>IAssociation End Handle</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>IAssociation End Handle</em>'.
	 * @generated
	 */
	IAssociationEndHandle createIAssociationEndHandle();

	/**
	 * Returns a new object of class '<em>IAssociation Role</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>IAssociation Role</em>'.
	 * @generated
	 */
	IAssociationRole createIAssociationRole();

	/**
	 * Returns a new object of class '<em>IAttribute</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>IAttribute</em>'.
	 * @generated
	 */
	IAttribute createIAttribute();

	/**
	 * Returns a new object of class '<em>IBlock</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>IBlock</em>'.
	 * @generated
	 */
	IBlock createIBlock();

	/**
	 * Returns a new object of class '<em>IBody</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>IBody</em>'.
	 * @generated
	 */
	IBody createIBody();

	/**
	 * Returns a new object of class '<em>IBranch</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>IBranch</em>'.
	 * @generated
	 */
	IBranch createIBranch();

	/**
	 * Returns a new object of class '<em>ICall Action</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>ICall Action</em>'.
	 * @generated
	 */
	ICallAction createICallAction();

	/**
	 * Returns a new object of class '<em>ICall Operation</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>ICall Operation</em>'.
	 * @generated
	 */
	ICallOperation createICallOperation();

	/**
	 * Returns a new object of class '<em>IClass</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>IClass</em>'.
	 * @generated
	 */
	IClass createIClass();

	/**
	 * Returns a new object of class '<em>IClass Handle</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>IClass Handle</em>'.
	 * @generated
	 */
	IClassHandle createIClassHandle();

	/**
	 * Returns a new object of class '<em>IClass Instance</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>IClass Instance</em>'.
	 * @generated
	 */
	IClassInstance createIClassInstance();

	/**
	 * Returns a new object of class '<em>IClassifier</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>IClassifier</em>'.
	 * @generated
	 */
	IClassifier createIClassifier();

	/**
	 * Returns a new object of class '<em>IClassifier Role</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>IClassifier Role</em>'.
	 * @generated
	 */
	IClassifierRole createIClassifierRole();

	/**
	 * Returns a new object of class '<em>ICode Gen Config Info</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>ICode Gen Config Info</em>'.
	 * @generated
	 */
	ICodeGenConfigInfo createICodeGenConfigInfo();

	/**
	 * Returns a new object of class '<em>ICode Gen Config Info Handle</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>ICode Gen Config Info Handle</em>'.
	 * @generated
	 */
	ICodeGenConfigInfoHandle createICodeGenConfigInfoHandle();

	/**
	 * Returns a new object of class '<em>ICollaboration</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>ICollaboration</em>'.
	 * @generated
	 */
	ICollaboration createICollaboration();

	/**
	 * Returns a new object of class '<em>ICollaboration Diagram</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>ICollaboration Diagram</em>'.
	 * @generated
	 */
	ICollaborationDiagram createICollaborationDiagram();

	/**
	 * Returns a new object of class '<em>IColor</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>IColor</em>'.
	 * @generated
	 */
	IColor createIColor();

	/**
	 * Returns a new object of class '<em>ICombined Fragment</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>ICombined Fragment</em>'.
	 * @generated
	 */
	ICombinedFragment createICombinedFragment();

	/**
	 * Returns a new object of class '<em>IComment</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>IComment</em>'.
	 * @generated
	 */
	IComment createIComment();

	/**
	 * Returns a new object of class '<em>IComponent</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>IComponent</em>'.
	 * @generated
	 */
	IComponent createIComponent();

	/**
	 * Returns a new object of class '<em>IComponent Diagram</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>IComponent Diagram</em>'.
	 * @generated
	 */
	IComponentDiagram createIComponentDiagram();

	/**
	 * Returns a new object of class '<em>IComponent Instance</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>IComponent Instance</em>'.
	 * @generated
	 */
	IComponentInstance createIComponentInstance();

	/**
	 * Returns a new object of class '<em>IConfiguration</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>IConfiguration</em>'.
	 * @generated
	 */
	IConfiguration createIConfiguration();

	/**
	 * Returns a new object of class '<em>IConnector</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>IConnector</em>'.
	 * @generated
	 */
	IConnector createIConnector();

	/**
	 * Returns a new object of class '<em>IConstraint</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>IConstraint</em>'.
	 * @generated
	 */
	IConstraint createIConstraint();

	/**
	 * Returns a new object of class '<em>IConstructor</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>IConstructor</em>'.
	 * @generated
	 */
	IConstructor createIConstructor();

	/**
	 * Returns a new object of class '<em>IContext Specification</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>IContext Specification</em>'.
	 * @generated
	 */
	IContextSpecification createIContextSpecification();

	/**
	 * Returns a new object of class '<em>IControlled File</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>IControlled File</em>'.
	 * @generated
	 */
	IControlledFile createIControlledFile();

	/**
	 * Returns a new object of class '<em>IDefault Drvd Trans</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>IDefault Drvd Trans</em>'.
	 * @generated
	 */
	IDefaultDrvdTrans createIDefaultDrvdTrans();

	/**
	 * Returns a new object of class '<em>IDependency</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>IDependency</em>'.
	 * @generated
	 */
	IDependency createIDependency();

	/**
	 * Returns a new object of class '<em>IDeployment Diagram</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>IDeployment Diagram</em>'.
	 * @generated
	 */
	IDeploymentDiagram createIDeploymentDiagram();

	/**
	 * Returns a new object of class '<em>IDescription</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>IDescription</em>'.
	 * @generated
	 */
	IDescription createIDescription();

	/**
	 * Returns a new object of class '<em>IDestructor</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>IDestructor</em>'.
	 * @generated
	 */
	IDestructor createIDestructor();

	/**
	 * Returns a new object of class '<em>IDiagram</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>IDiagram</em>'.
	 * @generated
	 */
	IDiagram createIDiagram();

	/**
	 * Returns a new object of class '<em>IEmbeded File</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>IEmbeded File</em>'.
	 * @generated
	 */
	IEmbededFile createIEmbededFile();

	/**
	 * Returns a new object of class '<em>IEnumeration Literal</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>IEnumeration Literal</em>'.
	 * @generated
	 */
	IEnumerationLiteral createIEnumerationLiteral();

	/**
	 * Returns a new object of class '<em>IEvent</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>IEvent</em>'.
	 * @generated
	 */
	IEvent createIEvent();

	/**
	 * Returns a new object of class '<em>IEvent Handle</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>IEvent Handle</em>'.
	 * @generated
	 */
	IEventHandle createIEventHandle();

	/**
	 * Returns a new object of class '<em>IEvent Reception</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>IEvent Reception</em>'.
	 * @generated
	 */
	IEventReception createIEventReception();

	/**
	 * Returns a new object of class '<em>IExecution Occurrence</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>IExecution Occurrence</em>'.
	 * @generated
	 */
	IExecutionOccurrence createIExecutionOccurrence();

	/**
	 * Returns a new object of class '<em>IExternal Hyperlink</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>IExternal Hyperlink</em>'.
	 * @generated
	 */
	IExternalHyperlink createIExternalHyperlink();

	/**
	 * Returns a new object of class '<em>IFile</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>IFile</em>'.
	 * @generated
	 */
	IFile createIFile();

	/**
	 * Returns a new object of class '<em>IFile Fragment</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>IFile Fragment</em>'.
	 * @generated
	 */
	IFileFragment createIFileFragment();

	/**
	 * Returns a new object of class '<em>IFlow</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>IFlow</em>'.
	 * @generated
	 */
	IFlow createIFlow();

	/**
	 * Returns a new object of class '<em>IFlow Item</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>IFlow Item</em>'.
	 * @generated
	 */
	IFlowItem createIFlowItem();

	/**
	 * Returns a new object of class '<em>IFlowchart</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>IFlowchart</em>'.
	 * @generated
	 */
	IFlowchart createIFlowchart();

	/**
	 * Returns a new object of class '<em>IFolder</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>IFolder</em>'.
	 * @generated
	 */
	IFolder createIFolder();

	/**
	 * Returns a new object of class '<em>IFork</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>IFork</em>'.
	 * @generated
	 */
	IFork createIFork();

	/**
	 * Returns a new object of class '<em>IGeneralization</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>IGeneralization</em>'.
	 * @generated
	 */
	IGeneralization createIGeneralization();

	/**
	 * Returns a new object of class '<em>IGuard</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>IGuard</em>'.
	 * @generated
	 */
	IGuard createIGuard();

	/**
	 * Returns a new object of class '<em>IHandle With Data</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>IHandle With Data</em>'.
	 * @generated
	 */
	IHandleWithData createIHandleWithData();

	/**
	 * Returns a new object of class '<em>IHistory Connector</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>IHistory Connector</em>'.
	 * @generated
	 */
	IHistoryConnector createIHistoryConnector();

	/**
	 * Returns a new object of class '<em>IHyper Link</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>IHyper Link</em>'.
	 * @generated
	 */
	IHyperLink createIHyperLink();

	/**
	 * Returns a new object of class '<em>IInformation Flow</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>IInformation Flow</em>'.
	 * @generated
	 */
	IInformationFlow createIInformationFlow();

	/**
	 * Returns a new object of class '<em>IInformation Item</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>IInformation Item</em>'.
	 * @generated
	 */
	IInformationItem createIInformationItem();

	/**
	 * Returns a new object of class '<em>IInstance</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>IInstance</em>'.
	 * @generated
	 */
	IInstance createIInstance();

	/**
	 * Returns a new object of class '<em>IInstance Slot</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>IInstance Slot</em>'.
	 * @generated
	 */
	IInstanceSlot createIInstanceSlot();

	/**
	 * Returns a new object of class '<em>IInstance Specification</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>IInstance Specification</em>'.
	 * @generated
	 */
	IInstanceSpecification createIInstanceSpecification();

	/**
	 * Returns a new object of class '<em>IInstance Value</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>IInstance Value</em>'.
	 * @generated
	 */
	IInstanceValue createIInstanceValue();

	/**
	 * Returns a new object of class '<em>IInteraction Occurrence</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>IInteraction Occurrence</em>'.
	 * @generated
	 */
	IInteractionOccurrence createIInteractionOccurrence();

	/**
	 * Returns a new object of class '<em>IInteraction Operand</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>IInteraction Operand</em>'.
	 * @generated
	 */
	IInteractionOperand createIInteractionOperand();

	/**
	 * Returns a new object of class '<em>IInteraction Operator</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>IInteraction Operator</em>'.
	 * @generated
	 */
	IInteractionOperator createIInteractionOperator();

	/**
	 * Returns a new object of class '<em>IInterface Item</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>IInterface Item</em>'.
	 * @generated
	 */
	IInterfaceItem createIInterfaceItem();

	/**
	 * Returns a new object of class '<em>IInterface Item Trigger</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>IInterface Item Trigger</em>'.
	 * @generated
	 */
	IInterfaceItemTrigger createIInterfaceItemTrigger();

	/**
	 * Returns a new object of class '<em>IInternal Hyperlink</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>IInternal Hyperlink</em>'.
	 * @generated
	 */
	IInternalHyperlink createIInternalHyperlink();

	/**
	 * Returns a new object of class '<em>ILabel</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>ILabel</em>'.
	 * @generated
	 */
	ILabel createILabel();

	/**
	 * Returns a new object of class '<em>ILink</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>ILink</em>'.
	 * @generated
	 */
	ILink createILink();

	/**
	 * Returns a new object of class '<em>ILink Instance</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>ILink Instance</em>'.
	 * @generated
	 */
	ILinkInstance createILinkInstance();

	/**
	 * Returns a new object of class '<em>ILiteral Specification</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>ILiteral Specification</em>'.
	 * @generated
	 */
	ILiteralSpecification createILiteralSpecification();

	/**
	 * Returns a new object of class '<em>IM Hyper Link</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>IM Hyper Link</em>'.
	 * @generated
	 */
	IMHyperLink createIMHyperLink();

	/**
	 * Returns a new object of class '<em>IMSC</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>IMSC</em>'.
	 * @generated
	 */
	IMSC createIMSC();

	/**
	 * Returns a new object of class '<em>IMatrix Instance</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>IMatrix Instance</em>'.
	 * @generated
	 */
	IMatrixInstance createIMatrixInstance();

	/**
	 * Returns a new object of class '<em>IMatrix Layout</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>IMatrix Layout</em>'.
	 * @generated
	 */
	IMatrixLayout createIMatrixLayout();

	/**
	 * Returns a new object of class '<em>IMatrix View</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>IMatrix View</em>'.
	 * @generated
	 */
	IMatrixView createIMatrixView();

	/**
	 * Returns a new object of class '<em>IMessage</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>IMessage</em>'.
	 * @generated
	 */
	IMessage createIMessage();

	/**
	 * Returns a new object of class '<em>IMessage Point</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>IMessage Point</em>'.
	 * @generated
	 */
	IMessagePoint createIMessagePoint();

	/**
	 * Returns a new object of class '<em>IMeta Link Handle</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>IMeta Link Handle</em>'.
	 * @generated
	 */
	IMetaLinkHandle createIMetaLinkHandle();

	/**
	 * Returns a new object of class '<em>IModel Element</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>IModel Element</em>'.
	 * @generated
	 */
	IModelElement createIModelElement();

	/**
	 * Returns a new object of class '<em>IModule</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>IModule</em>'.
	 * @generated
	 */
	IModule createIModule();

	/**
	 * Returns a new object of class '<em>IMultiplicity Item</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>IMultiplicity Item</em>'.
	 * @generated
	 */
	IMultiplicityItem createIMultiplicityItem();

	/**
	 * Returns a new object of class '<em>INode</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>INode</em>'.
	 * @generated
	 */
	INode createINode();

	/**
	 * Returns a new object of class '<em>IObject Link</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>IObject Link</em>'.
	 * @generated
	 */
	IObjectLink createIObjectLink();

	/**
	 * Returns a new object of class '<em>IObject Link Handle</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>IObject Link Handle</em>'.
	 * @generated
	 */
	IObjectLinkHandle createIObjectLinkHandle();

	/**
	 * Returns a new object of class '<em>IObject Model Diagram</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>IObject Model Diagram</em>'.
	 * @generated
	 */
	IObjectModelDiagram createIObjectModelDiagram();

	/**
	 * Returns a new object of class '<em>IObject Node</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>IObject Node</em>'.
	 * @generated
	 */
	IObjectNode createIObjectNode();

	/**
	 * Returns a new object of class '<em>IOperation</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>IOperation</em>'.
	 * @generated
	 */
	IOperation createIOperation();

	/**
	 * Returns a new object of class '<em>IPackage</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>IPackage</em>'.
	 * @generated
	 */
	IPackage createIPackage();

	/**
	 * Returns a new object of class '<em>IPanel Diagram</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>IPanel Diagram</em>'.
	 * @generated
	 */
	IPanelDiagram createIPanelDiagram();

	/**
	 * Returns a new object of class '<em>IPart</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>IPart</em>'.
	 * @generated
	 */
	IPart createIPart();

	/**
	 * Returns a new object of class '<em>IPin</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>IPin</em>'.
	 * @generated
	 */
	IPin createIPin();

	/**
	 * Returns a new object of class '<em>IPort</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>IPort</em>'.
	 * @generated
	 */
	IPort createIPort();

	/**
	 * Returns a new object of class '<em>IPrimitive Operation</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>IPrimitive Operation</em>'.
	 * @generated
	 */
	IPrimitiveOperation createIPrimitiveOperation();

	/**
	 * Returns a new object of class '<em>IProfile</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>IProfile</em>'.
	 * @generated
	 */
	IProfile createIProfile();

	/**
	 * Returns a new object of class '<em>IProject</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>IProject</em>'.
	 * @generated
	 */
	IProject createIProject();

	/**
	 * Returns a new object of class '<em>IProperty</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>IProperty</em>'.
	 * @generated
	 */
	IProperty createIProperty();

	/**
	 * Returns a new object of class '<em>IProperty Container</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>IProperty Container</em>'.
	 * @generated
	 */
	IPropertyContainer createIPropertyContainer();

	/**
	 * Returns a new object of class '<em>IProperty Metaclass</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>IProperty Metaclass</em>'.
	 * @generated
	 */
	IPropertyMetaclass createIPropertyMetaclass();

	/**
	 * Returns a new object of class '<em>IProperty Subject</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>IProperty Subject</em>'.
	 * @generated
	 */
	IPropertySubject createIPropertySubject();

	/**
	 * Returns a new object of class '<em>IReception</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>IReception</em>'.
	 * @generated
	 */
	IReception createIReception();

	/**
	 * Returns a new object of class '<em>IReference Activity</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>IReference Activity</em>'.
	 * @generated
	 */
	IReferenceActivity createIReferenceActivity();

	/**
	 * Returns a new object of class '<em>IRelation</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>IRelation</em>'.
	 * @generated
	 */
	IRelation createIRelation();

	/**
	 * Returns a new object of class '<em>IRequirement</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>IRequirement</em>'.
	 * @generated
	 */
	IRequirement createIRequirement();

	/**
	 * Returns a new object of class '<em>ISend Action</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>ISend Action</em>'.
	 * @generated
	 */
	ISendAction createISendAction();

	/**
	 * Returns a new object of class '<em>ISequence Diagram</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>ISequence Diagram</em>'.
	 * @generated
	 */
	ISequenceDiagram createISequenceDiagram();

	/**
	 * Returns a new object of class '<em>ISlot</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>ISlot</em>'.
	 * @generated
	 */
	ISlot createISlot();

	/**
	 * Returns a new object of class '<em>IState</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>IState</em>'.
	 * @generated
	 */
	IState createIState();

	/**
	 * Returns a new object of class '<em>IState Chart</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>IState Chart</em>'.
	 * @generated
	 */
	IStateChart createIStateChart();

	/**
	 * Returns a new object of class '<em>IState Chart Diagram</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>IState Chart Diagram</em>'.
	 * @generated
	 */
	IStateChartDiagram createIStateChartDiagram();

	/**
	 * Returns a new object of class '<em>IState Vertex</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>IState Vertex</em>'.
	 * @generated
	 */
	IStateVertex createIStateVertex();

	/**
	 * Returns a new object of class '<em>IStereotype</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>IStereotype</em>'.
	 * @generated
	 */
	IStereotype createIStereotype();

	/**
	 * Returns a new object of class '<em>IStructure Diagram</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>IStructure Diagram</em>'.
	 * @generated
	 */
	IStructureDiagram createIStructureDiagram();

	/**
	 * Returns a new object of class '<em>ISubsystem</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>ISubsystem</em>'.
	 * @generated
	 */
	ISubsystem createISubsystem();

	/**
	 * Returns a new object of class '<em>ISwimlane</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>ISwimlane</em>'.
	 * @generated
	 */
	ISwimlane createISwimlane();

	/**
	 * Returns a new object of class '<em>ISys ML Port</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>ISys ML Port</em>'.
	 * @generated
	 */
	ISysMLPort createISysMLPort();

	/**
	 * Returns a new object of class '<em>ITable Instance</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>ITable Instance</em>'.
	 * @generated
	 */
	ITableInstance createITableInstance();

	/**
	 * Returns a new object of class '<em>ITable Layout</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>ITable Layout</em>'.
	 * @generated
	 */
	ITableLayout createITableLayout();

	/**
	 * Returns a new object of class '<em>ITable View</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>ITable View</em>'.
	 * @generated
	 */
	ITableView createITableView();

	/**
	 * Returns a new object of class '<em>ITag</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>ITag</em>'.
	 * @generated
	 */
	ITag createITag();

	/**
	 * Returns a new object of class '<em>ITemplate Inst</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>ITemplate Inst</em>'.
	 * @generated
	 */
	ITemplateInst createITemplateInst();

	/**
	 * Returns a new object of class '<em>ITemplate Inst Param</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>ITemplate Inst Param</em>'.
	 * @generated
	 */
	ITemplateInstParam createITemplateInstParam();

	/**
	 * Returns a new object of class '<em>ITemplate Instantiation</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>ITemplate Instantiation</em>'.
	 * @generated
	 */
	ITemplateInstantiation createITemplateInstantiation();

	/**
	 * Returns a new object of class '<em>ITemplate Instantiation Parameter</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>ITemplate Instantiation Parameter</em>'.
	 * @generated
	 */
	ITemplateInstantiationParameter createITemplateInstantiationParameter();

	/**
	 * Returns a new object of class '<em>ITemplate Parameter</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>ITemplate Parameter</em>'.
	 * @generated
	 */
	ITemplateParameter createITemplateParameter();

	/**
	 * Returns a new object of class '<em>ITime Event</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>ITime Event</em>'.
	 * @generated
	 */
	ITimeEvent createITimeEvent();

	/**
	 * Returns a new object of class '<em>ITimeout</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>ITimeout</em>'.
	 * @generated
	 */
	ITimeout createITimeout();

	/**
	 * Returns a new object of class '<em>ITransition</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>ITransition</em>'.
	 * @generated
	 */
	ITransition createITransition();

	/**
	 * Returns a new object of class '<em>ITrigger</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>ITrigger</em>'.
	 * @generated
	 */
	ITrigger createITrigger();

	/**
	 * Returns a new object of class '<em>ITriggered</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>ITriggered</em>'.
	 * @generated
	 */
	ITriggered createITriggered();

	/**
	 * Returns a new object of class '<em>IType</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>IType</em>'.
	 * @generated
	 */
	IType createIType();

	/**
	 * Returns a new object of class '<em>IUC Diagram</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>IUC Diagram</em>'.
	 * @generated
	 */
	IUCDiagram createIUCDiagram();

	/**
	 * Returns a new object of class '<em>IUnit</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>IUnit</em>'.
	 * @generated
	 */
	IUnit createIUnit();

	/**
	 * Returns a new object of class '<em>IUse Case</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>IUse Case</em>'.
	 * @generated
	 */
	IUseCase createIUseCase();

	/**
	 * Returns a new object of class '<em>IUse Case Diagram</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>IUse Case Diagram</em>'.
	 * @generated
	 */
	IUseCaseDiagram createIUseCaseDiagram();

	/**
	 * Returns a new object of class '<em>IUse Case Stereo Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>IUse Case Stereo Type</em>'.
	 * @generated
	 */
	IUseCaseStereoType createIUseCaseStereoType();

	/**
	 * Returns a new object of class '<em>IValue Specification</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>IValue Specification</em>'.
	 * @generated
	 */
	IValueSpecification createIValueSpecification();

	/**
	 * Returns a new object of class '<em>IVariable</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>IVariable</em>'.
	 * @generated
	 */
	IVariable createIVariable();

	/**
	 * Returns a new object of class '<em>Table Data Definition</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Table Data Definition</em>'.
	 * @generated
	 */
	TableDataDefinition createTableDataDefinition();

	/**
	 * Returns a new object of class '<em>Unknown Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Unknown Type</em>'.
	 * @generated
	 */
	UnknownType createUnknownType();

	/**
	 * Returns the package supported by this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the package supported by this factory.
	 * @generated
	 */
	UMLRpyPackage getUMLRpyPackage();

} //UMLRpyFactory
