/**
 *   Copyright (c) 2016 CEA LIST and others.
 *   
 *   All rights reserved. This program and the accompanying materials
 *   are made available under the terms of the Eclipse Public License v1.0
 *   which accompanies this distribution, and is available at
 *   http://www.eclipse.org/legal/epl-v10.html
 *  
 *   Contributors:
 *     CEA LIST - Initial API and implementation
 * 
 */
package org.eclipse.papyrus.interoperability.rpy.rpymetamodel;


/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>IPin</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IPin#getM_type <em>Mtype</em>}</li>
 *   <li>{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IPin#getM_isParameterPin <em>Mis Parameter Pin</em>}</li>
 *   <li>{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IPin#getM_corePin <em>Mcore Pin</em>}</li>
 * </ul>
 *
 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.UMLRpyPackage#getIPin()
 * @model
 * @generated
 */
public interface IPin extends IConnector, ItsTargetType {
	/**
	 * Returns the value of the '<em><b>Mtype</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Mtype</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Mtype</em>' reference.
	 * @see #setM_type(IClassifier)
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.UMLRpyPackage#getIPin_M_type()
	 * @model
	 * @generated
	 */
	IClassifier getM_type();

	/**
	 * Sets the value of the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IPin#getM_type <em>Mtype</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Mtype</em>' reference.
	 * @see #getM_type()
	 * @generated
	 */
	void setM_type(IClassifier value);

	/**
	 * Returns the value of the '<em><b>Mis Parameter Pin</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Mis Parameter Pin</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Mis Parameter Pin</em>' attribute.
	 * @see #setM_isParameterPin(String)
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.UMLRpyPackage#getIPin_M_isParameterPin()
	 * @model
	 * @generated
	 */
	String getM_isParameterPin();

	/**
	 * Sets the value of the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IPin#getM_isParameterPin <em>Mis Parameter Pin</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Mis Parameter Pin</em>' attribute.
	 * @see #getM_isParameterPin()
	 * @generated
	 */
	void setM_isParameterPin(String value);

	/**
	 * Returns the value of the '<em><b>Mcore Pin</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Mcore Pin</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Mcore Pin</em>' reference.
	 * @see #setM_corePin(IConnector)
	 * @see org.eclipse.papyrus.interoperability.rpy.rpymetamodel.UMLRpyPackage#getIPin_M_corePin()
	 * @model
	 * @generated
	 */
	IConnector getM_corePin();

	/**
	 * Sets the value of the '{@link org.eclipse.papyrus.interoperability.rpy.rpymetamodel.IPin#getM_corePin <em>Mcore Pin</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Mcore Pin</em>' reference.
	 * @see #getM_corePin()
	 * @generated
	 */
	void setM_corePin(IConnector value);

} // IPin
