/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.interoperability.rpy.geometry.utils;

import java.util.List;
import java.util.Vector;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.Point;
import org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.Rectangle;
import org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.RpyGeometryFactory;
import org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.RpyShape;
import org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.TransformMatrix;
import org.eclipse.papyrus.interoperability.rpy.geometry.utils.GeometryUtils;
import org.eclipse.papyrus.interoperability.rpy.geometry.utils.PointsOperations;
import org.eclipse.papyrus.interoperability.rpy.geometry.utils.RectangleOperations;
import org.eclipse.papyrus.interoperability.rpy.geometry.utils.TransformMatrixOperations;
import org.eclipse.papyrus.interoperability.rpy.rpymetamodel.CGIPortConnector;
import org.eclipse.papyrus.interoperability.rpy.rpymetamodel.GraphElementsType;
import org.eclipse.papyrus.interoperability.rpy.rpymetamodel.UMLRpyPackage;

public class RpyShapeOperations {
    public static String M_POLYGON_FEATURE_NAME = UMLRpyPackage.eINSTANCE.getCGIGenericElement_M_polygon().getName();
    public static String M_PARENT_FEATURE_NAME = UMLRpyPackage.eINSTANCE.getCGIGenericElement_M_pParent().getName();
    public static String M_TRANSFORM_FEATURE_NAME = UMLRpyPackage.eINSTANCE.getCGIGenericElement_M_transform().getName();

    public static void initializeShape(RpyShape rpyShape, EObject rpyMMObj) {
        RpyShapeOperations.initializeTransform(rpyShape, rpyMMObj);
        RpyShapeOperations.initializeRectangle(rpyShape, rpyMMObj);
        RpyShapeOperations.initializeParent(rpyShape, rpyMMObj);
        RpyShapeOperations.initializePositionAndSize(rpyShape);
    }

    public static RpyShape createRpyShape(GraphElementsType graphElement) {
        RpyShape shape = RpyShapeOperations.isPort(graphElement) ? RpyGeometryFactory.eINSTANCE.createRpyPort() : RpyGeometryFactory.eINSTANCE.createRpyShape();
        shape.setRpyMetamodelObject((EObject)graphElement);
        return shape;
    }

    private static boolean isPort(GraphElementsType graphElement) {
        return graphElement instanceof CGIPortConnector;
    }

    public static void initializePositionAndSize(RpyShape rpyShape) {
        Point point = rpyShape.getRectangle() == null ? PointsOperations.getPoint("0", "0") : rpyShape.getRectangle().getTopLeft();
        TransformMatrix transfo = rpyShape.getTransform();
        RpyShape parentShape = rpyShape.getParent();
        while (parentShape != null && parentShape.getTransform() != null) {
            transfo = parentShape.getTransform().multiply(transfo);
            parentShape = parentShape.getParent();
        }
        Point absoluteTopLeft = transfo.multiply(point);
        rpyShape.setAbsolutePosition(absoluteTopLeft);
        if (rpyShape.getParent() == null) {
            rpyShape.setParentRelativePosition(PointsOperations.getPoint("0", "0"));
        } else {
            rpyShape.setParentRelativePosition(absoluteTopLeft.minus(rpyShape.getParent().getAbsolutePosition()));
        }
        if (rpyShape.getRectangle() != null) {
            Point absoluteBottomRight = transfo.multiply(rpyShape.getRectangle().getBottomRight());
            Point relativeBottomRight = absoluteBottomRight.minus(absoluteTopLeft);
            rpyShape.setHeight(relativeBottomRight.getIntY());
            rpyShape.setWidth(relativeBottomRight.getIntX());
        }
    }

    private static List<RpyShape> collectParentShapes(RpyShape rpyShape) {
        Vector<RpyShape> ret = new Vector<RpyShape>();
        RpyShape parent = rpyShape.getParent();
        while (parent != null) {
            ret.add(0, parent);
            parent = rpyShape.getParent();
        }
        return ret;
    }

    public static void initializeParent(RpyShape rpyShape, EObject rpyMMObj) {
        Object parentObj = GeometryUtils.getFeatureValue(rpyMMObj, M_PARENT_FEATURE_NAME);
        if (parentObj instanceof EObject) {
            RpyShape parentShape = RpyGeometryFactory.eINSTANCE.createRpyShape();
            parentShape.setRpyMetamodelObject((EObject)parentObj);
            rpyShape.setParent(parentShape);
        }
    }

    public static void initializeRectangle(RpyShape rpyShape, EObject rpyMMObj) {
        Object polygonObj = GeometryUtils.getFeatureValue(rpyMMObj, M_POLYGON_FEATURE_NAME);
        if (polygonObj instanceof List) {
            Rectangle rectangle = RectangleOperations.getRectangle((List)polygonObj);
            rpyShape.setRectangle(rectangle);
        }
    }

    public static void initializeTransform(RpyShape rpyShape, EObject rpyMMObj) {
        Object transformObj = GeometryUtils.getFeatureValue(rpyMMObj, M_TRANSFORM_FEATURE_NAME);
        if (transformObj instanceof EList && !((EList)transformObj).isEmpty()) {
            TransformMatrix transform = TransformMatrixOperations.createMatrix((List<String>)((EList)transformObj));
            rpyShape.setTransform(transform);
        } else {
            rpyShape.setTransform(TransformMatrixOperations.getIdentityTransform());
        }
    }
}

