/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.transformation.ui.handlers;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.papyrus.designer.deployment.tools.DepCreation;
import org.eclipse.papyrus.designer.infra.base.CommandSupport;
import org.eclipse.papyrus.designer.transformation.base.utils.TransformationException;
import org.eclipse.papyrus.designer.transformation.base.utils.TransformationRTException;
import org.eclipse.papyrus.designer.uml.tools.utils.ElementUtils;
import org.eclipse.papyrus.uml.diagram.common.handlers.CmdHandler;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;

public class CreatePlatformHandler
extends CmdHandler {
    private Package platform;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.updateSelectedEObject();
        if (!(this.selectedEObject instanceof Class)) {
            return null;
        }
        final Class selectedComposite = (Class)this.selectedEObject;
        CommandSupport.exec((EObject)selectedComposite, (String)"Create platform model", (Runnable)new Runnable(){

            @Override
            public void run() {
                CreatePlatformHandler.this.platform = ElementUtils.getRoot((Element)selectedComposite, (String)"platform");
            }
        });
        final String newPlatform = String.valueOf(selectedComposite.getName()) + "Platform";
        try {
            if (this.platform.getMember(newPlatform) != null) {
                Shell shell = Display.getCurrent().getActiveShell();
                MessageDialog.openInformation((Shell)shell, (String)"Error", (String)("Platform definition \"" + newPlatform + "\" exists already"));
            } else {
                CommandSupport.exec((EObject)selectedComposite, (String)"Create platform definition", (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        Package platformPkg = CreatePlatformHandler.this.platform.createNestedPackage(newPlatform);
                        try {
                            DepCreation.createPlatformInstances((Package)platformPkg, (Class)selectedComposite, null);
                        }
                        catch (TransformationException e) {
                            throw new TransformationRTException(e.getMessage());
                        }
                    }
                });
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}

