/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.languages.cpp.view.panels;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.designer.infra.base.CommandSupport;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Visibility;
import org.eclipse.papyrus.designer.languages.cpp.view.Activator;
import org.eclipse.papyrus.designer.languages.cpp.view.panels.CppAbstractPanel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Generalization;
import org.eclipse.uml2.uml.util.UMLUtil;

@Deprecated
public class CppGeneralizationPanel
extends CppAbstractPanel {
    private static final String PROTECTED = "protected";
    private static final String PUBLIC = "public";
    private static final String PRIVATE = "private";
    private Combo vPropCombo;
    private Generalization selectedGeneralization;

    public CppGeneralizationPanel(Composite parent, int style) {
        super(parent, style);
    }

    public Generalization getSelectedElement() {
        return this.selectedGeneralization;
    }

    @Override
    public void setSelectedElement(Element newElement) {
        super.setSelectedElement(newElement);
        if (!(newElement instanceof Generalization)) {
            throw new RuntimeException("bad selection: " + newElement + " should be a UML2 generalization");
        }
        this.selectedGeneralization = (Generalization)newElement;
    }

    @Override
    public Control createContent() {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        this.setLayout((Layout)gridLayout);
        Group qualifierGroup = new Group((Composite)this, 0);
        qualifierGroup.setLayout((Layout)new RowLayout());
        qualifierGroup.setText("Generalization visibility");
        this.vPropCombo = new Combo((Composite)qualifierGroup, 12);
        String[] items = new String[]{PUBLIC, PROTECTED, PRIVATE};
        this.vPropCombo.setItems(items);
        this.vPropCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                CppGeneralizationPanel.this.checkVirtual();
            }
        });
        this.pack();
        return this;
    }

    public void checkVirtual() {
        String vis;
        String visibilityVal;
        int comboSelected = this.vPropCombo.getSelectionIndex();
        switch (comboSelected) {
            case 0: {
                visibilityVal = PUBLIC;
                break;
            }
            case 1: {
                visibilityVal = PROTECTED;
                break;
            }
            case 2: {
                visibilityVal = PRIVATE;
                break;
            }
            default: {
                visibilityVal = PUBLIC;
            }
        }
        final Visibility visibility = (Visibility)UMLUtil.getStereotypeApplication((Element)this.selectedGeneralization, Visibility.class);
        if (visibility != null && !(vis = visibility.getValue()).equals(visibilityVal)) {
            CommandSupport.exec((EObject)this.selectedGeneralization, (String)"Set visibility for generalization", (Runnable)new Runnable(){

                @Override
                public void run() {
                    visibility.setValue(visibilityVal);
                }
            });
        }
    }

    @Override
    public void entryAction() {
        super.entryAction();
        this.reset();
    }

    @Override
    public void save() {
    }

    @Override
    public boolean checkModifications() {
        return false;
    }

    @Override
    protected void refreshPanel() {
        if (this.selectedGeneralization != null) {
            Visibility visibility = (Visibility)UMLUtil.getStereotypeApplication((Element)this.selectedGeneralization, Visibility.class);
            if (visibility != null) {
                String vis = visibility.getValue();
                if (vis.equals(PUBLIC)) {
                    this.vPropCombo.select(0);
                } else if (vis.equals(PROTECTED)) {
                    this.vPropCombo.select(1);
                } else if (vis.equals(PRIVATE)) {
                    this.vPropCombo.select(2);
                } else {
                    Activator.log(new RuntimeException("Generalization: should never happen, model should be corrected before"));
                    this.vPropCombo.select(0);
                }
            } else {
                this.vPropCombo.select(0);
            }
        }
    }

    @Override
    protected boolean isModelValid() {
        if (this.selectedGeneralization == null) {
            return true;
        }
        Visibility visibility = (Visibility)UMLUtil.getStereotypeApplication((Element)this.selectedGeneralization, Visibility.class);
        if (visibility != null) {
            String vis = visibility.getValue();
            return vis.equals(PUBLIC) || vis.equals(PROTECTED) || vis.equals(PRIVATE);
        }
        return false;
    }

    @Override
    protected void updateModel() {
        super.updateModel();
        if (this.selectedGeneralization == null) {
            return;
        }
        final Visibility visibility = (Visibility)UMLUtil.getStereotypeApplication((Element)this.selectedGeneralization, Visibility.class);
        if (visibility != null && !this.isModelValid()) {
            CommandSupport.exec((EObject)this.selectedGeneralization, (String)"Correct illegal visibility value", (Runnable)new Runnable(){

                @Override
                public void run() {
                    visibility.setValue(CppGeneralizationPanel.PUBLIC);
                }
            });
        }
    }
}

