/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.languages.c.codegen.services;

import java.util.ArrayList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.designer.languages.c.codegen.Activator;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.Property;

public class UmlPackageServices {
    public ArrayList<Property> getMinimizeAttributeOnType(EList<Property> attributeList) {
        if (attributeList == null) {
            return null;
        }
        ArrayList<Property> resultList = new ArrayList<Property>();
        boolean notExistInList = true;
        for (Property attribute : attributeList) {
            for (Property resultAttribute : resultList) {
                if (attribute.getType() != resultAttribute.getType()) continue;
                notExistInList = false;
            }
            if (!notExistInList) continue;
            resultList.add(attribute);
        }
        return resultList;
    }

    public ArrayList<Parameter> getMinimizeParameterOnType(EList<Parameter> parameterList) {
        if (parameterList == null) {
            return null;
        }
        ArrayList<Parameter> resultList = new ArrayList<Parameter>();
        boolean notExistInList = true;
        for (Parameter parameter : parameterList) {
            for (Parameter resultParameter : resultList) {
                if (parameter.getType() != resultParameter.getType()) continue;
                notExistInList = false;
            }
            if (!notExistInList) continue;
            resultList.add(parameter);
        }
        return resultList;
    }

    public Package getPackageAttribute(Property anAttribute) {
        Package resultPackage = null;
        if (anAttribute.getType() == null) {
            return resultPackage;
        }
        if (anAttribute.getClass_().getPackage() != anAttribute.getType().getPackage() && !(anAttribute.getType().getPackage() instanceof Model)) {
            resultPackage = anAttribute.getType().getPackage();
        }
        return resultPackage;
    }

    public Package getPackageMethod(Parameter aParameter) {
        Package resultPackage = null;
        if (aParameter.getType() == null) {
            return resultPackage;
        }
        if (aParameter.getOperation().getClass_().getPackage() != aParameter.getType().getPackage() && !(aParameter.getType().getPackage() instanceof Model)) {
            resultPackage = aParameter.getType().getPackage();
        }
        return resultPackage;
    }

    public ArrayList<Classifier> minimizeClassNoInPackage(EList<Classifier> classifierList, Classifier aClassifier) {
        Namespace namespaceClass = aClassifier.getNamespace();
        if (classifierList == null) {
            Activator.log.debug("Classifier list null");
            return null;
        }
        ArrayList<Classifier> resultList = new ArrayList<Classifier>();
        for (EObject classifier : classifierList) {
            Classifier classTarget = (Classifier)classifier;
            if (classTarget.getNamespace() == namespaceClass) continue;
            resultList.add(classTarget);
        }
        return resultList;
    }
}

