/**
 * Copyright (c) 2015 CEA LIST.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * Contributors:
 *     CEA LIST - initial API and implementation
 */
package org.eclipse.papyrus.designer.languages.c.codegen.header;

import com.google.common.base.Objects;
import org.eclipse.papyrus.designer.languages.c.codegen.lib.CommonScript;
import org.eclipse.papyrus.designer.languages.c.codegen.lib.DataTypeScript;
import org.eclipse.papyrus.designer.languages.c.codegen.lib.ImportScript;
import org.eclipse.papyrus.designer.languages.c.codegen.lib.variableScript;
import org.eclipse.papyrus.designer.languages.c.codegen.services.UmlCommentServices;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.VisibilityKind;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@SuppressWarnings("all")
public class DataTypeHeaderScript {
  public static CharSequence dataTypefill(final DataType dataType) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }

  public static CharSequence dataTypeHeaderScript(final DataType dataType) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("// This template is called by the main module file ");
    _builder.newLine();
    CharSequence _genHeading = CommonScript.genHeading(dataType);
    _builder.append(_genHeading);
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    CharSequence _genHeadingHeader = CommonHeaderScript.genHeadingHeader(dataType);
    _builder.append(_genHeadingHeader);
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("// Explicit import of the class");
    _builder.newLine();
    CharSequence _genHeaderIncludes = ImportScript.genHeaderIncludes(dataType);
    _builder.append(_genHeaderIncludes);
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("// header body");
    _builder.newLine();
    CharSequence _dataTypeHeaderBody = DataTypeHeaderScript.dataTypeHeaderBody(dataType);
    _builder.append(_dataTypeHeaderBody);
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    CharSequence _genEndHeader = CommonHeaderScript.genEndHeader(dataType);
    _builder.append(_genEndHeader);
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  public static CharSequence dataTypeHeaderBody(final DataType dataType) {
    StringConcatenation _builder = new StringConcatenation();
    String _partComment = UmlCommentServices.partComment(dataType, "Public Class Description");
    _builder.append(_partComment);
    _builder.newLineIfNotEmpty();
    _builder.append("//  Structure ");
    _builder.newLine();
    CharSequence _genDataTypeStructDeclarations = DataTypeScript.genDataTypeStructDeclarations(dataType);
    _builder.append(_genDataTypeStructDeclarations);
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("// Property initialisation declarations");
    _builder.newLine();
    CharSequence _genDefaultInitialisationProtoype = DataTypeScript.genDefaultInitialisationProtoype(dataType);
    _builder.append(_genDefaultInitialisationProtoype);
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("// ----------------------------------Public Global VariableDescription----------------------------------");
    _builder.newLine();
    {
      final Function1<Property, Boolean> _function = new Function1<Property, Boolean>() {
        @Override
        public Boolean apply(final Property it) {
          return Boolean.valueOf(((it.isStatic() && Objects.equal(it.getVisibility(), VisibilityKind.PUBLIC_LITERAL)) && (it.getType() != null)));
        }
      };
      int _size = IterableExtensions.size(IterableExtensions.<Property>filter(dataType.getOwnedAttributes(), _function));
      boolean _greaterThan = (_size > 0);
      if (_greaterThan) {
        String _partComment_1 = UmlCommentServices.partComment(dataType, "Global Public Variable Declarations");
        _builder.append(_partComment_1);
        _builder.newLineIfNotEmpty();
      }
    }
    {
      final Function1<Property, Boolean> _function_1 = new Function1<Property, Boolean>() {
        @Override
        public Boolean apply(final Property it) {
          boolean _isStatic = it.isStatic();
          return Boolean.valueOf((!_isStatic));
        }
      };
      Iterable<Property> _filter = IterableExtensions.<Property>filter(dataType.getOwnedAttributes(), _function_1);
      for(final Property attribute : _filter) {
        {
          if ((Objects.equal(attribute.getVisibility(), VisibilityKind.PUBLIC_LITERAL) && (attribute.getType() != null))) {
            _builder.append("// global variable declaration");
            _builder.newLine();
            CharSequence _genVariableDeclaration = variableScript.genVariableDeclaration(attribute);
            _builder.append(_genVariableDeclaration);
            _builder.newLineIfNotEmpty();
          }
        }
      }
    }
    return _builder;
  }
}
