/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.components.validation.constraints;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.validation.AbstractModelConstraint;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.papyrus.designer.transformation.profile.Transformation.DerivedElement;
import org.eclipse.papyrus.designer.uml.tools.utils.ConnectorUtil;
import org.eclipse.papyrus.designer.uml.tools.utils.StereotypeUtil;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;

public class ConnectorCallMultiplicity
extends AbstractModelConstraint {
    public IStatus validate(IValidationContext ctx) {
        String portsStr = "";
        Property part = (Property)ctx.getTarget();
        if (!StereotypeUtil.isApplicable((Element)part, DerivedElement.class)) {
            return ctx.createSuccessStatus();
        }
        Class owner = part.getClass_();
        if (owner != null && part.getType() instanceof Class) {
            Class class_ = (Class)part.getType();
            for (Port port : class_.getOwnedPorts()) {
                if (port.getRequireds().size() <= 0) continue;
                int connections = 0;
                for (Connector connector : owner.getOwnedConnectors()) {
                    if (!ConnectorUtil.connectsPort((Connector)connector, (Port)port)) continue;
                    ++connections;
                    break;
                }
                if (connections <= port.getUpper()) continue;
                if (portsStr.length() != 0) {
                    portsStr = String.valueOf(portsStr) + ", ";
                }
                portsStr = String.valueOf(portsStr) + port.getName();
            }
        }
        if (portsStr.length() > 0) {
            return ctx.createFailureStatus(new Object[]{String.format("The port(s) %s with a required interface of part %s have more connections than their multiplicty within composite %s", portsStr, part.getName(), owner.getQualifiedName())});
        }
        return ctx.createSuccessStatus();
    }
}

