/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.languages.java.reverse.ui.handlers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.papyrus.designer.languages.java.reverse.utils.TypeOperationsEnhanced;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.ui.util.ServiceUtilsForActionHandlers;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.uml2.uml.AggregationKind;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;

public class CreateAssociationFromPropertyHandler
extends AbstractHandler
implements IHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        List<Object> objects = this.lookupSelectedElements();
        List<Property> selectedProperties = this.getAllSelectionOfType(event, Property.class);
        if (objects == null) {
            this.showErrorDialog(event, "No object selected", "Can't create association. Please select a Property First.");
            return null;
        }
        try {
            this.doExecute(selectedProperties);
        }
        catch (ServiceException e) {
            this.showErrorDialog(event, "Can't get TransactionalEditingDomain", e.getMessage());
            e.printStackTrace();
        }
        catch (Exception e) {
            this.showErrorDialog(event, "Can't Create Association", e.getMessage());
            e.printStackTrace();
        }
        return null;
    }

    private <T> List<T> getAllSelectionOfType(ExecutionEvent event, Class<T> expectedType) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelectionChecked((ExecutionEvent)event);
        System.out.println("check " + selection);
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            return this.getAllElementOfType(structuredSelection.toList(), expectedType);
        }
        if (selection instanceof TreeSelection) {
            TreeSelection treeSelection = (TreeSelection)selection;
            return this.getAllElementOfType(treeSelection.toList(), expectedType);
        }
        return null;
    }

    private <T> List<T> getAllElementOfType(List<Object> list, Class<T> expectedClassType) {
        ArrayList<T> res = new ArrayList<T>();
        for (Object cur : list) {
            T adapted = this.adapt(cur, expectedClassType);
            if (adapted == null) continue;
            res.add(adapted);
        }
        return res;
    }

    private <T> T adapt(Object object, Class<T> expectedClassType) {
        EObject eobject;
        Object ele;
        if (object instanceof IAdaptable) {
            ele = ((IAdaptable)object).getAdapter(expectedClassType);
            if (ele != null) {
                return (T)ele;
            }
            if (EObject.class.isAssignableFrom(expectedClassType) && (eobject = (EObject)((IAdaptable)object).getAdapter(EObject.class)) != null && expectedClassType.isInstance(eobject)) {
                return (T)eobject;
            }
        }
        if ((ele = Platform.getAdapterManager().getAdapter(object, expectedClassType)) != null) {
            return (T)ele;
        }
        if (EObject.class.isAssignableFrom(expectedClassType) && (eobject = (EObject)Platform.getAdapterManager().getAdapter(object, EObject.class)) != null && expectedClassType.isInstance(eobject)) {
            return (T)eobject;
        }
        return null;
    }

    private void showErrorDialog(ExecutionEvent event, String title, String errorMessage) throws ExecutionException {
        IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event);
        MessageDialog.openError((Shell)window.getShell(), (String)title, (String)errorMessage);
    }

    public String getCommandName() {
        return "Create Association";
    }

    protected void doExecute(final List<?> objects) throws ServiceException {
        TransactionalEditingDomain editingDomain = this.getEditingDomain();
        RecordingCommand command = new RecordingCommand(editingDomain, this.getCommandName()){

            protected void doExecute() {
                System.out.println(" Selections:");
                for (Object obj : objects) {
                    System.out.println(String.format("found '%s'.", obj));
                    CreateAssociationFromPropertyHandler.this.createAssociationFromProperty((Property)obj);
                }
            }
        };
        editingDomain.getCommandStack().execute((Command)command);
    }

    protected void createAssociationFromProperty(Property p) {
        Element owner = p.getOwner();
        if (owner instanceof Type) {
            Type classOwner = (Type)owner;
            String name = classOwner.getName();
            String newname = String.valueOf(name.substring(0, 1).toLowerCase()) + name.substring(1);
            TypeOperationsEnhanced.createAssociationFromProperty((Property)p, (boolean)true, (AggregationKind)AggregationKind.COMPOSITE_LITERAL, (boolean)false, (AggregationKind)AggregationKind.NONE_LITERAL, (String)newname, (int)0, (int)1);
        }
    }

    private List<Object> lookupSelectedElements() {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        ISelection selection = page.getSelection();
        System.out.println("check " + selection);
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            return structuredSelection.toList();
        }
        if (selection instanceof TreeSelection) {
            TreeSelection treeSelection = (TreeSelection)selection;
            return treeSelection.toList();
        }
        return null;
    }

    protected TransactionalEditingDomain getEditingDomain() throws ServiceException {
        return ServiceUtilsForActionHandlers.getInstance().getTransactionalEditingDomain();
    }
}

