/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.xtext.base.serializer;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.xtext.base.serializer.GrammarRuleValue;
import org.eclipse.ocl.xtext.base.serializer.SerializationMetaData;
import org.eclipse.ocl.xtext.base.serializer.SerializationRuleHelper;
import org.eclipse.ocl.xtext.base.serializer.SerializationUtils;

public class DiagnosticStringBuilder {
    protected final @NonNull StringBuilder s;

    public DiagnosticStringBuilder() {
        this.s = new StringBuilder();
    }

    public DiagnosticStringBuilder(@NonNull StringBuilder s) {
        this.s = s;
    }

    public void append(char c) {
        this.s.append(c);
    }

    public void append(@NonNull String string) {
        this.s.append(string);
    }

    public void appendEStructuralFeatureName(@NonNull EClass eFeatureScope, @NonNull EStructuralFeature eStructuralFeature) {
        this.s.append(SerializationUtils.getName((ENamedElement)eStructuralFeature));
    }

    public void appendIndentation(int depth) {
        SerializationUtils.appendIndentation(this.s, depth);
    }

    public void appendObject(@Nullable Object object) {
        String toString = object != null ? object.toString() : null;
        this.s.append(toString);
    }

    public void appendRuleName(int ruleValueIndex) {
        this.s.append(ruleValueIndex);
    }

    public void appendVariableName(int variableIndex) {
        this.s.append("V");
        this.s.append(variableIndex);
    }

    public void appendWithFormat(@NonNull String format, Object ... args) {
        this.s.append(String.format(format, args));
    }

    public @NonNull StringBuilder getStringBuilder() {
        return this.s;
    }

    public @NonNull String toString() {
        @NonNull String castString = this.s.toString();
        return castString;
    }

    public static class DiagnosticStringBuilderWithHelper
    extends DiagnosticStringBuilder {
        protected final @NonNull SerializationRuleHelper helper;

        public DiagnosticStringBuilderWithHelper(@Nullable SerializationRuleHelper helper) {
            assert (helper != null);
            this.helper = helper;
        }

        @Override
        public void appendRuleName(int ruleValueIndex) {
            GrammarRuleValue grammarRuleValue = this.helper.getGrammarRuleValue(ruleValueIndex);
            this.s.append(grammarRuleValue.getName());
        }
    }

    public static class SerializationMetaDataDiagnosticStringBuilder
    extends DiagnosticStringBuilder {
        protected final @NonNull SerializationMetaData serializationMetaData;

        public SerializationMetaDataDiagnosticStringBuilder(@NonNull SerializationMetaData serializationMetaData) {
            this.serializationMetaData = serializationMetaData;
        }

        @Override
        public void appendRuleName(int ruleValueIndex) {
            GrammarRuleValue grammarRuleValue = this.serializationMetaData.getGrammarRuleValue(ruleValueIndex);
            this.s.append(grammarRuleValue.getName());
        }
    }
}

