/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.types;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.pivot.Parameter;
import org.eclipse.ocl.pivot.ParameterTypes;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.ids.IdManager;
import org.eclipse.ocl.pivot.ids.ParametersId;
import org.eclipse.ocl.pivot.internal.elements.AbstractExecutorParameter;

public class ParameterTypesImpl
implements ParameterTypes {
    public static final @NonNull ParameterTypesImpl EMPTY_LIST = new ParameterTypesImpl(new Type[0]);
    private final @NonNull ParametersId parametersId;
    private final @NonNull Type @NonNull [] parameterTypes;
    private final int hashCode;
    private List<Parameter> parameters = null;

    public ParameterTypesImpl(Type ... parameterTypes) {
        this.parametersId = IdManager.getParametersId(parameterTypes);
        this.parameterTypes = parameterTypes;
        this.hashCode = this.parametersId.hashCode() + 2457;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ParameterTypesImpl)) {
            return false;
        }
        ParameterTypesImpl that = (ParameterTypesImpl)obj;
        if (this.hashCode() != that.hashCode()) {
            return false;
        }
        Type[] thoseParameters = that.parameterTypes;
        if (this.parameterTypes.length != thoseParameters.length) {
            return false;
        }
        int i = 0;
        while (i < this.parameterTypes.length) {
            if (!this.parameterTypes[i].equals(thoseParameters[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public @NonNull Type get(int index) {
        Type parameterType = this.parameterTypes[index];
        assert (parameterType != null);
        return parameterType;
    }

    @Override
    public @NonNull Type @NonNull [] get() {
        return this.parameterTypes;
    }

    @Override
    public @NonNull ParametersId getParametersId() {
        return this.parametersId;
    }

    @Override
    public @NonNull List<Parameter> getParameters() {
        List<Parameter> parameters2 = this.parameters;
        if (parameters2 == null) {
            this.parameters = parameters2 = new ArrayList<Parameter>();
            int i = 0;
            while (i < this.parameterTypes.length) {
                Type type = this.parameterTypes[i];
                parameters2.add(new AbstractExecutorParameter("_" + i, type, false));
                ++i;
            }
        }
        return parameters2;
    }

    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public int size() {
        return this.parameterTypes.length;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append('(');
        int i = 0;
        while (i < this.parameterTypes.length) {
            if (i > 0) {
                s.append(',');
            }
            s.append(this.parameterTypes[i].toString());
            ++i;
        }
        s.append(')');
        return s.toString();
    }
}

