/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.uml.tests;

import java.util.Collections;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.expressions.PropertyCallExp;
import org.eclipse.ocl.expressions.TypeExp;
import org.eclipse.ocl.uml.tests.AbstractTestSuite;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;

public class InvariantConstraintsTest
extends AbstractTestSuite {
    public void test_simpleInvariant() {
        this.parseConstraint("package ocltest context Fruit inv: color <> Color::black endpackage");
    }

    public void test_simpleInvariantWithSelf() {
        this.parseConstraint("package ocltest context Fruit inv: self.color <> Color::black endpackage");
    }

    public void test_simpleInvariantWithLet() {
        this.parseConstraint("package ocltest context Fruit inv: let myColor : Color = self.color in myColor <> Color::black endpackage");
    }

    public void test_variablesHidingAttributes() {
        this.parseConstraint("package ocltest context Fruit inv: let color : Boolean = (not self.color.oclIsUndefined()) in   color implies self.color <> Color::black endpackage");
    }

    public void test_propertyNameCoincidesWithTypeName_140347() {
        this.expectModified = true;
        Property myFruit = this.apple.createOwnedAttribute("Fruit", (Type)this.fruit);
        try {
            OCLExpression expr = this.parseConstraint("package ocltest context Apple inv: self.Fruit <> self implies self.Fruit.oclIsKindOf(Fruit) endpackage");
            int propertyCalls = 0;
            int typeCalls = 0;
            TreeIterator iter = EcoreUtil.getAllContents(Collections.singleton(expr));
            while (iter.hasNext()) {
                TypeExp te;
                Object next = iter.next();
                if (next instanceof PropertyCallExp) {
                    PropertyCallExp pc = (PropertyCallExp)next;
                    if (!"Fruit".equals(((Property)pc.getReferredProperty()).getName())) continue;
                    ++propertyCalls;
                    continue;
                }
                if (!(next instanceof TypeExp) || !"Fruit".equals(((Classifier)(te = (TypeExp)next).getReferredType()).getName())) continue;
                ++typeCalls;
            }
            InvariantConstraintsTest.assertEquals((String)"property calls", (int)2, (int)propertyCalls);
            InvariantConstraintsTest.assertEquals((String)"type calls", (int)1, (int)typeCalls);
        }
        finally {
            this.apple.getOwnedAttributes().remove((Object)myFruit);
        }
    }

    public void test_interfaceRealization() {
        this.parseConstraint("package ocltest context Fruit inv only_tasty_fruit: self.oclAsType(Edible).isTasty implies   Edible.allInstances()->excluding(self)->forAll(e | not e.isTasty) endpackage");
    }

    public void test_nestedClassifiers() {
        this.expectModified = true;
        Class seed = (Class)this.apple.createNestedClassifier("Seed", uml.getClass_());
        seed.createOwnedAttribute("fruit", (Type)this.apple);
        try {
            this.parseConstraint("package ocltest context Fruit inv: Apple::Seed.allInstances()->forAll(fruit.color <> Color::black) endpackage");
            this.parseConstraint("package ocltest context Apple::Seed inv: not fruit.oclIsUndefined() endpackage");
            this.parseConstraint("context ocltest::Apple::Seed inv: fruit.color <> Color::black");
            this.parseDef("package ocltest context Apple::Seed def: getColor() : Color = fruit.color endpackage");
            this.parseConstraint("package ocltest context Apple::Seed::getColor() : Color pre: not fruit.oclIsUndefined() endpackage");
        }
        finally {
            seed.destroy();
        }
    }
}

