/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.validity.test;

import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.ocl.examples.emf.validation.validity.ConstrainingNode;
import org.eclipse.ocl.examples.emf.validation.validity.Result;
import org.eclipse.ocl.examples.emf.validation.validity.ResultSet;
import org.eclipse.ocl.examples.emf.validation.validity.RootConstrainingNode;
import org.eclipse.ocl.examples.emf.validation.validity.ValidatableNode;
import org.eclipse.ocl.examples.emf.validation.validity.manager.ValidityManager;
import org.eclipse.ocl.examples.validity.test.AbstractValidityTestCase;
import org.eclipse.ocl.examples.validity.test.ecoreTest.Eclass1;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class ValidityManagerTests
extends AbstractValidityTestCase {
    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.initTestModels();
        HashSet<Resource> newResources = new HashSet<Resource>();
        newResources.add(this.ecoreResource);
        newResources.add(this.ecoreResource2);
        newResources.add(this.ecoreResource3);
        newResources.add(this.oclResource);
        newResources.add(this.oclResource2);
        this.initValidityManager(new TestValidityManager());
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
    }

    @Test
    public void testValidityManagerGetConstrainingNodeResults() {
        ConstrainingNode constrainingNode = this.validityManager.getConstrainingNode((EObject)this.ecoreResource2.getContents().get(0));
        ValidityManagerTests.assertTrue((boolean)(constrainingNode instanceof RootConstrainingNode));
        ValidityManagerTests.assertEquals((String)"Eclass1 in validityModelTest.ecoretest", (String)constrainingNode.getLabel());
        ResultSet resultSet = this.validityModel.createResultSet((IProgressMonitor)new NullProgressMonitor());
        ((TestValidityManager)this.validityManager).putResults(resultSet);
        ConstrainingNode constrainingNodeFromRootByLabel = ValidityManagerTests.getConstrainingNodeByLabel((Iterable<? extends ConstrainingNode>)this.rootNode.getConstrainingNodes(), "ecoreTest.ocl");
        ConstrainingNode constrainingNodeByLabel1 = ValidityManagerTests.getConstrainingNodeByLabel((Iterable<? extends ConstrainingNode>)constrainingNodeFromRootByLabel.getChildren(), "ecoreTest");
        ConstrainingNode constrainingNodeByLabel2 = ValidityManagerTests.getConstrainingNodeByLabel((Iterable<? extends ConstrainingNode>)constrainingNodeByLabel1.getChildren(), "Eclass1");
        List constrainingNodeResults = this.validityManager.getConstrainingNodeResults(constrainingNodeByLabel2);
        ValidityManagerTests.assertEquals((Object)1, (Object)constrainingNodeResults.size());
        ValidityManagerTests.assertEquals((String)"Eclass1 in validityModelTest.ecoretest", (String)((Result)constrainingNodeResults.get(0)).getResultConstrainingNode().getLabel());
        ValidityManagerTests.assertEquals((String)"ecoreTest.ocl::ecoreTest::Eclass1::eclass1_constraint", (String)((Result)constrainingNodeResults.get(0)).getResultValidatableNode().getLabel());
        ValidityManagerTests.assertEquals((String)"eclass1_constraint", (String)((Result)constrainingNodeResults.get(0)).getLeafConstrainingNode().getLabel());
    }

    @Test
    public void testValidityManagerGetValidatableNodeResults() {
        ResultSet resultSet = this.validityModel.createResultSet((IProgressMonitor)new NullProgressMonitor());
        ((TestValidityManager)this.validityManager).putResults(resultSet);
        ValidatableNode rootValidatableNode = ValidityManagerTests.getValidatableNodeByLabel((Iterable<? extends ValidatableNode>)this.rootNode.getValidatableNodes(), "ecoreTest2 in ecoreTest2.ecore");
        List validatableNodeResults = this.validityManager.getValidatableNodeResults(rootValidatableNode);
        ValidityManagerTests.assertEquals((Object)31, (Object)validatableNodeResults.size());
        ValidityManagerTests.assertNotNull((Object)ValidityManagerTests.getResultFromResultValidatableNode(validatableNodeResults, "ecore.ocl::ecore::EPackage::epackage_constraint"));
        ValidityManagerTests.assertNotNull((Object)ValidityManagerTests.getResultFromResultValidatableNode(validatableNodeResults, "ecore.ocl::ecore::EPackage::epackage_constraint_2"));
        ValidityManagerTests.assertNotNull((Object)ValidityManagerTests.getResultFromResultValidatableNode(validatableNodeResults, "ecore.ocl::ecore::EClass::eclass_constraint"));
        ValidityManagerTests.assertNotNull((Object)ValidityManagerTests.getResultFromResultValidatableNode(validatableNodeResults, "ecore.ocl::ecore::EAttribute::eattribute_constraint"));
    }

    @Test
    public void testValidityManagerGetConstrainingNode() {
        EObject eRoot2 = (EObject)this.ecoreResource2.getContents().get(0);
        ConstrainingNode constrainingNode = this.validityManager.getConstrainingNode(eRoot2);
        ValidityManagerTests.assertTrue((boolean)(constrainingNode instanceof RootConstrainingNode));
        ValidityManagerTests.assertEquals((String)"Eclass1 in validityModelTest.ecoretest", (String)constrainingNode.getLabel());
        constrainingNode = this.validityManager.getConstrainingNode((EObject)((Eclass1)eRoot2).getClasses2().get(0));
        ValidityManagerTests.assertEquals((String)"EClass2", (String)constrainingNode.getLabel());
    }

    @Test
    public void testValidityManagerSetInput() {
        int resourcesCount = 5;
        this.validityManager.getModel().getResources().clear();
        ValidityManagerTests.assertEquals((Object)0, (Object)this.validityManager.getModel().getResources().size());
        EObject eObject = (EObject)this.ecoreResource2.getContents().get(0);
        this.validityManager.setInput((Object)eObject);
        ValidityManagerTests.assertEquals((Object)resourcesCount, (Object)this.validityManager.getModel().getResources().size());
        this.validityManager.getModel().getResources().clear();
        ValidityManagerTests.assertEquals((Object)0, (Object)this.validityManager.getModel().getResources().size());
        this.validityManager.setInput((Object)this.ecoreResource);
        ValidityManagerTests.assertEquals((Object)resourcesCount, (Object)this.validityManager.getModel().getResources().size());
    }

    public static class TestValidityManager
    extends ValidityManager {
        public void putResults(ResultSet resultSet) {
            for (Result result : resultSet.getResults()) {
                this.resultsMap.put(result.getResultValidatableNode(), result);
            }
        }
    }
}

