/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.build.clones;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Writer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.mwe.core.WorkflowContext;
import org.eclipse.emf.mwe.core.issues.Issues;
import org.eclipse.emf.mwe.core.lib.AbstractWorkflowComponent2;
import org.eclipse.emf.mwe.core.monitor.ProgressMonitor;
import org.eclipse.ocl.examples.xtext.idioms.CompatibilityAbstractInternalAntlrParser;
import org.eclipse.xtext.parser.antlr.AbstractInternalAntlrParser;

public class InjectCompatibilityAbstractInternalAntlrParser
extends AbstractWorkflowComponent2 {
    private static final String COMPONENT_NAME = "Inject CompatibilityAbstractInternalAntlrParser";
    private static final Log LOG = LogFactory.getLog(InjectCompatibilityAbstractInternalAntlrParser.class);
    private String fileName;

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getLogMessage() {
        return "converting '" + this.fileName + "'";
    }

    protected void invokeInternal(WorkflowContext model, ProgressMonitor monitor, Issues issues) {
        if (this.fileName != null) {
            File f = new File(this.fileName);
            LOG.info((Object)("Converting " + f.getAbsolutePath()));
            this.convertFile(f);
        }
    }

    protected void checkConfigurationInternal(Issues issues) {
        if (this.fileName == null) {
            issues.addWarning("No fileName specified!");
        }
    }

    private void convertFile(File file) {
        try {
            StringBuilder s = new StringBuilder();
            LineNumberReader reader = new LineNumberReader(new FileReader(file));
            try {
                String line;
                String oldText = "extends " + AbstractInternalAntlrParser.class.getSimpleName();
                String newText = "extends " + CompatibilityAbstractInternalAntlrParser.class.getName();
                while ((line = reader.readLine()) != null) {
                    s.append(line.replace(oldText, newText));
                    s.append("\n");
                }
            }
            catch (IOException e) {
                LOG.error((Object)("Failed to read '" + file + "'"), (Throwable)e);
                return;
            }
            try {
                reader.close();
            }
            catch (IOException e) {
                LOG.error((Object)("Failed to close '" + file + "'"), (Throwable)e);
                return;
            }
            try (FileWriter writer = new FileWriter(file);){
                try {
                    writer.write(s.toString());
                    ((Writer)writer).flush();
                }
                catch (IOException e) {
                    LOG.error((Object)("Failed to write '" + file + "'"), (Throwable)e);
                    ((Writer)writer).close();
                    return;
                }
            }
            catch (IOException e) {
                LOG.error((Object)("Failed to re-open '" + file + "'"), (Throwable)e);
                return;
            }
            LOG.info((Object)("Updated " + file));
        }
        catch (FileNotFoundException e) {
            LOG.error((Object)("Failed to open '" + file + "'"), (Throwable)e);
            return;
        }
    }

    public String getComponentName() {
        return COMPONENT_NAME;
    }
}

