/*
 * Decompiled with CFR 0.152.
 */
package company.impl;

import company.Company;
import company.CompanyFactory;
import company.CompanyPackage;
import company.Department;
import company.Division;
import company.Employee;
import company.Freelance;
import company.Student;
import company.util.CompanyValidator;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.impl.EPackageImpl;
import primitivetypes.PrimitivetypesPackage;
import primitivetypes.impl.PrimitivetypesPackageImpl;

public class CompanyPackageImpl
extends EPackageImpl
implements CompanyPackage {
    private EClass employeeEClass = null;
    private EClass departmentEClass = null;
    private EClass freelanceEClass = null;
    private EClass divisionEClass = null;
    private EClass studentEClass = null;
    private EClass companyEClass = null;
    private static boolean isInited = false;
    private boolean isCreated = false;
    private boolean isInitialized = false;

    private CompanyPackageImpl() {
        super("http:///company.ecore", (EFactory)CompanyFactory.eINSTANCE);
    }

    public static CompanyPackage init() {
        if (isInited) {
            return (CompanyPackage)EPackage.Registry.INSTANCE.getEPackage("http:///company.ecore");
        }
        CompanyPackageImpl theCompanyPackage = (CompanyPackageImpl)(EPackage.Registry.INSTANCE.get((Object)"http:///company.ecore") instanceof CompanyPackageImpl ? EPackage.Registry.INSTANCE.get((Object)"http:///company.ecore") : new CompanyPackageImpl());
        isInited = true;
        PrimitivetypesPackageImpl thePrimitivetypesPackage = (PrimitivetypesPackageImpl)(EPackage.Registry.INSTANCE.getEPackage("http:///primitivetypes.ecore") instanceof PrimitivetypesPackageImpl ? EPackage.Registry.INSTANCE.getEPackage("http:///primitivetypes.ecore") : PrimitivetypesPackage.eINSTANCE);
        theCompanyPackage.createPackageContents();
        thePrimitivetypesPackage.createPackageContents();
        theCompanyPackage.initializePackageContents();
        thePrimitivetypesPackage.initializePackageContents();
        EValidator.Registry.INSTANCE.put((Object)theCompanyPackage, (Object)new EValidator.Descriptor(){

            public EValidator getEValidator() {
                return CompanyValidator.INSTANCE;
            }
        });
        theCompanyPackage.freeze();
        EPackage.Registry.INSTANCE.put((Object)"http:///company.ecore", (Object)theCompanyPackage);
        return theCompanyPackage;
    }

    public EClass getEmployee() {
        return this.employeeEClass;
    }

    public EAttribute getEmployee_Name() {
        return (EAttribute)this.employeeEClass.getEStructuralFeatures().get(0);
    }

    public EAttribute getEmployee_Age() {
        return (EAttribute)this.employeeEClass.getEStructuralFeatures().get(1);
    }

    public EAttribute getEmployee_Salary() {
        return (EAttribute)this.employeeEClass.getEStructuralFeatures().get(2);
    }

    public EReference getEmployee_Employer() {
        return (EReference)this.employeeEClass.getEStructuralFeatures().get(3);
    }

    public EReference getEmployee_Managed() {
        return (EReference)this.employeeEClass.getEStructuralFeatures().get(4);
    }

    public EReference getEmployee_Directed() {
        return (EReference)this.employeeEClass.getEStructuralFeatures().get(5);
    }

    public EReference getEmployee_Secretary() {
        return (EReference)this.employeeEClass.getEStructuralFeatures().get(6);
    }

    public EReference getEmployee_Intern() {
        return (EReference)this.employeeEClass.getEStructuralFeatures().get(7);
    }

    public EClass getDepartment() {
        return this.departmentEClass;
    }

    public EAttribute getDepartment_Name() {
        return (EAttribute)this.departmentEClass.getEStructuralFeatures().get(0);
    }

    public EAttribute getDepartment_MaxJuniors() {
        return (EAttribute)this.departmentEClass.getEStructuralFeatures().get(1);
    }

    public EAttribute getDepartment_Budget() {
        return (EAttribute)this.departmentEClass.getEStructuralFeatures().get(2);
    }

    public EReference getDepartment_Employee() {
        return (EReference)this.departmentEClass.getEStructuralFeatures().get(3);
    }

    public EReference getDepartment_Boss() {
        return (EReference)this.departmentEClass.getEStructuralFeatures().get(4);
    }

    public EReference getDepartment_SubDepartment() {
        return (EReference)this.departmentEClass.getEStructuralFeatures().get(5);
    }

    public EReference getDepartment_ParentDepartment() {
        return (EReference)this.departmentEClass.getEStructuralFeatures().get(6);
    }

    public EReference getDepartment_EmployeeOfTheMonth() {
        return (EReference)this.departmentEClass.getEStructuralFeatures().get(7);
    }

    public EAttribute getDepartment_BiggestNumberOfStudentsOrFreelancers() {
        return (EAttribute)this.departmentEClass.getEStructuralFeatures().get(8);
    }

    public EClass getFreelance() {
        return this.freelanceEClass;
    }

    public EAttribute getFreelance_Assignment() {
        return (EAttribute)this.freelanceEClass.getEStructuralFeatures().get(0);
    }

    public EClass getDivision() {
        return this.divisionEClass;
    }

    public EAttribute getDivision_Name() {
        return (EAttribute)this.divisionEClass.getEStructuralFeatures().get(0);
    }

    public EReference getDivision_Department() {
        return (EReference)this.divisionEClass.getEStructuralFeatures().get(1);
    }

    public EReference getDivision_Director() {
        return (EReference)this.divisionEClass.getEStructuralFeatures().get(2);
    }

    public EAttribute getDivision_Budget() {
        return (EAttribute)this.divisionEClass.getEStructuralFeatures().get(3);
    }

    public EReference getDivision_EmployeesOfTheMonth() {
        return (EReference)this.divisionEClass.getEStructuralFeatures().get(4);
    }

    public EAttribute getDivision_NumberEmployeesOfTheMonth() {
        return (EAttribute)this.divisionEClass.getEStructuralFeatures().get(5);
    }

    public EReference getDivision_Company() {
        return (EReference)this.divisionEClass.getEStructuralFeatures().get(6);
    }

    public EClass getStudent() {
        return this.studentEClass;
    }

    public EClass getCompany() {
        return this.companyEClass;
    }

    public EReference getCompany_Division() {
        return (EReference)this.companyEClass.getEStructuralFeatures().get(0);
    }

    public EAttribute getCompany_EotmDelta() {
        return (EAttribute)this.companyEClass.getEStructuralFeatures().get(1);
    }

    public EReference getCompany_DivisionDirector() {
        return (EReference)this.companyEClass.getEStructuralFeatures().get(2);
    }

    public EAttribute getCompany_Name() {
        return (EAttribute)this.companyEClass.getEStructuralFeatures().get(3);
    }

    public CompanyFactory getCompanyFactory() {
        return (CompanyFactory)this.getEFactoryInstance();
    }

    public void createPackageContents() {
        if (this.isCreated) {
            return;
        }
        this.isCreated = true;
        this.employeeEClass = this.createEClass(0);
        this.createEAttribute(this.employeeEClass, 0);
        this.createEAttribute(this.employeeEClass, 1);
        this.createEAttribute(this.employeeEClass, 2);
        this.createEReference(this.employeeEClass, 3);
        this.createEReference(this.employeeEClass, 4);
        this.createEReference(this.employeeEClass, 5);
        this.createEReference(this.employeeEClass, 6);
        this.createEReference(this.employeeEClass, 7);
        this.departmentEClass = this.createEClass(1);
        this.createEAttribute(this.departmentEClass, 0);
        this.createEAttribute(this.departmentEClass, 1);
        this.createEAttribute(this.departmentEClass, 2);
        this.createEReference(this.departmentEClass, 3);
        this.createEReference(this.departmentEClass, 4);
        this.createEReference(this.departmentEClass, 5);
        this.createEReference(this.departmentEClass, 6);
        this.createEReference(this.departmentEClass, 7);
        this.createEAttribute(this.departmentEClass, 8);
        this.freelanceEClass = this.createEClass(2);
        this.createEAttribute(this.freelanceEClass, 8);
        this.divisionEClass = this.createEClass(3);
        this.createEAttribute(this.divisionEClass, 0);
        this.createEReference(this.divisionEClass, 1);
        this.createEReference(this.divisionEClass, 2);
        this.createEAttribute(this.divisionEClass, 3);
        this.createEReference(this.divisionEClass, 4);
        this.createEAttribute(this.divisionEClass, 5);
        this.createEReference(this.divisionEClass, 6);
        this.studentEClass = this.createEClass(4);
        this.companyEClass = this.createEClass(5);
        this.createEReference(this.companyEClass, 0);
        this.createEAttribute(this.companyEClass, 1);
        this.createEReference(this.companyEClass, 2);
        this.createEAttribute(this.companyEClass, 3);
    }

    public void initializePackageContents() {
        if (this.isInitialized) {
            return;
        }
        this.isInitialized = true;
        this.setName("company");
        this.setNsPrefix("company");
        this.setNsURI("http:///company.ecore");
        PrimitivetypesPackage thePrimitivetypesPackage = (PrimitivetypesPackage)EPackage.Registry.INSTANCE.getEPackage("http:///primitivetypes.ecore");
        this.freelanceEClass.getESuperTypes().add((Object)this.getEmployee());
        this.studentEClass.getESuperTypes().add((Object)this.getEmployee());
        this.initEClass(this.employeeEClass, Employee.class, "Employee", false, false, true);
        this.initEAttribute(this.getEmployee_Name(), (EClassifier)thePrimitivetypesPackage.getString(), "name", null, 0, 1, Employee.class, false, false, true, false, false, true, false, true);
        this.initEAttribute(this.getEmployee_Age(), (EClassifier)thePrimitivetypesPackage.getInteger(), "age", null, 0, 1, Employee.class, false, false, true, false, false, true, false, true);
        this.initEAttribute(this.getEmployee_Salary(), (EClassifier)thePrimitivetypesPackage.getInteger(), "salary", null, 0, 1, Employee.class, false, false, true, false, false, true, false, true);
        this.initEReference(this.getEmployee_Employer(), (EClassifier)this.getDepartment(), this.getDepartment_Employee(), "employer", null, 0, 1, Employee.class, false, false, true, false, false, false, true, false, true);
        this.initEReference(this.getEmployee_Managed(), (EClassifier)this.getDepartment(), this.getDepartment_Boss(), "managed", null, 0, 1, Employee.class, false, false, true, false, false, false, true, false, true);
        this.initEReference(this.getEmployee_Directed(), (EClassifier)this.getDivision(), this.getDivision_Director(), "directed", null, 0, 1, Employee.class, false, false, true, false, false, false, true, false, true);
        this.initEReference(this.getEmployee_Secretary(), (EClassifier)this.getEmployee(), null, "secretary", null, 0, 1, Employee.class, false, false, true, true, false, false, true, false, true);
        this.initEReference(this.getEmployee_Intern(), (EClassifier)this.getStudent(), null, "intern", null, 0, 1, Employee.class, false, false, true, false, true, false, true, false, true);
        this.initEClass(this.departmentEClass, Department.class, "Department", false, false, true);
        this.initEAttribute(this.getDepartment_Name(), (EClassifier)thePrimitivetypesPackage.getString(), "name", null, 0, 1, Department.class, false, false, true, false, false, true, false, true);
        this.initEAttribute(this.getDepartment_MaxJuniors(), (EClassifier)thePrimitivetypesPackage.getInteger(), "maxJuniors", null, 0, 1, Department.class, false, false, true, false, false, true, false, true);
        this.initEAttribute(this.getDepartment_Budget(), (EClassifier)thePrimitivetypesPackage.getInteger(), "budget", "0", 0, 1, Department.class, false, false, true, false, false, true, false, true);
        this.initEReference(this.getDepartment_Employee(), (EClassifier)this.getEmployee(), this.getEmployee_Employer(), "employee", null, 0, -1, Department.class, false, false, true, true, false, false, true, false, true);
        this.initEReference(this.getDepartment_Boss(), (EClassifier)this.getEmployee(), this.getEmployee_Managed(), "boss", null, 0, 1, Department.class, false, false, true, false, false, false, true, false, true);
        this.initEReference(this.getDepartment_SubDepartment(), (EClassifier)this.getDepartment(), this.getDepartment_ParentDepartment(), "subDepartment", null, 0, -1, Department.class, false, false, true, true, false, false, true, false, true);
        this.initEReference(this.getDepartment_ParentDepartment(), (EClassifier)this.getDepartment(), this.getDepartment_SubDepartment(), "parentDepartment", null, 0, 1, Department.class, false, false, true, false, false, false, true, false, true);
        this.initEReference(this.getDepartment_EmployeeOfTheMonth(), (EClassifier)this.getEmployee(), null, "employeeOfTheMonth", null, 0, -1, Department.class, false, false, true, false, true, true, false, false, true);
        this.initEAttribute(this.getDepartment_BiggestNumberOfStudentsOrFreelancers(), (EClassifier)thePrimitivetypesPackage.getInteger(), "biggestNumberOfStudentsOrFreelancers", null, 0, 1, Department.class, true, true, false, false, false, true, true, false);
        this.addEOperation(this.departmentEClass, (EClassifier)thePrimitivetypesPackage.getInteger(), "calcExpenses", 0, 1, true, true);
        this.addEOperation(this.departmentEClass, (EClassifier)thePrimitivetypesPackage.getInteger(), "sumBudget", 0, 1, true, true);
        this.initEClass(this.freelanceEClass, Freelance.class, "Freelance", false, false, true);
        this.initEAttribute(this.getFreelance_Assignment(), (EClassifier)thePrimitivetypesPackage.getInteger(), "assignment", null, 0, 1, Freelance.class, false, false, true, false, false, true, false, true);
        this.initEClass(this.divisionEClass, Division.class, "Division", false, false, true);
        this.initEAttribute(this.getDivision_Name(), (EClassifier)thePrimitivetypesPackage.getString(), "name", null, 0, 1, Division.class, false, false, true, false, false, true, false, true);
        this.initEReference(this.getDivision_Department(), (EClassifier)this.getDepartment(), null, "department", null, 0, -1, Division.class, false, false, true, true, false, false, true, false, true);
        this.initEReference(this.getDivision_Director(), (EClassifier)this.getEmployee(), this.getEmployee_Directed(), "director", null, 0, 1, Division.class, false, false, true, true, false, true, true, false, true);
        this.initEAttribute(this.getDivision_Budget(), (EClassifier)thePrimitivetypesPackage.getInteger(), "budget", null, 0, 1, Division.class, false, false, true, false, false, true, false, true);
        this.initEReference(this.getDivision_EmployeesOfTheMonth(), (EClassifier)this.getEmployee(), null, "employeesOfTheMonth", null, 0, -1, Division.class, true, true, false, false, true, false, false, true, true);
        this.initEAttribute(this.getDivision_NumberEmployeesOfTheMonth(), (EClassifier)thePrimitivetypesPackage.getInteger(), "numberEmployeesOfTheMonth", "", 0, 1, Division.class, true, true, false, false, false, true, true, false);
        this.initEReference(this.getDivision_Company(), (EClassifier)this.getCompany(), this.getCompany_Division(), "company", null, 0, 1, Division.class, false, false, true, false, true, false, true, false, true);
        this.initEClass(this.studentEClass, Student.class, "Student", false, false, true);
        this.initEClass(this.companyEClass, Company.class, "Company", false, false, true);
        this.initEReference(this.getCompany_Division(), (EClassifier)this.getDivision(), this.getDivision_Company(), "division", null, 0, 1, Company.class, false, false, true, false, true, false, true, false, true);
        this.initEAttribute(this.getCompany_EotmDelta(), (EClassifier)thePrimitivetypesPackage.getInteger(), "eotmDelta", null, 0, 1, Company.class, true, true, false, false, false, true, true, true);
        this.initEReference(this.getCompany_DivisionDirector(), (EClassifier)this.getEmployee(), null, "divisionDirector", null, 0, 1, Company.class, true, true, false, false, true, true, true, true, true);
        this.initEAttribute(this.getCompany_Name(), (EClassifier)thePrimitivetypesPackage.getString(), "name", null, 0, 1, Company.class, false, true, false, false, false, true, true, true);
        this.createResource("http:///company.ecore");
        this.createEcoreAnnotations();
        this.createOCLAnnotations();
        this.createEmofAnnotations();
    }

    protected void createEcoreAnnotations() {
        String source = "http://www.eclipse.org/emf/2002/Ecore";
        this.addAnnotation((ENamedElement)this, source, new String[]{"invocationDelegates", "http://www.eclipse.org/emf/2002/Ecore/OCL", "settingDelegates", "http://www.eclipse.org/emf/2002/Ecore/OCL", "validationDelegates", "http://www.eclipse.org/emf/2002/Ecore/OCL"});
        this.addAnnotation((ENamedElement)this.employeeEClass, source, new String[]{"constraints", "UniqueNames BossIsOldest divBossSecretary secretaryOlderThanBoss Boss10YearsOlderThanEmployee Secretary10YearsOlderThanBoss"});
        this.addAnnotation((ENamedElement)this.departmentEClass, source, new String[]{"constraints", "NotBossFreelance OldEmployee MaxJuniors BossHighestSalary boss10YearsOlderThanJunior BudgetRestriction MaxJuniorsWarning departmentMustHaveDivision"});
        this.addAnnotation((ENamedElement)this.freelanceEClass, source, new String[]{"constraints", "ValidAssignment ValidAssignmentWarning StudentAndFreelancesAge"});
        this.addAnnotation((ENamedElement)this.divisionEClass, source, new String[]{"constraints", "nasty limitEmployeesOfTheMonth nestedDerivation"});
        this.addAnnotation((ENamedElement)this.studentEClass, source, new String[]{"constraints", "StudentAndFreelancesAge"});
        this.addAnnotation((ENamedElement)this.companyEClass, source, new String[]{"constraints", "eotmDeltaMax"});
    }

    protected void createOCLAnnotations() {
        String source = "http://www.eclipse.org/emf/2002/Ecore/OCL";
        this.addAnnotation((ENamedElement)this.employeeEClass, source, new String[]{"UniqueNames", "Employee.allInstances()->forAll(e | e <> self implies e.name <> self.name)", "BossIsOldest", "self.age <= self.employer.boss.age", "divBossSecretary", "if self.directed->isEmpty() then\r\nself.secretary.oclIsUndefined()\r\nelse\r\nnot self.secretary.oclIsUndefined()\r\nendif", "secretaryOlderThanBoss", "if self.directed->notEmpty() and\r\nnot self.secretary.oclIsUndefined() then\r\nself.age < self.secretary.age \r\nelse true\r\nendif", "Boss10YearsOlderThanEmployee", "self.age + 10 <= self.employer.boss.age", "Secretary10YearsOlderThanBoss", "if self.directed->notEmpty() and\r\nnot self.secretary.oclIsUndefined() then\r\nself.age + 10 < self.secretary.age \r\nelse true\r\nendif"});
        this.addAnnotation((ENamedElement)this.departmentEClass, source, new String[]{"NotBossFreelance", "not (self.boss.oclIsTypeOf(Freelance))", "OldEmployee", "self.employee->exists(e | e.age > 45)", "MaxJuniors", "self.employee->select(e|e.age < 25)->size()\r\n<self.maxJuniors", "BossHighestSalary", "self.employee->select(e|e.salary >= self.boss.salary)->size() <= 1", "boss10YearsOlderThanJunior", "let t:Tuple(boss:Employee,junior:Employee)=\r\nTuple{boss=self.boss, junior=self.employee->sortedBy(age)->first()} in\r\nt.boss.age > t.junior.age + 10", "BudgetRestriction", "self.calcExpenses() <= self.budget", "MaxJuniorsWarning", "if self.maxJuniors > 1\r\nthen\r\nself.employee->select(e|e.age < 25)->size()\r\n<self.maxJuniors - 1\r\nelse\r\ntrue\r\nendif", "departmentMustHaveDivision", "self.department2division->notEmpty()"});
        this.addAnnotation((ENamedElement)this.departmentEClass.getEOperations().get(0), source, new String[]{"body", "self.employee->iterate(e ; s : Integer = 0 | s + e.salary) + self.boss.salary"});
        this.addAnnotation((ENamedElement)this.departmentEClass.getEOperations().get(1), source, new String[]{"body", "if self.subDepartment->size() >= 1 then\r\n\tself.subDepartment->iterate(department; return : Integer = 0 | return + department.sumBudget()) + self.budget\r\nelse\r\n\tself.budget\r\nendif "});
        this.addAnnotation((ENamedElement)this.getDepartment_BiggestNumberOfStudentsOrFreelancers(), source, new String[]{"derivation", "let numFreelance : Integer = self.employee->select(e : Employee | e.oclIsKindOf(Freelance))->size() in let numStudent : Integer = self.employee->select(e : Employee | e.oclIsKindOf(Student))->size() in if numFreelance < numStudent then numStudent else numFreelance endif"});
        this.addAnnotation((ENamedElement)this.freelanceEClass, source, new String[]{"ValidAssignment", "self.assignment >= 5 and self.assignment <= 30", "ValidAssignmentWarning", "self.assignment >= 5 and self.assignment <= 40", "StudentAndFreelancesAge", "self.age < 40"});
        this.addAnnotation((ENamedElement)this.divisionEClass, source, new String[]{"nasty", "self.department->collect(d| \r\nd.employee->including(d.boss)).salary->sum() < budget", "limitEmployeesOfTheMonth", "self.employeesOfTheMonth->size() <= self.department->size()", "nestedDerivation", "self.numberEmployeesOfTheMonth <= self.department->size()"});
        this.addAnnotation((ENamedElement)this.getDivision_EmployeesOfTheMonth(), source, new String[]{"derivation", "self.department.employeeOfTheMonth"});
        this.addAnnotation((ENamedElement)this.getDivision_NumberEmployeesOfTheMonth(), source, new String[]{"derivation", "self.employeesOfTheMonth->size()"});
        this.addAnnotation((ENamedElement)this.studentEClass, source, new String[]{"StudentAndFreelancesAge", "self.age < 40"});
        this.addAnnotation((ENamedElement)this.companyEClass, source, new String[]{"eotmDeltaMax", "self.eotmDelta <= 5"});
        this.addAnnotation((ENamedElement)this.getCompany_EotmDelta(), source, new String[]{"derivation", "let maxEOTMDivision:Division=self.division->sortedBy(i | i.numberEmployeesOfTheMonth)->last() in let minEOTMDivision:Division=self.division->sortedBy(i | i.numberEmployeesOfTheMonth)->first() in maxEOTMDivision.numberEmployeesOfTheMonth - minEOTMDivision.numberEmployeesOfTheMonth"});
        this.addAnnotation((ENamedElement)this.getCompany_DivisionDirector(), source, new String[]{"derivation", "self.division.director"});
        this.addAnnotation((ENamedElement)this.getCompany_Name(), source, new String[]{"derivation", "if self.division->isEmpty() then\r\n  'Company with no division'\r\nelse\r\n  'Company with division '.concat(self.division.name)\r\nendif"});
    }

    protected void createEmofAnnotations() {
        String source = "http://schema.omg.org/spec/MOF/2.0/emof.xml";
        this.addAnnotation((ENamedElement)this.getEmployee_Secretary(), source, new String[]{"Property.oppositeRoleName", "secretary2boss"});
        this.addAnnotation((ENamedElement)this.getEmployee_Intern(), source, new String[]{"Property.oppositeRoleName", "student2employee"});
        this.addAnnotation((ENamedElement)this.getDivision_Department(), source, new String[]{"Property.oppositeRoleName", "department2division"});
    }
}

