/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.infra.discovery.benchmark.core.internal.impl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.modisco.facet.util.core.Logger;
import org.eclipse.modisco.infra.discovery.benchmark.core.ISizeDiscoverer;
import org.eclipse.modisco.infra.discovery.benchmark.core.internal.Activator;
import org.eclipse.modisco.infra.discovery.benchmark.core.internal.MathUtils;
import org.eclipse.modisco.infra.discovery.benchmark.core.internal.Messages;
import org.eclipse.modisco.infra.discovery.benchmark.core.internal.api.IDiscovererBenchmarkDiscoverer;
import org.eclipse.modisco.infra.discovery.benchmark.core.internal.api.IDiscovererID;
import org.eclipse.modisco.infra.discovery.benchmark.core.internal.api.IEventNotifier;
import org.eclipse.modisco.infra.discovery.benchmark.core.internal.exported.IDiscovererList;
import org.eclipse.modisco.infra.discovery.benchmark.core.internal.exported.IProjectSet;
import org.eclipse.modisco.infra.discovery.benchmark.core.internal.impl.DiscovererID;
import org.eclipse.modisco.infra.discovery.benchmark.core.internal.impl.EventAndMemoryRecorder;
import org.eclipse.modisco.infra.discovery.benchmark.core.internal.impl.ReportUtils;
import org.eclipse.modisco.infra.discovery.benchmark.core.internal.impl.ReportUtilsException;
import org.eclipse.modisco.infra.discovery.benchmark.metamodel.internal.benchmark.Benchmark;
import org.eclipse.modisco.infra.discovery.benchmark.metamodel.internal.benchmark.BenchmarkFactory;
import org.eclipse.modisco.infra.discovery.benchmark.metamodel.internal.benchmark.Discovery;
import org.eclipse.modisco.infra.discovery.benchmark.metamodel.internal.benchmark.DiscoveryIteration;
import org.eclipse.modisco.infra.discovery.benchmark.metamodel.internal.benchmark.EndEvent;
import org.eclipse.modisco.infra.discovery.benchmark.metamodel.internal.benchmark.Event;
import org.eclipse.modisco.infra.discovery.benchmark.metamodel.internal.benchmark.EventType;
import org.eclipse.modisco.infra.discovery.benchmark.metamodel.internal.benchmark.MemoryMeasurement;
import org.eclipse.modisco.infra.discovery.benchmark.metamodel.internal.benchmark.Project;
import org.eclipse.modisco.infra.discovery.catalog.CatalogFactory;
import org.eclipse.modisco.infra.discovery.catalog.DiscovererDescription;
import org.eclipse.modisco.infra.discovery.catalog.DiscovererParameter;
import org.eclipse.modisco.infra.discovery.core.AbstractModelDiscoverer;
import org.eclipse.modisco.infra.discovery.core.IDiscoverer;
import org.eclipse.modisco.infra.discovery.core.IDiscoveryManager;
import org.eclipse.modisco.infra.discovery.core.annotations.Parameter;
import org.eclipse.modisco.infra.discovery.core.exception.DiscoveryException;
import org.eclipse.modisco.infra.discovery.launch.LaunchConfiguration;
import org.eclipse.modisco.infra.discovery.launch.LaunchFactory;
import org.eclipse.modisco.infra.discovery.launch.ParameterValue;
import org.eclipse.modisco.utils.core.internal.exported.SystemInfo;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiscovererBenchmarkDiscoverer
extends AbstractModelDiscoverer<IProjectSet>
implements IDiscovererBenchmarkDiscoverer {
    private static final String SAVE_OPERATION = "SaveOperation";
    private static final int INTERVAL = 1000;
    private static final int MSINSEC = 1000;
    private static final String CODE_EXTENSION = "java";
    public static final String ID = "org.eclipse.modisco.infra.discovery.benchmark.core.api.benchmarkdiscoverer";
    private static final long BYTEPERMB = 0x100000L;
    private IDiscovererID discovererID = new DiscovererID("org.eclipse.modisco.infra.discovery.benchmark.core.api.benchmarkdiscoverer");
    private int iterations;
    private boolean measureMemoryUse;
    private int memPollInterval = 0;
    private boolean generateHtml;
    private URI htmlReportLoc;
    private final List<MemoryMeasurement> memMeasurements = new LinkedList<MemoryMeasurement>();
    private final List<Event> events = new LinkedList<Event>();
    private final ResourceSet rSet = new ResourceSetImpl();
    private EventAndMemoryRecorder recorder;
    private IDiscovererList discoverers;
    private String sizeDiscovererId;

    public DiscovererBenchmarkDiscoverer() {
        Resource.Factory.Registry rFactoryRegistry = this.rSet.getResourceFactoryRegistry();
        Map extToFactoryMap = rFactoryRegistry.getExtensionToFactoryMap();
        extToFactoryMap.put("xmi", new XMIResourceFactoryImpl());
        this.iterations = 1;
    }

    protected IDiscovererList getDiscoverers() {
        return this.discoverers;
    }

    @Parameter(name="DISCOVERER_LIST", description="The list of discoverers.", requiresInputValue=true)
    public void setDiscoverers(IDiscovererList discos) {
        this.discoverers = discos;
    }

    public Resource discoverBenchmark(IProjectSet projects, IProgressMonitor progressMonitor) throws DiscoveryException {
        this.recorder = new EventAndMemoryRecorder(this.measureMemoryUse, this.memPollInterval);
        int nbDiscoToDo = this.getIterations() * projects.getProjects().size() * this.discoverers.getDiscoverers().size();
        progressMonitor.beginTask(Messages.DiscovererBenchmarkDiscoverer_BenchmarkTaskName, nbDiscoToDo);
        Benchmark benchmark = this.benchmarkInit(projects, progressMonitor);
        int i = 1;
        while (i <= this.iterations) {
            for (Discovery discovery : benchmark.getDiscoveries()) {
                progressMonitor.subTask(Messages.DiscovererBenchmarkDiscoverer_DiscoveryInitializationSubTask);
                org.eclipse.modisco.infra.discovery.benchmark.metamodel.internal.benchmark.Resource resource = discovery.getProject();
                if (!(resource instanceof Project)) continue;
                Project projectDesc = (Project)resource;
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectDesc.getName());
                AbstractModelDiscoverer<IProject> discoverer = this.preformIteration(progressMonitor, benchmark, project, discovery, i);
                this.postDiscoveryDiscoInit(discovery, discoverer);
            }
            ++i;
        }
        benchmark.setJvmMaxHeapInMiB(this.computeMaxMemoryUsage());
        this.save(benchmark, progressMonitor);
        progressMonitor.worked(nbDiscoToDo);
        if (this.isGenerateHtmlReport()) {
            this.safeGenerateHtmlReport(progressMonitor, benchmark);
        }
        progressMonitor.done();
        return benchmark.eResource();
    }

    private AbstractModelDiscoverer<IProject> preformIteration(IProgressMonitor progressMonitor, Benchmark benchmark, IProject project, Discovery disco, int iteration) {
        String discovererId = disco.getDiscovererId();
        String infoMsg = String.format("Excuting the discoverer '%s' on '%s' (iteration=%s)", discovererId, project.getName(), iteration);
        Logger.logInfo((String)infoMsg, (Plugin)Activator.getDefault());
        AbstractModelDiscoverer discoverer = (AbstractModelDiscoverer)IDiscoveryManager.INSTANCE.createDiscovererImpl(discovererId);
        URI serializationLoc = this.getSerializationLoc((AbstractModelDiscoverer<IProject>)discoverer);
        progressMonitor.subTask(NLS.bind((String)Messages.DiscovererBenchmarkDiscoverer_ProjectDiscoveryIterationSubTask, (Object)String.valueOf(this.getIterations())));
        String suffix = String.format("%s_%s_i%s.xmi", discovererId, project.getName(), String.valueOf(iteration));
        URI uri = serializationLoc.appendSegment(suffix);
        discoverer.setTargetURI(uri);
        boolean failure = false;
        StringBuilder discoveryErrors = new StringBuilder();
        this.recorder.reset();
        if (IEventNotifier.class.isInstance(discoverer)) {
            ((IEventNotifier)discoverer).addListener(this.recorder);
        }
        this.recorder.start();
        try {
            if (discoverer.isApplicableTo((Object)project)) {
                SubProgressMonitor subProgressM = new SubProgressMonitor(progressMonitor, 0);
                discoverer.discoverElement((Object)project, (IProgressMonitor)subProgressM);
            } else {
                String message = String.format("Discoverer '%s' is not applicable on project '%s'.", discovererId, project.getName());
                Logger.logError((String)message, (Plugin)Activator.getDefault());
            }
        }
        catch (Exception e) {
            failure = true;
            discoveryErrors.append(e.getStackTrace().toString());
            String message = String.format("Benchmark of discoverer %s fails on project '%s'", discovererId, project.getName());
            Logger.logError((Throwable)e, (String)message, (Plugin)Activator.getDefault());
        }
        this.recorder.stop();
        this.events.addAll(this.recorder.getEvents());
        this.events.addAll(this.recorder.getMemoryMeasurements());
        this.memMeasurements.addAll(this.recorder.getMemoryMeasurements());
        if (IEventNotifier.class.isInstance(discoverer)) {
            ((IEventNotifier)discoverer).removeListener(this.recorder);
        }
        DiscoveryIteration iterationDesc = DiscovererBenchmarkDiscoverer.createDiscoveryIteration(this.recorder);
        if (failure) {
            iterationDesc.setDiscoveryErrors(discoveryErrors.toString());
        }
        disco.getIterations().add((Object)iterationDesc);
        this.save(benchmark, progressMonitor);
        progressMonitor.worked(1);
        return discoverer;
    }

    private URI getSerializationLoc(AbstractModelDiscoverer<IProject> discoverer) {
        URI result = discoverer.getTargetURI() == null ? DiscovererBenchmarkDiscoverer.basicGetSerializationLoc(this) : DiscovererBenchmarkDiscoverer.basicGetSerializationLoc(discoverer);
        return result;
    }

    private Project createProjectDescription(IProject project, Benchmark benchmark, IProgressMonitor progressMonitor) throws DiscoveryException {
        progressMonitor.subTask(Messages.DiscovererBenchmarkDiscoverer_ProjectInitializationSubTask);
        ISizeDiscoverer discoverer = (ISizeDiscoverer)IDiscoveryManager.INSTANCE.createDiscovererImpl(this.sizeDiscovererId);
        Project projDesc = BenchmarkFactory.eINSTANCE.createProject();
        discoverer.discoverElement(project, (IProgressMonitor)new NullProgressMonitor());
        double prjSize = discoverer.getSize();
        projDesc.setInputSize(prjSize);
        String prjUnit = discoverer.getUnit();
        projDesc.setInputSizeUnit(prjUnit);
        projDesc.setName(project.getName());
        benchmark.getProjects().add((Object)projDesc);
        return projDesc;
    }

    private void save(Benchmark benchmark, IProgressMonitor progressMonitor) {
        if (this.isTargetSerializationChosen()) {
            try {
                progressMonitor.subTask(Messages.DiscovererBenchmarkDiscoverer_SavingBenchmarkDataSubTask);
                this.saveTargetModel(benchmark);
            }
            catch (IOException e) {
                Logger.logError((Throwable)e, (String)"Failed to save the benchmark model.", (Plugin)Activator.getDefault());
            }
        }
    }

    private static URI basicGetSerializationLoc(AbstractModelDiscoverer<?> discoverer) {
        URI targetURI = discoverer.getTargetURI();
        return targetURI.trimFileExtension();
    }

    private static long computeSize(AbstractModelDiscoverer<IProject> discoverer) {
        long size = 0L;
        Resource targetModel = discoverer.getTargetModel();
        if (targetModel == null) {
            String message = String.format("Unable to compute the number of element of an unexisting model for the discoverer '%s'", discoverer.getClass().getName());
            Logger.logWarning((String)message, (Plugin)Activator.getDefault());
        } else {
            TreeIterator allContents;
            TreeIterator iterator = allContents = targetModel.getAllContents();
            while (iterator.hasNext()) {
                iterator.next();
                ++size;
            }
        }
        return size;
    }

    private void safeGenerateHtmlReport(IProgressMonitor progressMonitor, Benchmark benchmark) {
        try {
            this.generateHtmlReport(progressMonitor, benchmark);
        }
        catch (Exception e) {
            Logger.logError((Throwable)e, (String)"Report generation fail", (Plugin)Activator.getDefault());
        }
    }

    private void generateHtmlReport(IProgressMonitor parentMonitor, Benchmark benchmark) throws ReportUtilsException, CoreException {
        parentMonitor.subTask(Messages.DiscovererBenchmarkDiscoverer_GeneratingBenchmarkReportSubTask);
        SubProgressMonitor progressMonitor = new SubProgressMonitor(parentMonitor, 0);
        URI targetURI = null;
        targetURI = this.getHtmlReportLocation() == null ? this.getTargetURI() : this.getHtmlReportLocation();
        if (targetURI == null) {
            Logger.logWarning((String)"The HTML_REPORT_LOCATION or the TARGET_URI parameter should not be null", (Plugin)Activator.getDefault());
            return;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot wsRoot = workspace.getRoot();
        File file = null;
        IFile iFile = null;
        String targetUriStr = targetURI.toString();
        if (targetURI.isPlatformResource()) {
            String pathStr = targetUriStr.replaceAll("platform:/resource", "");
            iFile = wsRoot.getFile((IPath)new Path(pathStr));
            iFile.getLocation().toFile();
        } else if (targetURI.isFile()) {
            file = new File(java.net.URI.create(targetUriStr));
        } else {
            String message = String.format("The following target URI '%s' is not managed. 'platform:/resource' or 'file:/' are expected.", targetURI.toString());
            throw new IllegalArgumentException(message);
        }
        ArrayList arguments = new ArrayList();
        ReportUtils.generateReport(benchmark, file, arguments, this.measureMemoryUse);
        if (iFile != null) {
            IContainer location = iFile.getParent();
            location.refreshLocal(2, (IProgressMonitor)progressMonitor);
        }
    }

    private void setLaunchParameter(Discovery disco, AbstractModelDiscoverer<IProject> discoverer) {
        LaunchConfiguration launchConfig = disco.getDiscovererLaunchConfiguration();
        if (launchConfig != null) {
            for (ParameterValue pv : launchConfig.getParameterValues()) {
                DiscovererParameter parameter = pv.getParameter();
                Object value = pv.getValue();
                if (value == null) continue;
                try {
                    if (parameter.getSetter() == null) {
                        Method setter = DiscovererBenchmarkDiscoverer.findSetter(discoverer.getClass(), parameter.getId());
                        parameter.setSetter(setter);
                    }
                    DiscovererBenchmarkDiscoverer.setValue(parameter, discoverer, value);
                }
                catch (DiscoveryException e) {
                    Logger.logWarning((Throwable)e, (Plugin)Activator.getDefault());
                }
            }
        }
    }

    private static Method findSetter(Class<? extends AbstractModelDiscoverer> clazz, String paramId) {
        Method result = null;
        Method[] methodArray = clazz.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Parameter param;
            Method method = methodArray[n2];
            if (method.isAnnotationPresent(Parameter.class) && (param = method.getAnnotation(Parameter.class)).name().equals(paramId) && method.getReturnType().equals(Void.TYPE)) {
                result = method;
            }
            ++n2;
        }
        return result;
    }

    private static void setValue(DiscovererParameter parameter, IDiscoverer<?> discoverer, Object parameterValue) throws DiscoveryException {
        block6: {
            try {
                if (parameter.getField() != null && Modifier.isPublic((int)parameter.getField().getModifiers())) {
                    parameter.getField().set(discoverer, parameterValue);
                    break block6;
                }
                if (parameter.getSetter() != null && Modifier.isPublic((int)parameter.getSetter().getModifiers())) {
                    parameter.getSetter().invoke(discoverer, parameterValue);
                    break block6;
                }
                String message = String.format("The discoverer '%s' does not implement public write access to the parameter '%s'", discoverer.getClass(), parameter.getId());
                throw new DiscoveryException(message);
            }
            catch (IllegalArgumentException e) {
                DiscovererBenchmarkDiscoverer.onInvokeException(parameter, parameterValue, e);
            }
            catch (IllegalAccessException e) {
                DiscovererBenchmarkDiscoverer.onInvokeException(parameter, parameterValue, e);
            }
            catch (InvocationTargetException e) {
                DiscovererBenchmarkDiscoverer.onInvokeException(parameter, parameterValue, e);
            }
        }
    }

    private static void onInvokeException(DiscovererParameter parameter, Object parameterValue, Exception exception) throws DiscoveryException {
        String message = String.format("Illegal parameter value for '%s' : %s", parameter.getId(), parameterValue);
        throw new DiscoveryException(message, (Throwable)exception);
    }

    private void saveTargetModel(Benchmark benchmark) throws IOException {
        if (this.getTargetURI() == null && this.getTargetModel() == null) {
            Logger.logWarning((String)"The parameter TARGET_URI should not be empty", (Plugin)Activator.getDefault());
            return;
        }
        Resource resource = benchmark.eResource();
        if (resource == null) {
            URI resourceUri = this.getTargetModel() == null ? this.getTargetURI() : this.getTargetModel().getURI();
            resource = this.rSet.createResource(resourceUri);
            resource.getContents().add((Object)benchmark);
        }
        ArrayList<Event> eventsList = new ArrayList<Event>();
        ArrayList<EventType> eventTypeList = new ArrayList<EventType>();
        for (Discovery discovery : benchmark.getDiscoveries()) {
            for (DiscoveryIteration iteration : discovery.getIterations()) {
                for (Event event : iteration.getEvents()) {
                    eventsList.add(event);
                    eventTypeList.add(event.getEventType());
                }
            }
        }
        resource.getContents().addAll(eventTypeList);
        this.setTargetModel(resource);
        this.saveTargetModel();
    }

    private long computeMaxMemoryUsage() {
        long max = 0L;
        for (MemoryMeasurement measure : this.memMeasurements) {
            if (max >= measure.getMemoryUsed()) continue;
            max = measure.getMemoryUsed();
        }
        return max;
    }

    private Benchmark benchmarkInit(IProjectSet projects, IProgressMonitor progressMonitor) throws DiscoveryException {
        progressMonitor.subTask(Messages.DiscovererBenchmarkDiscoverer_BenchmarkInitializationSubTask);
        Benchmark benchmark = BenchmarkFactory.eINSTANCE.createBenchmark();
        try {
            SystemInfo sysInfo = SystemInfo.getInstance();
            benchmark.setJvmMaxHeapInMiB(Runtime.getRuntime().maxMemory() / 0x100000L);
            benchmark.setProcessorName(sysInfo.getProcName());
            benchmark.setProcessorDescription(sysInfo.getProcDescription());
            benchmark.setProcessorCount(sysInfo.getnProcessors());
            benchmark.setProcessorCacheSize(sysInfo.getProcCacheSize());
            benchmark.setSystemMemory(sysInfo.getMemory());
            benchmark.setOsName(sysInfo.getOsName());
            benchmark.setOsVersion(sysInfo.getOsVersion());
            benchmark.setOsArchitecture(sysInfo.getArch());
        }
        catch (IOException e) {
            Logger.logError((Throwable)e, (String)"Could not get system information for benchmark", (Plugin)Activator.getDefault());
        }
        for (IProject project : projects.sortBySize().getProjects()) {
            Project projectDesc = this.createProjectDescription(project, benchmark, progressMonitor);
            for (Discovery discovery : this.discoverers) {
                this.createDiscovery(projectDesc, discovery, benchmark);
            }
        }
        return benchmark;
    }

    private Discovery createDiscovery(Project projectDesc, Discovery discovery, Benchmark benchmark) throws DiscoveryException {
        String discovererId = discovery.getDiscovererId();
        AbstractModelDiscoverer discoverer = (AbstractModelDiscoverer)IDiscoveryManager.INSTANCE.createDiscovererImpl(discovererId);
        if (discoverer == null) {
            String message = String.format("The discoverer '%s' does not exists.", discovererId);
            throw new DiscoveryException(message);
        }
        Discovery disco = BenchmarkFactory.eINSTANCE.createDiscovery();
        disco.setProject((org.eclipse.modisco.infra.discovery.benchmark.metamodel.internal.benchmark.Resource)projectDesc);
        disco.setName(discoverer.toString());
        disco.setDiscovererClassName(discoverer.getClass().getName());
        disco.setDiscovererId(discovererId);
        DiscovererDescription discoDesc = CatalogFactory.eINSTANCE.createDiscovererDescription();
        LaunchConfiguration discoLaunchConfig = discovery.getDiscovererLaunchConfiguration();
        if (discoLaunchConfig != null) {
            LaunchConfiguration launchConfig = LaunchFactory.eINSTANCE.createLaunchConfiguration();
            launchConfig.setSource((Object)projectDesc.getName());
            launchConfig.setDiscoverer(discoDesc);
            launchConfig.setOpenModelAfterDiscovery(discoLaunchConfig.isOpenModelAfterDiscovery());
            for (ParameterValue paramValue : discoLaunchConfig.getParameterValues()) {
                ParameterValue newParamValue = LaunchFactory.eINSTANCE.createParameterValue();
                newParamValue.setValue(paramValue.getValue());
                DiscovererParameter param = CatalogFactory.eINSTANCE.createDiscovererParameter();
                param.setDescription(paramValue.getParameter().getDescription());
                param.setDirection(paramValue.getParameter().getDirection());
                param.setDiscoverer(discoDesc);
                param.setField(paramValue.getParameter().getField());
                param.setGetter(paramValue.getParameter().getGetter());
                param.setId(paramValue.getParameter().getId());
                param.setInitializer(paramValue.getParameter().getInitializer());
                param.setRequiredInput(paramValue.getParameter().isRequiredInput());
                param.setSetter(paramValue.getParameter().getSetter());
                param.setType(paramValue.getParameter().getType());
                newParamValue.setParameter(param);
                launchConfig.getParameterValues().add((Object)newParamValue);
            }
            disco.setDiscovererLaunchConfiguration(launchConfig);
        }
        if (discovery.getCopyOfDiscovererDescription() == null) {
            discoDesc.setId(disco.getDiscovererId());
            discoDesc.setSourceType(projectDesc.getClass());
            discoDesc.setImplementationType(discoverer.getClass());
        } else {
            discoDesc.setId(discovery.getCopyOfDiscovererDescription().getId());
            discoDesc.setImplementationBundle(discovery.getCopyOfDiscovererDescription().getImplementationBundle());
            discoDesc.setImplementationType(discovery.getCopyOfDiscovererDescription().getImplementationType());
            discoDesc.setSourceType(discovery.getCopyOfDiscovererDescription().getSourceType());
        }
        disco.setCopyOfDiscovererDescription(discoDesc);
        benchmark.getDiscoveries().add((Object)disco);
        this.setLaunchParameter(disco, (AbstractModelDiscoverer<IProject>)discoverer);
        return disco;
    }

    private void postDiscoveryDiscoInit(Discovery disco, AbstractModelDiscoverer<IProject> discoverer) {
        if (this.iterations > 0) {
            MathUtils.Resolver<DiscoveryIteration> discoTimeResolver = new MathUtils.Resolver<DiscoveryIteration>(){

                @Override
                public double getValue(DiscoveryIteration object) {
                    return object.getDiscoveryTimeInSeconds();
                }
            };
            disco.setDiscoveryTimeAverageInSeconds(MathUtils.average(disco.getIterations(), discoTimeResolver));
            disco.setExecutionTimeStandardDeviation(MathUtils.standardDeviation(disco.getIterations(), discoTimeResolver));
            MathUtils.Resolver<DiscoveryIteration> saveTimeResolver = new MathUtils.Resolver<DiscoveryIteration>(){

                @Override
                public double getValue(DiscoveryIteration object) {
                    return object.getSaveTimeInSeconds();
                }
            };
            disco.setSaveTimeAverageInSeconds(MathUtils.average(disco.getIterations(), saveTimeResolver));
            disco.setSaveTimeStandardDeviation(MathUtils.standardDeviation(disco.getIterations(), saveTimeResolver));
            disco.setNumberOfModelElements(DiscovererBenchmarkDiscoverer.computeSize(discoverer));
            URI targetURI = discoverer.getTargetURI();
            String targetUriStr = targetURI.toString();
            try {
                IWorkspace workspace = ResourcesPlugin.getWorkspace();
                IWorkspaceRoot wsRoot = workspace.getRoot();
                IPath wsLoc = wsRoot.getLocation();
                String wsLocStr = wsLoc.toString();
                String locationString = "file://" + wsLocStr + targetUriStr;
                java.net.URI uri = java.net.URI.create(locationString);
                IFileStore fileStore = EFS.getStore((java.net.URI)uri);
                disco.setXmiSizeInBytes(fileStore.fetchInfo().getLength());
            }
            catch (Exception e) {
                String message = String.format("Could not get output model size (%s).", targetUriStr);
                Logger.logError((Throwable)e, (String)message, (Plugin)Activator.getDefault());
            }
        }
    }

    private static DiscoveryIteration createDiscoveryIteration(EventAndMemoryRecorder recoreder) {
        DiscoveryIteration discoIter = BenchmarkFactory.eINSTANCE.createDiscoveryIteration();
        discoIter.setDiscoveryDate(new Date());
        discoIter.setMaxUsedMemoryInBytes(recoreder.getMaxMemoryUsed());
        discoIter.getEvents().addAll(recoreder.getEvents());
        discoIter.setDiscoveryTimeInSeconds((double)((recoreder.getStopTime() - recoreder.getStartTime()) / 1000L));
        for (Event event : recoreder.getEvents()) {
            if (!(event instanceof EndEvent) || !event.getEventType().getName().equals(SAVE_OPERATION)) continue;
            double saveTime = event.getTime() - ((EndEvent)event).getBeginning().getTime();
            discoIter.setSaveTimeInSeconds(saveTime / 1000.0);
            discoIter.setDiscoveryTimeInSeconds(discoIter.getDiscoveryTimeInSeconds() - discoIter.getSaveTimeInSeconds());
        }
        discoIter.getMemoryMeasurements().addAll(recoreder.getMemoryMeasurements());
        return discoIter;
    }

    private Project createBenchmarkProjectAndFiles(IProject project) {
        Project proj = BenchmarkFactory.eINSTANCE.createProject();
        proj.setName(project.getName());
        try {
            IResource[] iResourceArray = project.members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource res = iResourceArray[n2];
                if (res instanceof IFolder) {
                    List<org.eclipse.modisco.infra.discovery.benchmark.metamodel.internal.benchmark.File> files = this.createFiles((IFolder)res, new LinkedList<org.eclipse.modisco.infra.discovery.benchmark.metamodel.internal.benchmark.File>());
                    proj.getFiles().addAll(files);
                } else if (res instanceof IFile) {
                    org.eclipse.modisco.infra.discovery.benchmark.metamodel.internal.benchmark.File file = DiscovererBenchmarkDiscoverer.createFile(res);
                    proj.getFiles().add((Object)file);
                }
                ++n2;
            }
            if (proj.getFiles().isEmpty()) {
                proj.setAverageFileSizeInBytes(0L);
                proj.setTotalSizeInBytes(0L);
                proj.setAverageLinesPerFile(0L);
                proj.setTotalLines(0L);
            } else {
                long totalLineSize = 0L;
                long totalByteSize = 0L;
                for (org.eclipse.modisco.infra.discovery.benchmark.metamodel.internal.benchmark.File f : proj.getFiles()) {
                    totalLineSize += f.getLines();
                    totalByteSize += f.getSizeInBytes();
                }
                proj.setAverageFileSizeInBytes(totalByteSize / (long)proj.getFiles().size());
                proj.setTotalSizeInBytes(totalByteSize);
                proj.setAverageLinesPerFile(totalLineSize / DiscovererBenchmarkDiscoverer.getNumberOfSourceCodeFiles(proj));
                proj.setTotalLines(totalLineSize);
            }
        }
        catch (CoreException e) {
            String message = String.format("Could not get members of the project '%s'.", project.getName());
            Logger.logError((Throwable)e, (String)message, (Plugin)Activator.getDefault());
        }
        return proj;
    }

    private static long getNumberOfSourceCodeFiles(Project proj) {
        int number = 0;
        for (org.eclipse.modisco.infra.discovery.benchmark.metamodel.internal.benchmark.File file : proj.getFiles()) {
            if (file.getLines() != 0L) continue;
            ++number;
        }
        return number;
    }

    private List<org.eclipse.modisco.infra.discovery.benchmark.metamodel.internal.benchmark.File> createFiles(IFolder folder, List<org.eclipse.modisco.infra.discovery.benchmark.metamodel.internal.benchmark.File> files) throws CoreException {
        IResource[] iResourceArray = folder.members();
        int n = iResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResource res = iResourceArray[n2];
            if (res instanceof IFolder) {
                List<org.eclipse.modisco.infra.discovery.benchmark.metamodel.internal.benchmark.File> newFiles = this.createFiles((IFolder)res, new LinkedList<org.eclipse.modisco.infra.discovery.benchmark.metamodel.internal.benchmark.File>());
                files.addAll(newFiles);
            } else if (res instanceof IFile) {
                org.eclipse.modisco.infra.discovery.benchmark.metamodel.internal.benchmark.File file = DiscovererBenchmarkDiscoverer.createFile(res);
                files.add(file);
            }
            ++n2;
        }
        return files;
    }

    private static org.eclipse.modisco.infra.discovery.benchmark.metamodel.internal.benchmark.File createFile(IResource res) throws CoreException {
        IFileStore fileStore = EFS.getStore((java.net.URI)res.getLocationURI());
        org.eclipse.modisco.infra.discovery.benchmark.metamodel.internal.benchmark.File file = BenchmarkFactory.eINSTANCE.createFile();
        file.setSizeInBytes(fileStore.fetchInfo().getLength());
        file.setFilepath(res.getFullPath().toString());
        file.setLines(DiscovererBenchmarkDiscoverer.getLineNumber(res));
        return file;
    }

    private static long getLineNumber(IResource res) {
        int lines = 0;
        if (res == null) {
            Logger.logWarning((String)"Unable to compute the number of lines of an unexisting file", (Plugin)Activator.getDefault());
        } else if (res.getFileExtension() != null && res.getFileExtension().endsWith(CODE_EXTENSION)) {
            try {
                File file = res.getLocation().toFile();
                BufferedReader bReader = new BufferedReader(new FileReader(file));
                lines = 0;
                while (bReader.readLine() != null) {
                    ++lines;
                }
                bReader.close();
            }
            catch (Exception e) {
                String message = String.format("Counting the number of lines is '%s' failed ", res.getName());
                Logger.logWarning((Throwable)e, (String)message, (Plugin)Activator.getDefault());
            }
        }
        return lines;
    }

    public boolean isApplicableTo(IProjectSet sources) {
        boolean result = true;
        for (IProject source : sources.getProjects()) {
            boolean bl = result = result && source.getProject().isAccessible();
        }
        return result;
    }

    protected void basicDiscoverElement(IProjectSet sources, IProgressMonitor monitor) throws DiscoveryException {
        this.discoverBenchmark(sources, monitor);
    }

    public void setDiscovererID(IDiscovererID discoId) {
        this.discovererID = discoId;
    }

    public void setSizeDiscovererId(String sizeDiscovererId) {
        this.sizeDiscovererId = sizeDiscovererId;
    }

    @Parameter(name="NUMBER_OF_ITERATIONS", description="The number of iterations to do.", requiresInputValue=true)
    public void setIterations(int it) {
        this.iterations = it;
    }

    @Parameter(name="MEASURE_MEMORY_USAGE", description="Tells if the memory usage should be measured or not.", requiresInputValue=true)
    public void setMeasureMemoryUse(boolean measure) {
        this.measureMemoryUse = measure;
        if (this.measureMemoryUse && this.memPollInterval == 0) {
            this.memPollInterval = 1000;
        }
    }

    @Parameter(name="MEMORY_POLLING_INTERVAL", description="The time interval between to memory measurement (default value is 1 sec)", requiresInputValue=false)
    public void setMemoryPollingInterval(int memoryInterval) {
        this.memPollInterval = memoryInterval;
    }

    @Parameter(name="GENERATE_HTML_REPORT", description="Tells if a html report should be generated.", requiresInputValue=true)
    public void setGenerateHtmlReport(boolean generate) {
        this.generateHtml = generate;
    }

    public void setTargetURI(URI targetURI) {
        super.setTargetURI(targetURI);
        super.setTargetModel(this.rSet.createResource(targetURI));
    }

    @Parameter(name="TARGET_URI")
    public URI getTargetURI() {
        return super.getTargetURI();
    }

    @Override
    public IDiscovererID getDiscovererID() {
        return this.discovererID;
    }

    @Override
    public int getIterations() {
        return this.iterations;
    }

    @Override
    public boolean isMeasureMemoryUse() {
        return this.measureMemoryUse;
    }

    @Override
    public int getMemoryPollingInterval() {
        return this.memPollInterval;
    }

    @Override
    public boolean isGenerateHtmlReport() {
        return this.generateHtml;
    }

    public URI getHtmlReportLocation() {
        return this.htmlReportLoc;
    }

    @Parameter(name="HTML_REPORT_LOCATION", description="Tells the location of the HTML report, should be set if GENERATE_HTML_REPORT is true", requiresInputValue=false)
    public void setHtmlReportLocation(URI htmlReportUri) {
        this.htmlReportLoc = htmlReportUri;
    }
}

