/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.editor.provider;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.editor.provider.ClasspathUriResolutionException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.JarPackageFragmentRoot;
import org.eclipse.osgi.baseadaptor.BaseData;
import org.eclipse.osgi.framework.internal.core.BundleHost;
import org.eclipse.osgi.framework.internal.core.BundleURLConnection;
import org.osgi.framework.Bundle;

public class ClasspathUriResolver {
    public static final String CLASSPATH_SCHEME = "classpath";

    public URI resolve(ClassLoader classLoader, URI classpathUri) {
        try {
            if (ClasspathUriResolver.isClasspathUri(classpathUri)) {
                return this.findResourceOnClasspath(classLoader, classpathUri);
            }
        }
        catch (Exception exc) {
            throw new ClasspathUriResolutionException(exc);
        }
        return classpathUri;
    }

    public URI resolve(IResource resource, URI classpathUri) {
        try {
            if (ClasspathUriResolver.isClasspathUri(classpathUri)) {
                IProject project = resource.getProject();
                IJavaProject javaProject = JavaCore.create((IProject)project);
                return this.findResourceInWorkspace(javaProject, classpathUri);
            }
        }
        catch (Exception exc) {
            throw new ClasspathUriResolutionException(exc);
        }
        return classpathUri;
    }

    public URI resolve(IJavaElement javaElement, URI classpathUri) {
        try {
            if (ClasspathUriResolver.isClasspathUri(classpathUri)) {
                IJavaProject javaProject = javaElement.getJavaProject();
                return this.findResourceInWorkspace(javaProject, classpathUri);
            }
        }
        catch (Exception exc) {
            throw new ClasspathUriResolutionException(exc);
        }
        return classpathUri;
    }

    public URI resolve(Bundle bundle, URI classpathUri) {
        try {
            if (ClasspathUriResolver.isClasspathUri(classpathUri)) {
                return this.findResourceInBundle(bundle, classpathUri);
            }
        }
        catch (Exception exc) {
            throw new ClasspathUriResolutionException(exc);
        }
        return classpathUri;
    }

    public static boolean isClasspathUri(URI uri) {
        String scheme = uri.scheme();
        return CLASSPATH_SCHEME.equals(scheme);
    }

    private URI findResourceOnClasspath(ClassLoader classLoader, URI classpathUri) throws URISyntaxException {
        String pathAsString = classpathUri.path();
        if (classpathUri.hasAbsolutePath()) {
            pathAsString = pathAsString.substring(1);
        }
        URL resource = classLoader.getResource(pathAsString);
        URI fileUri = URI.createURI((String)resource.toURI().toString());
        return fileUri;
    }

    private URI findResourceInBundle(Bundle bundle, URI classpathUri) throws MalformedURLException, IOException {
        String projectRelativePath;
        URL resourceUrl;
        Path fullPath = new Path(classpathUri.path());
        if (bundle != null && (resourceUrl = bundle.getResource(projectRelativePath = "/" + fullPath)) != null) {
            String baseUrl = ((BaseData)((BundleHost)bundle).getBundleData()).getBundleFile().getBaseFile().toURL().toString();
            if (baseUrl.endsWith(".jar")) {
                baseUrl = "jar:" + baseUrl + "!/";
            }
            String localUrl = ((BundleURLConnection)resourceUrl.openConnection()).getLocalURL().toString();
            String platformPluginUri = String.valueOf(bundle.getSymbolicName()) + "/" + localUrl.substring(baseUrl.length());
            URI normalizedURI = URI.createPlatformPluginURI((String)platformPluginUri, (boolean)true);
            return normalizedURI;
        }
        return classpathUri;
    }

    private URI findResourceInWorkspace(IJavaProject javaProject, URI classpathUri) throws JavaModelException, CoreException {
        Path fullPath = new Path(classpathUri.path());
        String projectRelativePath = fullPath.toString();
        if (javaProject.exists()) {
            IPackageFragmentRoot[] allPackageFragmentRoots;
            IPackageFragmentRoot[] iPackageFragmentRootArray = allPackageFragmentRoots = javaProject.getAllPackageFragmentRoots();
            int n = allPackageFragmentRoots.length;
            int n2 = 0;
            while (n2 < n) {
                IPackageFragmentRoot packageFragmentRoot = iPackageFragmentRootArray[n2];
                IResource correspondingResource = packageFragmentRoot.getCorrespondingResource();
                if (correspondingResource != null) {
                    if (correspondingResource instanceof IFile) {
                        ZipEntry zipEntry;
                        ZipFile zipFile;
                        JarPackageFragmentRoot jarPackageFragmentRoot = (JarPackageFragmentRoot)JavaCore.createJarPackageFragmentRootFrom((IFile)((IFile)correspondingResource));
                        if (jarPackageFragmentRoot != null && (zipFile = jarPackageFragmentRoot.getJar()) != null && (zipEntry = zipFile.getEntry(projectRelativePath.substring(1))) != null) {
                            return URI.createURI((String)("jar:platform:/resource" + correspondingResource.getFullPath() + "!" + projectRelativePath), (boolean)true);
                        }
                    } else {
                        IFolder rootFolder = (IFolder)correspondingResource;
                        IResource modelFile = rootFolder.findMember(projectRelativePath);
                        if (modelFile != null && modelFile.exists() && modelFile instanceof IFile) {
                            URI platformResourceUri = URI.createPlatformResourceURI((String)modelFile.getFullPath().toString(), (boolean)true);
                            return platformResourceUri;
                        }
                    }
                }
                ++n2;
            }
        }
        return classpathUri;
    }
}

