/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.editors.template.scanner;

import java.util.ArrayList;
import org.eclipse.acceleo.internal.ide.ui.editors.template.color.AcceleoColor;
import org.eclipse.acceleo.internal.ide.ui.editors.template.rules.ISequenceRule;
import org.eclipse.acceleo.internal.ide.ui.editors.template.rules.KeywordRule;
import org.eclipse.acceleo.internal.ide.ui.editors.template.rules.SequenceBlockRule;
import org.eclipse.acceleo.internal.ide.ui.editors.template.scanner.AbstractAcceleoScanner;
import org.eclipse.acceleo.internal.ide.ui.editors.template.scanner.AcceleoToken;
import org.eclipse.acceleo.internal.ide.ui.editors.template.scanner.AcceleoWhitespaceDetector;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.WhitespaceRule;

public class AcceleoMacroScanner
extends AbstractAcceleoScanner {
    public AcceleoMacroScanner(IEclipsePreferences[] lookupOrder) {
        super(lookupOrder);
    }

    protected void createRules() {
        ArrayList<SequenceBlockRule> rules = new ArrayList<SequenceBlockRule>();
        AcceleoToken literalToken = this.createToken(AcceleoColor.LITERAL);
        rules.add(new SequenceBlockRule((ISequenceRule)new KeywordRule("'"), (ISequenceRule)new KeywordRule("'"), new KeywordRule("\\'"), (IToken)literalToken));
        rules.add((SequenceBlockRule)new WhitespaceRule((IWhitespaceDetector)new AcceleoWhitespaceDetector()));
        rules.add((SequenceBlockRule)this.computeDelimiterRule("["));
        rules.add((SequenceBlockRule)this.computeDelimiterRule("]"));
        rules.add((SequenceBlockRule)this.computeKeywordRule("macro"));
        this.setRules(rules.toArray(new IRule[rules.size()]));
        this.setDefaultReturnToken((IToken)this.createToken(AcceleoColor.MACRO));
    }

    private IRule computeKeywordRule(String keyword) {
        return new KeywordRule(keyword, true, false, (IToken)this.createToken(AcceleoColor.MACRO, null, 1));
    }

    private IRule computeDelimiterRule(String delimiter) {
        return new KeywordRule(delimiter, false, false, (IToken)this.createToken(AcceleoColor.MACRO, null, 1));
    }

    public String getConfiguredContentType() {
        return "__ACCELEO_macro";
    }
}

