/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.editors.template.actions.refactor.pullup;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.eclipse.acceleo.internal.ide.ui.AcceleoUIMessages;
import org.eclipse.acceleo.internal.ide.ui.editors.template.actions.refactor.AcceleoRefactoringUtils;
import org.eclipse.acceleo.internal.parser.cst.utils.FileContent;
import org.eclipse.acceleo.model.mtl.Module;
import org.eclipse.acceleo.model.mtl.Template;
import org.eclipse.acceleo.model.mtl.TypedModel;
import org.eclipse.acceleo.parser.cst.VisibilityKind;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.ocl.ecore.Variable;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AcceleoPullUpRefactoring
extends Refactoring {
    private Module module;
    private List<Template> templates;
    private String refactoringName;
    private String fileName;
    private IContainer container;
    private IFile file;
    private boolean pullUpInNewFile;

    public AcceleoPullUpRefactoring() {
    }

    public AcceleoPullUpRefactoring(Module m, String name, IFile iFile) {
        this.module = m;
        this.refactoringName = name;
        this.file = iFile;
    }

    public String getName() {
        return this.refactoringName;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        if (this.module != null) {
            EList eContents = this.module.eContents();
            for (EObject eObject : eContents) {
                if (!(eObject instanceof Template) || ((Template)eObject).getOverrides().size() != 0) continue;
                return RefactoringStatus.create((IStatus)Status.OK_STATUS);
            }
        }
        return RefactoringStatus.createFatalErrorStatus((String)AcceleoUIMessages.getString("AcceleoEditorPullUpRefactoring.NoTemplateToPullUp"));
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        IResource resource;
        RefactoringStatus result = RefactoringStatus.createFatalErrorStatus((String)AcceleoUIMessages.getString("AcceleoEditorPullUpRefactoring.InvalidRefactoringParameters"));
        if (this.module != null && this.templates.size() > 0 && this.fileName != null && this.container != null && this.container.getProject().hasNature("org.eclipse.acceleo.ide.ui.acceleoNature")) {
            result = RefactoringStatus.create((IStatus)Status.OK_STATUS);
        }
        if ((resource = this.container.findMember(this.fileName)) instanceof IFile && resource.exists()) {
            IFile moduleFile = (IFile)resource;
            Module moduleFromFile = AcceleoRefactoringUtils.getModuleFromFile(moduleFile);
            for (Template template : this.templates) {
                EList contents = moduleFromFile.eContents();
                for (EObject eObject : contents) {
                    Template temp;
                    if (!(eObject instanceof Template) || !VisibilityKind.PUBLIC.getName().equals(template.getVisibility().getName()) || !this.templateEquals(template, temp = (Template)eObject)) continue;
                    result = RefactoringStatus.createFatalErrorStatus((String)AcceleoUIMessages.getString("AcceleoEditorPullUpRefactoring.OutputModuleHasSimilarTemplates"));
                }
            }
            moduleFromFile.eResource().unload();
        }
        return result;
    }

    private boolean templateEquals(Template template, Template temp) {
        boolean result = false;
        if (template.getName().equals(temp.getName())) {
            EList parameterList1 = template.getParameter();
            EList parameterList2 = temp.getParameter();
            if (parameterList1.size() == parameterList2.size()) {
                int i = 0;
                while (i < parameterList1.size()) {
                    Variable variable1 = (Variable)parameterList1.get(i);
                    Variable variable2 = (Variable)parameterList2.get(i);
                    if (variable1.eClass().getName().equals(variable2.eClass().getName())) {
                        result = true;
                    }
                    ++i;
                }
            }
        }
        return result;
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        CompositeChange result = new CompositeChange(this.refactoringName);
        IResource resource = this.container.findMember(this.fileName);
        if (resource == null) {
            this.pullUpInNewFile = true;
        }
        IFile mtlFile = null;
        mtlFile = !this.pullUpInNewFile && resource instanceof IFile && "mtl".equals(((IFile)resource).getFileExtension()) ? (IFile)resource : this.container.getFile((IPath)new Path(this.fileName));
        if (!mtlFile.exists()) {
            ByteArrayInputStream inputStream = new ByteArrayInputStream("".getBytes());
            mtlFile.create((InputStream)inputStream, true, pm);
            TextFileChange newModuleChange = this.createChangeInNewModule(mtlFile);
            result.add((Change)newModuleChange);
        } else {
            TextFileChange pulledUpTemplateChange = this.createChangeByAddingTemplates(mtlFile);
            result.add((Change)pulledUpTemplateChange);
        }
        for (Template template : this.templates) {
            TextFileChange changeOverrides = this.createChangeOverridesTemplate(template);
            result.add((Change)changeOverrides);
        }
        Module moduleFromFile = AcceleoRefactoringUtils.getModuleFromFile(mtlFile);
        boolean alreadyExtends = false;
        EList extendslist = this.module.getExtends();
        for (Module extendedModule : extendslist) {
            if (!extendedModule.getNsURI().equals(moduleFromFile.getNsURI())) continue;
            alreadyExtends = true;
            break;
        }
        if (!alreadyExtends) {
            TextFileChange changeExtendsModule = this.createChangeExtendsModule(mtlFile);
            result.add((Change)changeExtendsModule);
        }
        moduleFromFile.eResource().unload();
        this.module.eResource().unload();
        return result;
    }

    private TextFileChange createChangeOverridesTemplate(Template template) {
        TextFileChange tfc = new TextFileChange(this.refactoringName, this.file);
        MultiTextEdit edit = new MultiTextEdit();
        tfc.setTextType("mtl");
        tfc.setEdit((TextEdit)edit);
        StringBuffer content = FileContent.getFileContent((File)this.file.getLocation().toFile());
        int offset = content.indexOf("]", template.getStartPosition());
        int length = 0;
        edit.addChild((TextEdit)new ReplaceEdit(offset, length, " overrides " + template.getName()));
        return tfc;
    }

    private TextFileChange createChangeExtendsModule(IFile mtlFile) {
        int startHeaderPosition = this.module.getStartHeaderPosition();
        StringBuffer fileContent = FileContent.getFileContent((File)this.file.getLocation().toFile());
        int endHeaderPosition = fileContent.indexOf("/]", startHeaderPosition);
        int endInputPosition = fileContent.indexOf(")", startHeaderPosition);
        TextFileChange tfc = new TextFileChange(this.refactoringName, this.file);
        MultiTextEdit edit = new MultiTextEdit();
        tfc.setTextType("mtl");
        tfc.setEdit((TextEdit)edit);
        if (this.module.getExtends().size() == 0 && endInputPosition < endHeaderPosition) {
            int length = 0;
            edit.addChild((TextEdit)new ReplaceEdit(endInputPosition + 1, length, " extends " + this.fileName.substring(0, this.fileName.length() - "emtl".length())));
        } else {
            int length = 0;
            edit.addChild((TextEdit)new ReplaceEdit(endHeaderPosition, length, ", " + this.fileName.substring(0, this.fileName.length() - "emtl".length())));
        }
        return tfc;
    }

    private TextFileChange createChangeByAddingTemplates(IFile mtlFile) {
        TextFileChange tfc = new TextFileChange(this.refactoringName, mtlFile);
        MultiTextEdit edit = new MultiTextEdit();
        tfc.setTextType("mtl");
        tfc.setEdit((TextEdit)edit);
        StringBuffer outputFileContent = FileContent.getFileContent((File)mtlFile.getLocation().toFile());
        StringBuffer inputFileContent = FileContent.getFileContent((File)this.file.getLocation().toFile());
        int offset = outputFileContent.length();
        int length = 0;
        StringBuffer templatesText = new StringBuffer();
        int start = 0;
        int end = 0;
        for (Template template : this.templates) {
            start = template.getStartPosition();
            end = template.getEndPosition();
            templatesText.append(String.valueOf(inputFileContent.toString().substring(start, end)) + '\n');
        }
        edit.addChild((TextEdit)new ReplaceEdit(offset, length, templatesText.toString()));
        return tfc;
    }

    private TextFileChange createChangeInNewModule(IFile mtlFile) {
        TextFileChange tfc = new TextFileChange(this.refactoringName, mtlFile);
        MultiTextEdit edit = new MultiTextEdit();
        tfc.setTextType("mtl");
        tfc.setEdit((TextEdit)edit);
        int offset = 0;
        int length = FileContent.getFileContent((File)mtlFile.getLocation().toFile()).length();
        StringBuffer moduleModels = new StringBuffer();
        int i = 0;
        while (i < this.module.getInput().size()) {
            if (i < this.module.getInput().size() && this.module.getInput().size() > 1) {
                moduleModels.append("'" + ((EPackage)((TypedModel)this.module.getInput().get(i)).getTakesTypesFrom().get(0)).getNsURI() + "'" + ",");
            } else {
                moduleModels.append("'" + ((EPackage)((TypedModel)this.module.getInput().get(i)).getTakesTypesFrom().get(0)).getNsURI() + "'");
            }
            ++i;
        }
        StringBuffer newModuleContent = new StringBuffer();
        StringBuffer fileContent = FileContent.getFileContent((File)this.file.getLocation().toFile());
        newModuleContent.append(fileContent.substring(0, this.module.getStartHeaderPosition()));
        newModuleContent.append("[module " + this.fileName + "(" + moduleModels.toString() + ")" + "/" + "]");
        newModuleContent.append('\n');
        StringBuffer templatesText = new StringBuffer();
        int start = 0;
        int end = 0;
        for (Template template : this.templates) {
            start = template.getStartPosition();
            end = template.getEndPosition();
            templatesText.append(String.valueOf(fileContent.toString().substring(start, end)) + '\n');
        }
        edit.addChild((TextEdit)new ReplaceEdit(offset, length, String.valueOf(newModuleContent.toString()) + templatesText.toString()));
        return tfc;
    }

    public Module getModule() {
        return this.module;
    }

    public void setTemplates(List<Template> selectedTemplate) {
        this.templates = selectedTemplate;
    }

    public void setContainer(IContainer element) {
        this.container = element;
    }

    public void setFileName(String name) {
        this.fileName = name;
    }

    public IContainer getContainer() {
        return this.container;
    }

    public String getFileName() {
        return this.fileName;
    }

    public RefactoringStatus initialize(Map<String, String> fArguments) {
        return null;
    }

    public boolean isPullUpInNewFile() {
        return this.pullUpInNewFile;
    }
}

