/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.setup;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import junit.framework.Assert;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.gmf.tests.Plugin;
import org.eclipse.jdt.core.JavaCore;

public class RuntimeWorkspaceSetup {
    private final boolean isDevBinPresent;
    private static RuntimeWorkspaceSetup instance;

    public static RuntimeWorkspaceSetup get() {
        if (instance == null) {
            instance = new RuntimeWorkspaceSetup();
            instance.init();
        }
        return instance;
    }

    public RuntimeWorkspaceSetup() {
        String osgiDevProp;
        List<String> l = Arrays.asList(Platform.getCommandLineArgs());
        int i = l.indexOf("-dev");
        this.isDevBinPresent = i != -1 ? i + 1 < l.size() && l.get(i + 1).startsWith("bin") : (osgiDevProp = Plugin.getBundleContext().getProperty("osgi.dev")) != null && osgiDevProp.contains("bin");
    }

    private void init() {
        RuntimeWorkspaceSetup.ensureJava14();
        try {
            IWorkspaceDescription wd = ResourcesPlugin.getWorkspace().getDescription();
            RuntimeWorkspaceSetup.turnWorkspaceHistoryOff(wd);
            RuntimeWorkspaceSetup.switchAutobuildOff(wd);
            ResourcesPlugin.getWorkspace().setDescription(wd);
        }
        catch (CoreException ex) {
            Assert.fail((String)ex.getMessage());
        }
    }

    public void getReadyToStartAsBundle(IProject project) {
        if (this.isDevBinPresent) {
            return;
        }
        try {
            IFile manifest = project.getFile("META-INF/MANIFEST.MF");
            if (manifest.exists()) {
                String line;
                BufferedReader r = new BufferedReader(new InputStreamReader(manifest.getContents(), manifest.getCharset()));
                boolean found = false;
                StringBuilder result = new StringBuilder();
                while ((line = r.readLine()) != null) {
                    result.append(line);
                    if (!found && line.startsWith("Bundle-ClassPath:")) {
                        if (line.indexOf("bin/") == -1) {
                            result.append(", bin/");
                        }
                        found = true;
                    }
                    result.append("\n");
                }
                if (!found) {
                    result.insert(0, "Bundle-ClassPath: bin/, .\n");
                }
                manifest.setContents((InputStream)new ByteArrayInputStream(result.toString().getBytes(manifest.getCharset())), true, false, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.fail((String)("Can't get project " + project.getName() + " ready to be started as bundle:" + ex));
        }
    }

    private static void ensureJava14() {
        if (!"1.4".equals(JavaCore.getOption((String)"org.eclipse.jdt.core.compiler.source"))) {
            Hashtable options = JavaCore.getOptions();
            options.put("org.eclipse.jdt.core.compiler.compliance", "1.4");
            options.put("org.eclipse.jdt.core.compiler.source", "1.4");
            options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.4");
            JavaCore.setOptions((Hashtable)options);
        }
    }

    private static void turnWorkspaceHistoryOff(IWorkspaceDescription wd) {
        wd.setFileStateLongevity(0L);
        wd.setMaxFileStates(0);
        wd.setMaxFileStateSize(0L);
        wd.setSnapshotInterval(3600000L);
    }

    private static void switchAutobuildOff(IWorkspaceDescription wd) {
        wd.setAutoBuilding(false);
    }
}

