/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.geoshapes.internal.editparts;

import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.ViewComponentEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.internal.editpolicies.NonSemanticEditPolicy;
import org.eclipse.gmf.runtime.draw2d.ui.figures.PolylineConnectionEx;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;

public class LineEditPart
extends ConnectionNodeEditPart {
    public LineEditPart(View view) {
        super(view);
    }

    protected Connection createConnectionFigure() {
        PolylineConnectionEx conn = new PolylineConnectionEx();
        return conn;
    }

    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.removeEditPolicy("SemanticPolicy");
        this.installEditPolicy("SemanticPolicy", (EditPolicy)new NonSemanticEditPolicy());
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new ViewComponentEditPolicy());
    }

    protected void handleNotificationEvent(Notification notification) {
        Object feature = notification.getFeature();
        if (NotationPackage.Literals.LINE_STYLE__LINE_WIDTH.equals(feature)) {
            this.refreshLineWidth();
            this.refreshArrowSource();
            this.refreshArrowTarget();
        } else if (NotationPackage.Literals.LINE_TYPE_STYLE__LINE_TYPE.equals(feature)) {
            this.refreshLineType();
        } else if (NotationPackage.Literals.ARROW_STYLE__ARROW_SOURCE.equals(feature)) {
            this.refreshArrowSource();
        } else if (NotationPackage.Literals.ARROW_STYLE__ARROW_TARGET.equals(feature)) {
            this.refreshArrowTarget();
        } else {
            super.handleNotificationEvent(notification);
        }
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        this.refreshLineWidth();
        this.refreshLineType();
        this.refreshArrowSource();
        this.refreshArrowTarget();
    }

    protected void setLineWidth(int width) {
        PolylineConnectionEx conn = (PolylineConnectionEx)this.getFigure();
        conn.setLineWidth(this.getMapMode().DPtoLP(width));
    }

    protected void setLineType(int lineType) {
        PolylineConnectionEx conn = (PolylineConnectionEx)this.getFigure();
        conn.setLineStyle(lineType);
    }

    protected void setArrowSource(RotatableDecoration arrowDecoration) {
        PolylineConnectionEx conn = (PolylineConnectionEx)this.getFigure();
        conn.setSourceDecoration(arrowDecoration);
    }

    protected void setArrowTarget(RotatableDecoration arrowDecoration) {
        PolylineConnectionEx conn = (PolylineConnectionEx)this.getFigure();
        conn.setTargetDecoration(arrowDecoration);
    }
}

