/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.codegen.dispatch;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.gmf.internal.codegen.dispatch.TemplateRegistry;

public class StaticTemplateRegistry
implements TemplateRegistry {
    private final Map<Object, String> pathMap = new HashMap<Object, String>();
    private final Map<Object, Class> classMap = new HashMap<Object, Class>();
    private final Map<Object, ClassLoader> classLoaderMap = new HashMap<Object, ClassLoader>();
    private final ClassLoader myDefaultClassLoader;

    public StaticTemplateRegistry(ClassLoader defaultClassLoader) {
        assert (defaultClassLoader != null);
        this.myDefaultClassLoader = defaultClassLoader;
    }

    public void put(Object key, String templatePath, Class generatorClass) {
        this.put(key, templatePath, generatorClass, null);
    }

    public void put(Object key, String templatePath, Class generatorClass, ClassLoader templateClassLoader) {
        assert (key != null && templatePath != null);
        this.pathMap.put(key, templatePath);
        if (generatorClass != null) {
            this.classMap.put(key, generatorClass);
        }
        if (templateClassLoader != null) {
            this.classLoaderMap.put(key, templateClassLoader);
        }
    }

    public String getTemplatePath(Object key) {
        return this.pathMap.get(key);
    }

    public ClassLoader getTemplateClassLoader(Object key) {
        if (this.classLoaderMap.containsKey(key)) {
            return this.classLoaderMap.get(key);
        }
        return this.myDefaultClassLoader;
    }

    public boolean hasGeneratorClass(Object key) {
        return this.classMap.containsKey(key);
    }

    public Class getGeneratorClass(Object key) {
        return this.classMap.get(key);
    }

    public void clean() {
        this.pathMap.clear();
        this.classMap.clear();
        this.classLoaderMap.clear();
    }
}

