/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.common.ui.internal.resources;

import java.net.URI;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.gmf.runtime.common.ui.internal.resources.FileObserverFilterType;

public class FileObserverFilter {
    private FileObserverFilterType filterType;
    private Object filter;

    public FileObserverFilter(FileObserverFilterType aFilterType) {
        assert (aFilterType == FileObserverFilterType.ALL);
        this.setFilterType(aFilterType);
        this.setFilter(null);
    }

    public FileObserverFilter(FileObserverFilterType aFilterType, String[] extension) {
        assert (aFilterType == FileObserverFilterType.EXTENSION);
        this.setFilterType(aFilterType);
        this.setFilter(extension);
    }

    public FileObserverFilter(FileObserverFilterType aFilterType, IContentType[] contentType) {
        assert (aFilterType == FileObserverFilterType.CONTENT_TYPE);
        this.setFilterType(aFilterType);
        this.setFilter(contentType);
    }

    public FileObserverFilter(FileObserverFilterType aFilterType, IFolder folder) {
        assert (aFilterType == FileObserverFilterType.FOLDER);
        this.setFilterType(aFilterType);
        this.setFilter(folder);
    }

    public FileObserverFilter(FileObserverFilterType aFilterType, IFile file) {
        assert (aFilterType == FileObserverFilterType.FILE);
        this.setFilterType(aFilterType);
        this.setFilter(file);
    }

    public boolean matches(IResource resource) {
        String fileExtension;
        if (this.getFilterType() == FileObserverFilterType.ALL) {
            return true;
        }
        if (this.getFilterType() == FileObserverFilterType.FILE && resource instanceof IFile && this.getAbsolutePath((IResource)this.getFileFilter()).equals(this.getAbsolutePath(resource))) {
            return true;
        }
        if (this.getFilterType() == FileObserverFilterType.FOLDER && resource instanceof IFile && this.getAbsolutePath(resource).startsWith(this.getAbsolutePath((IResource)this.getFolderFilter()))) {
            return true;
        }
        if (this.getFilterType() == FileObserverFilterType.CONTENT_TYPE && resource instanceof IFile && this.matchesContentType(((IFile)resource).getName())) {
            return true;
        }
        return this.getFilterType() == FileObserverFilterType.EXTENSION && resource instanceof IFile && this.matchesExtension(fileExtension = resource.getFullPath().getFileExtension());
    }

    public boolean matches(IPath path) {
        if (this.getFilterType() == FileObserverFilterType.ALL) {
            return true;
        }
        if (this.getFilterType() == FileObserverFilterType.FILE && this.getFileFilter().getFullPath().equals((Object)path)) {
            return true;
        }
        if (this.getFilterType() == FileObserverFilterType.FOLDER && path.isPrefixOf(this.getFolderFilter().getFullPath())) {
            return true;
        }
        if (this.getFilterType() == FileObserverFilterType.CONTENT_TYPE && this.matchesContentType(path.segment(path.segmentCount() - 1))) {
            return true;
        }
        return this.getFilterType() == FileObserverFilterType.EXTENSION && this.matchesExtension(path.getFileExtension());
    }

    private boolean matchesContentType(String fileName) {
        IContentType[] contentTypes = this.getContentTypeFilter();
        int i = 0;
        while (i < contentTypes.length) {
            if (contentTypes[i].isAssociatedWith(fileName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean matchesExtension(String extension) {
        String[] extensions = this.getExtensionFilter();
        int i = 0;
        while (i < extensions.length) {
            if (extensions[i].equals(extension)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private IFile getFileFilter() {
        assert (this.filterType == FileObserverFilterType.FILE);
        return (IFile)this.filter;
    }

    private IFolder getFolderFilter() {
        assert (this.filterType == FileObserverFilterType.FOLDER);
        return (IFolder)this.filter;
    }

    private String[] getExtensionFilter() {
        assert (this.filterType == FileObserverFilterType.EXTENSION);
        return (String[])this.filter;
    }

    private IContentType[] getContentTypeFilter() {
        assert (this.filterType == FileObserverFilterType.CONTENT_TYPE);
        return (IContentType[])this.filter;
    }

    private FileObserverFilterType getFilterType() {
        return this.filterType;
    }

    private void setFilter(Object object) {
        this.filter = object;
    }

    private void setFilterType(FileObserverFilterType type) {
        this.filterType = type;
    }

    private String getAbsolutePath(IResource resource) {
        URI locationURI = resource.getLocationURI();
        if (locationURI == null) {
            return resource.getFullPath().toString();
        }
        return locationURI.toString();
    }
}

