/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.batik.svggen.SVGGraphics2DIOException;
import org.apache.batik.svggen.SVGGraphics2DRuntimeException;
import org.apache.batik.util.SVGConstants;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

class XmlWriter
implements SVGConstants {
    private static String EOL;
    private static final String TAG_END = " />";
    private static final String TAG_START = "</";
    private static final String SPACE = " ";
    private static final char[] SPACES;
    private static final int SPACES_LEN;

    XmlWriter() {
    }

    private static void writeXml(Attr attr, IndentWriter indentWriter) throws IOException {
        String string = attr.getName();
        indentWriter.write(string);
        indentWriter.write("=\"");
        XmlWriter.writeChildrenXml(attr, indentWriter);
        indentWriter.write(34);
    }

    private static void writeChildrenXml(Attr attr, IndentWriter indentWriter) throws IOException {
        char[] cArray = attr.getValue().toCharArray();
        if (cArray == null) {
            return;
        }
        int n = cArray.length;
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            char c = cArray[n3];
            switch (c) {
                case '<': {
                    indentWriter.write(cArray, n2, n3 - n2);
                    n2 = n3 + 1;
                    indentWriter.write("&lt;");
                    break;
                }
                case '>': {
                    indentWriter.write(cArray, n2, n3 - n2);
                    n2 = n3 + 1;
                    indentWriter.write("&gt;");
                    break;
                }
                case '&': {
                    indentWriter.write(cArray, n2, n3 - n2);
                    n2 = n3 + 1;
                    indentWriter.write("&amp;");
                    break;
                }
                case '\'': {
                    indentWriter.write(cArray, n2, n3 - n2);
                    n2 = n3 + 1;
                    indentWriter.write("&apos;");
                    break;
                }
                case '\"': {
                    indentWriter.write(cArray, n2, n3 - n2);
                    n2 = n3 + 1;
                    indentWriter.write("&quot;");
                    break;
                }
            }
            ++n3;
        }
        indentWriter.write(cArray, n2, n3 - n2);
    }

    private static void writeXml(Comment comment, IndentWriter indentWriter) throws IOException {
        char[] cArray = comment.getData().toCharArray();
        if (cArray == null) {
            indentWriter.write("<!---->");
            return;
        }
        indentWriter.write("<!--");
        boolean bl = false;
        int n = cArray.length;
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            char c = cArray[n3];
            if (c == '-') {
                if (bl) {
                    indentWriter.write(cArray, n2, n3 - n2);
                    n2 = n3;
                    indentWriter.write(32);
                }
                bl = true;
            } else {
                bl = false;
            }
            ++n3;
        }
        indentWriter.write(cArray, n2, n3 - n2);
        if (bl) {
            indentWriter.write(32);
        }
        indentWriter.write("-->");
    }

    private static void writeXml(Text text, IndentWriter indentWriter) throws IOException {
        XmlWriter.writeXml(text, indentWriter, false);
    }

    /*
     * Unable to fully structure code
     */
    private static void writeXml(Text var0, IndentWriter var1_1, boolean var2_2) throws IOException {
        var3_3 = var0.getData().toCharArray();
        if (var3_3 == null) {
            System.err.println("Null text data??");
            return;
        }
        var4_4 = var3_3.length;
        var5_5 = 0;
        var6_6 = 0;
        if (var2_2) {
            block12: while (var6_6 < var4_4) {
                var7_7 = var3_3[var6_6];
                switch (var7_7) {
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': {
                        ++var6_6;
                        break;
                    }
                    default: {
                        break block12;
                    }
                }
            }
            var5_5 = var6_6;
        }
        block13: while (var6_6 < var4_4) {
            var7_7 = var3_3[var6_6];
            switch (var7_7) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    if (var2_2) {
                        var8_8 = var6_6++;
                        block14: while (var6_6 < var4_4) {
                            switch (var3_3[var6_6]) {
                                case '\t': 
                                case '\n': 
                                case '\r': 
                                case ' ': {
                                    ++var6_6;
                                    break;
                                }
                                default: {
                                    break block14;
                                }
                            }
                        }
                        if (var6_6 != var4_4) continue block13;
                        var1_1.write(var3_3, var5_5, var8_8 - var5_5);
                        return;
                    }
                    ** GOTO lbl51
                }
                case '<': {
                    var1_1.write(var3_3, var5_5, var6_6 - var5_5);
                    var5_5 = var6_6 + 1;
                    var1_1.write("&lt;");
                    ** GOTO lbl51
                }
                case '>': {
                    var1_1.write(var3_3, var5_5, var6_6 - var5_5);
                    var5_5 = var6_6 + 1;
                    var1_1.write("&gt;");
                    ** GOTO lbl51
                }
                case '&': {
                    var1_1.write(var3_3, var5_5, var6_6 - var5_5);
                    var5_5 = var6_6 + 1;
                    var1_1.write("&amp;");
                }
lbl51:
                // 5 sources

                default: {
                    ++var6_6;
                }
            }
        }
        var1_1.write(var3_3, var5_5, var6_6 - var5_5);
    }

    private static void writeXml(CDATASection cDATASection, IndentWriter indentWriter) throws IOException {
        char[] cArray = cDATASection.getData().toCharArray();
        if (cArray == null) {
            indentWriter.write("<![CDATA[]]>");
            return;
        }
        indentWriter.write("<![CDATA[");
        int n = cArray.length;
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            char c = cArray[n3];
            if (c == ']' && n3 + 2 < cArray.length && cArray[n3 + 1] == ']' && cArray[n3 + 2] == '>') {
                indentWriter.write(cArray, n2, n3 - n2);
                n2 = n3 + 1;
                indentWriter.write("]]]]><![CDATA[>");
                continue;
            }
            ++n3;
        }
        indentWriter.write(cArray, n2, n3 - n2);
        indentWriter.write("]]>");
    }

    private static void writeXml(Element element, IndentWriter indentWriter) throws IOException, SVGGraphics2DIOException {
        indentWriter.write(TAG_START, 0, 1);
        indentWriter.write(element.getTagName());
        NamedNodeMap namedNodeMap = element.getAttributes();
        if (namedNodeMap != null) {
            int n = namedNodeMap.getLength();
            int n2 = 0;
            while (n2 < n) {
                Attr attr = (Attr)namedNodeMap.item(n2);
                indentWriter.write(32);
                XmlWriter.writeXml(attr, indentWriter);
                ++n2;
            }
        }
        if (!element.hasChildNodes()) {
            indentWriter.write(TAG_END, 0, 3);
        } else {
            indentWriter.write(TAG_END, 2, 1);
            XmlWriter.writeChildrenXml(element, indentWriter);
            indentWriter.write(TAG_START, 0, 2);
            indentWriter.write(element.getTagName());
            indentWriter.write(TAG_END, 2, 1);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void writeChildrenXml(Element element, IndentWriter indentWriter) throws IOException, SVGGraphics2DIOException {
        NodeList nodeList = element.getChildNodes();
        if (nodeList == null) {
            return;
        }
        int n = nodeList.getLength();
        int n2 = 0;
        n2 = indentWriter.getIndentLevel();
        try {
            indentWriter.setIndentLevel(n2 + 2);
            int n3 = 0;
            while (n3 < n) {
                if (nodeList.item(n3).getNodeType() != 3) {
                    indentWriter.printIndent();
                }
                XmlWriter.writeXml(nodeList.item(n3), (Writer)indentWriter);
                ++n3;
            }
            Object var7_6 = null;
            indentWriter.setIndentLevel(n2);
            if (n <= 0 || nodeList.item(n - 1).getNodeType() == 3) return;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            indentWriter.setIndentLevel(n2);
            if (n <= 0 || nodeList.item(n - 1).getNodeType() == 3) throw throwable;
            indentWriter.printIndent();
            throw throwable;
        }
        indentWriter.printIndent();
    }

    private static void writeDocumentHeader(IndentWriter indentWriter) throws IOException {
        String string = null;
        if (indentWriter.getProxied() instanceof OutputStreamWriter) {
            string = XmlWriter.java2std(((OutputStreamWriter)indentWriter.getProxied()).getEncoding());
        }
        indentWriter.write("<?xml version=\"1.0\"");
        if (string != null) {
            indentWriter.write(" encoding=\"");
            indentWriter.write(string);
            indentWriter.write(34);
        }
        indentWriter.write("?>");
        indentWriter.write(EOL);
        indentWriter.write(EOL);
        indentWriter.write("<!DOCTYPE svg PUBLIC '");
        indentWriter.write("-//W3C//DTD SVG 1.0//EN");
        indentWriter.write("' '");
        indentWriter.write("http://www.w3.org/TR/2001/REC-SVG-20010904/DTD/svg10.dtd");
        indentWriter.write("'");
        indentWriter.write(">");
        indentWriter.write(EOL);
    }

    private static void writeXml(Document document, IndentWriter indentWriter) throws IOException, SVGGraphics2DIOException {
        XmlWriter.writeDocumentHeader(indentWriter);
        NodeList nodeList = document.getChildNodes();
        XmlWriter.writeXml(nodeList, indentWriter);
    }

    private static void writeXml(NodeList nodeList, IndentWriter indentWriter) throws IOException, SVGGraphics2DIOException {
        int n = nodeList.getLength();
        if (n == 0) {
            return;
        }
        int n2 = 0;
        while (n2 < n) {
            Node node = nodeList.item(n2);
            XmlWriter.writeXml(node, (Writer)indentWriter);
            indentWriter.write(EOL);
            ++n2;
        }
    }

    static String java2std(String string) {
        if (string == null) {
            return null;
        }
        if (string.startsWith("ISO8859_")) {
            return "ISO-8859-" + string.substring(8);
        }
        if (string.startsWith("8859_")) {
            return "ISO-8859-" + string.substring(5);
        }
        if ("ASCII7".equalsIgnoreCase(string) || "ASCII".equalsIgnoreCase(string)) {
            return "US-ASCII";
        }
        if ("UTF8".equalsIgnoreCase(string)) {
            return "UTF-8";
        }
        if (string.startsWith("Unicode")) {
            return "UTF-16";
        }
        if ("SJIS".equalsIgnoreCase(string)) {
            return "Shift_JIS";
        }
        if ("JIS".equalsIgnoreCase(string)) {
            return "ISO-2022-JP";
        }
        if ("EUCJIS".equalsIgnoreCase(string)) {
            return "EUC-JP";
        }
        return string;
    }

    public static void writeXml(Node node, Writer writer) throws SVGGraphics2DIOException {
        try {
            IndentWriter indentWriter = null;
            indentWriter = writer instanceof IndentWriter ? (IndentWriter)writer : new IndentWriter(writer);
            switch (node.getNodeType()) {
                case 2: {
                    XmlWriter.writeXml((Attr)node, indentWriter);
                    break;
                }
                case 8: {
                    XmlWriter.writeXml((Comment)node, indentWriter);
                    break;
                }
                case 3: {
                    XmlWriter.writeXml((Text)node, indentWriter);
                    break;
                }
                case 4: {
                    XmlWriter.writeXml((CDATASection)node, indentWriter);
                    break;
                }
                case 9: {
                    XmlWriter.writeXml((Document)node, indentWriter);
                    break;
                }
                case 11: {
                    XmlWriter.writeDocumentHeader(indentWriter);
                    NodeList nodeList = node.getChildNodes();
                    XmlWriter.writeXml(nodeList, indentWriter);
                    break;
                }
                case 1: {
                    XmlWriter.writeXml((Element)node, indentWriter);
                    break;
                }
                default: {
                    throw new SVGGraphics2DRuntimeException("Unable to write node of type " + node.getClass().getName());
                }
            }
        }
        catch (IOException iOException) {
            throw new SVGGraphics2DIOException(iOException);
        }
    }

    static {
        String string;
        SPACES = new char[]{' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' '};
        SPACES_LEN = SPACES.length;
        try {
            string = System.getProperty("line.separator", "\n");
        }
        catch (SecurityException securityException) {
            string = "\n";
        }
        EOL = string;
    }

    static class IndentWriter
    extends Writer {
        protected Writer proxied;
        protected int indentLevel;
        protected int column;

        public IndentWriter(Writer writer) {
            if (writer == null) {
                throw new SVGGraphics2DRuntimeException("proxy should not be null");
            }
            this.proxied = writer;
        }

        public void setIndentLevel(int n) {
            this.indentLevel = n;
        }

        public int getIndentLevel() {
            return this.indentLevel;
        }

        public void printIndent() throws IOException {
            this.proxied.write(EOL);
            for (int i = this.indentLevel; i > 0; i -= SPACES_LEN) {
                if (i > SPACES_LEN) {
                    this.proxied.write(SPACES, 0, SPACES_LEN);
                    continue;
                }
                this.proxied.write(SPACES, 0, i);
                break;
            }
            this.column = this.indentLevel;
        }

        public Writer getProxied() {
            return this.proxied;
        }

        public int getColumn() {
            return this.column;
        }

        public void write(int n) throws IOException {
            ++this.column;
            this.proxied.write(n);
        }

        public void write(char[] cArray) throws IOException {
            this.column += cArray.length;
            this.proxied.write(cArray);
        }

        public void write(char[] cArray, int n, int n2) throws IOException {
            this.column += n2;
            this.proxied.write(cArray, n, n2);
        }

        public void write(String string) throws IOException {
            this.column += string.length();
            this.proxied.write(string);
        }

        public void write(String string, int n, int n2) throws IOException {
            this.column += n2;
            this.proxied.write(string, n, n2);
        }

        public void flush() throws IOException {
            this.proxied.flush();
        }

        public void close() throws IOException {
            this.column = -1;
            this.proxied.close();
        }
    }
}

