/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.xpand.codeassist;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.gmf.internal.xpand.codeassist.FastAnalyzer;
import org.eclipse.gmf.internal.xpand.codeassist.StackElement;
import org.eclipse.gmf.internal.xpand.expression.codeassist.ProposalComputer;
import org.eclipse.gmf.internal.xpand.expression.codeassist.ProposalFactory;
import org.eclipse.gmf.internal.xpand.model.ExecutionContext;
import org.eclipse.jface.text.contentassist.ICompletionProposal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatementProposalComputer
implements ProposalComputer {
    private final ProposalFactory proposalFactory;
    private static final Pattern WS_PATTERN = Pattern.compile("(\\n?[\\t ]*)\\z");

    public StatementProposalComputer(ProposalFactory factory) {
        assert (factory != null);
        this.proposalFactory = factory;
    }

    @Override
    public List<ICompletionProposal> computeProposals(String txt, ExecutionContext ctx) {
        ArrayList<ICompletionProposal> result = new ArrayList<ICompletionProposal>();
        String ws = this.findTrailingWhitespace(txt);
        Stack<StackElement> s = FastAnalyzer.computeStack(txt);
        if (s.size() > 0) {
            StackElement se = s.peek();
            result.add(this.proposalFactory.createStatementProposal("\u00abEND" + se.block + "\u00bb", "END" + se.block));
            if (this.contains("IF", s)) {
                result.add(this.proposalFactory.createStatementProposal("\u00abELSE\u00bb", "ELSE"));
                result.add(this.proposalFactory.createStatementProposal("\u00abELSEIF statement\u00bb", "ELSEIF"));
            }
            if (!this.contains("FILE", s)) {
                result.add(this.fileBlockProposal(ws));
            }
            if (!this.contains("PROTECT", s)) {
                result.add(this.protectBlockProposal(ws));
            }
            result.add(this.foreachBlockProposal(ws));
            result.add(this.ifBlockProposal(ws));
            result.add(this.letBlockProposal(ws));
            result.add(this.expandStatementProposal(ws));
        } else {
            if (txt.indexOf("\u00abDEFINE") == -1) {
                if (txt.indexOf("\u00abEXTENSION") == -1) {
                    result.add(this.importStatementProposal());
                }
                result.add(this.extensionStatementProposal());
            }
            result.add(this.defineBlockProposal(ws));
            result.add(this.aroundBlockProposal(ws));
        }
        return result;
    }

    private ICompletionProposal importStatementProposal() {
        return this.proposalFactory.createStatementProposal("\u00abIMPORT my::imported::namespace\u00bb", "IMPORT statement", "\u00abIMPORT my::imported::namespace\u00bb".indexOf("my::imported::namespace"), "my::imported::namespace".length());
    }

    private ICompletionProposal extensionStatementProposal() {
        return this.proposalFactory.createStatementProposal("\u00abEXTENSION path::to::Extension\u00bb", "EXTENSION statement", "\u00abEXTENSION path::to::Extension\u00bb".indexOf("path::to::Extension"), "path::to::Extension".length());
    }

    private String findTrailingWhitespace(String txt) {
        Matcher m = WS_PATTERN.matcher(txt);
        m.find();
        return m.group(1);
    }

    private ICompletionProposal expandStatementProposal(String ws) {
        return this.proposalFactory.createStatementProposal("\u00abEXPAND definition FOR self\u00bb", "EXPAND statement", "\u00abEXPAND definition FOR self\u00bb".indexOf("definition"), "definition".length());
    }

    private ICompletionProposal letBlockProposal(String ws) {
        String insertString = "\u00abLET expression AS e\u00bb" + ws + "\u00ab" + "ENDLET" + "\u00bb";
        return this.proposalFactory.createStatementProposal(insertString, "LET block", insertString.indexOf("expression"), "expression".length());
    }

    private ICompletionProposal ifBlockProposal(String ws) {
        String insertString = "\u00abIF condition\u00bb" + ws + "\u00ab" + "ENDIF" + "\u00bb";
        return this.proposalFactory.createStatementProposal(insertString, "IF block", insertString.indexOf("condition"), "condition".length());
    }

    private ICompletionProposal foreachBlockProposal(String ws) {
        String insertString = "\u00abFOREACH elements AS e\u00bb" + ws + "\u00ab" + "ENDFOREACH" + "\u00bb";
        return this.proposalFactory.createStatementProposal(insertString, "FOREACH block", insertString.indexOf("elements"), "elements".length());
    }

    private ICompletionProposal protectBlockProposal(String ws) {
        String insertString = "\u00abPROTECT CSTART '/*' CEND '*/' ID uniqueId ENABLED\u00bb" + ws + "\u00ab" + "ENDPROTECT" + "\u00bb";
        return this.proposalFactory.createStatementProposal(insertString, "PROTECT region", insertString.indexOf("uniqueId"), "uniqueId".length());
    }

    private ICompletionProposal fileBlockProposal(String ws) {
        String insertString = "\u00abFILE fileName\u00bb" + ws + "\u00ab" + "ENDFILE" + "\u00bb";
        return this.proposalFactory.createStatementProposal(insertString, "FILE block", insertString.indexOf("fileName"), "fileName".length());
    }

    private ICompletionProposal defineBlockProposal(String ws) {
        String insertString = "\u00abDEFINE definionName FOR Type\u00bb" + ws + "\u00ab" + "ENDDEFINE" + "\u00bb";
        return this.proposalFactory.createStatementProposal(insertString, "new DEFINE", insertString.indexOf("definionName"), "definionName".length());
    }

    private ICompletionProposal aroundBlockProposal(String ws) {
        String insertString = "\u00abAROUND fullyQualifiedDefinionName FOR Type\u00bb" + ws + "\u00ab" + "ENDAROUND" + "\u00bb";
        return this.proposalFactory.createStatementProposal(insertString, "new AROUND", insertString.indexOf("fullyQualifiedDefinionName"), "fullyQualifiedDefinionName".length());
    }

    private boolean contains(String blockName, Stack<StackElement> s) {
        for (StackElement element : s) {
            if (!element.block.equals(blockName)) continue;
            return true;
        }
        return false;
    }

    protected String findPrefix(String txt) {
        StringBuffer result = new StringBuffer();
        int i = txt.length() - 1;
        char c = txt.charAt(i);
        while (i > 0 && Character.isJavaIdentifierStart(c)) {
            result.append(c);
            c = txt.charAt(--i);
        }
        return result.reverse().toString();
    }
}

