/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.rt;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.codegen.ecore.genmodel.GenClass;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.validation.model.Category;
import org.eclipse.emf.validation.model.CategoryManager;
import org.eclipse.emf.validation.model.EvaluationMode;
import org.eclipse.emf.validation.model.IConstraintStatus;
import org.eclipse.emf.validation.model.IModelConstraint;
import org.eclipse.emf.validation.service.ConstraintRegistry;
import org.eclipse.emf.validation.service.IConstraintDescriptor;
import org.eclipse.emf.validation.service.IValidationListener;
import org.eclipse.emf.validation.service.ModelValidationService;
import org.eclipse.emf.validation.service.ValidationEvent;
import org.eclipse.gmf.codegen.gmfgen.GMFGenFactory;
import org.eclipse.gmf.codegen.gmfgen.GenCommonBase;
import org.eclipse.gmf.codegen.gmfgen.GenDiagram;
import org.eclipse.gmf.codegen.gmfgen.GenDomainElementTarget;
import org.eclipse.gmf.mappings.AuditContainer;
import org.eclipse.gmf.mappings.AuditRule;
import org.eclipse.gmf.mappings.AuditedMetricTarget;
import org.eclipse.gmf.mappings.DiagramElementTarget;
import org.eclipse.gmf.mappings.DomainAttributeTarget;
import org.eclipse.gmf.mappings.DomainElementTarget;
import org.eclipse.gmf.mappings.LinkMapping;
import org.eclipse.gmf.mappings.Mapping;
import org.eclipse.gmf.mappings.MappingEntry;
import org.eclipse.gmf.mappings.NodeMapping;
import org.eclipse.gmf.mappings.NotationElementTarget;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.tests.rt.GeneratedCanvasTest;
import org.eclipse.gmf.tests.setup.LinksSessionSetup;
import org.eclipse.gmf.tests.setup.MapDefSource;

public class AuditRulesTest
extends GeneratedCanvasTest {
    private AuditContainer audits;
    private AuditAssert auditAssert;
    private List<GenPackage> targetedPackages;

    public AuditRulesTest(String name) {
        super(name);
        this.myDefaultSetup = LinksSessionSetup.newInstance();
    }

    protected void setUp() throws Exception {
        super.setUp();
        MapDefSource mapSource = this.getSetup().getMapModel();
        AuditRulesTest.assertNotNull((String)"Requires MapDefSource in setup", (Object)mapSource);
        Mapping mapping = mapSource.getMapping();
        this.audits = mapping.getAudits();
        AuditRulesTest.assertNotNull((String)"Requires mapping with audit rules", (Object)this.audits);
        GenDiagram genDiagram = this.getSetup().getGenModel().getGenDiagram();
        this.targetedPackages = genDiagram.getEditorGen().getAudits().getTargetedModelPackages();
        this.auditAssert = new AuditAssert(genDiagram.getEditorGen().getPlugin().getID());
    }

    public void testNestedPackageAuditTarget() throws Exception {
        GenModel domainGenModel = this.getSetup().getGenModel().getGenDiagram().getDomainDiagramElement().getGenPackage().getGenModel();
        GenClass genClass = null;
        String qualifiedClassName = null;
        for (GenPackage nextPackage : domainGenModel.getAllGenPackagesWithClassifiers()) {
            if (nextPackage.getSuperGenPackage() == null) continue;
            AuditRulesTest.assertFalse((boolean)nextPackage.getGenClasses().isEmpty());
            genClass = (GenClass)nextPackage.getGenClasses().get(0);
            qualifiedClassName = String.valueOf(nextPackage.getSuperGenPackage().getPackageName()) + "." + nextPackage.getPackageName() + "." + genClass.getName();
        }
        AuditRulesTest.assertNotNull((String)"Test requires EClass in a nested package", genClass);
        GenDomainElementTarget domainElementTarget = GMFGenFactory.eINSTANCE.createGenDomainElementTarget();
        domainElementTarget.setElement(genClass);
        AuditRulesTest.assertEquals(qualifiedClassName, (String)domainElementTarget.getTargetClassModelQualifiedName());
    }

    public void testAuditConstraints() throws Exception {
        this.getSetup().getGeneratedPlugin();
        this.auditAssert.assertAuditContainer(this.audits);
        AuditRulesTest.assertTrue((String)"Tests requires at least one audit with LIVE constraint", (boolean)this.auditAssert.liveConstraintTested);
    }

    EClass findCanonicalEClass(EClass eClass) {
        String nsURI = eClass.getEPackage().getNsURI();
        GenPackage genPackage = null;
        for (GenPackage nextPackage : this.targetedPackages) {
            if (!nsURI.equals(nextPackage.getNSURI())) continue;
            genPackage = nextPackage;
            break;
        }
        AuditRulesTest.assertNotNull((String)"GenPackage for EClass target not found", genPackage);
        try {
            Class<?> packageInterfaceClass = this.getSetup().loadGeneratedClass(genPackage.getQualifiedPackageInterfaceName());
            Field instanceField = packageInterfaceClass.getField("eINSTANCE");
            Object packageInstance = instanceField.get(packageInterfaceClass);
            AuditRulesTest.assertTrue((String)"Expected EPackage instance", (boolean)(packageInstance instanceof EPackage));
            EPackage ePackage = (EPackage)packageInstance;
            EClassifier eClassifier = ePackage.getEClassifier(eClass.getName());
            AuditRulesTest.assertTrue((String)"EClassifier must be eclass", (boolean)(eClassifier instanceof EClass));
            return (EClass)eClassifier;
        }
        catch (Exception e) {
            e.printStackTrace();
            AuditRulesTest.fail((String)"Failed to access EPackage from the generated model");
            return null;
        }
    }

    static EClass getTargetEClass(AuditRule rule) {
        AuditRulesTest.assertNotNull((String)"Audit target must be set", (Object)rule.getTarget());
        return AuditRulesTest.getTargetEClass((EObject)rule.getTarget());
    }

    static EClass getTargetEClass(EObject target) {
        if (target instanceof DomainElementTarget) {
            return ((DomainElementTarget)target).getElement();
        }
        if (target instanceof NotationElementTarget) {
            return ((NotationElementTarget)target).getElement();
        }
        if (target instanceof DiagramElementTarget) {
            DiagramElementTarget diagramElementTarget = (DiagramElementTarget)target;
            MappingEntry entry = diagramElementTarget.getElement();
            if (entry instanceof NodeMapping) {
                return NotationPackage.eINSTANCE.getNode();
            }
            if (entry instanceof LinkMapping) {
                return NotationPackage.eINSTANCE.getEdge();
            }
        } else {
            if (target instanceof DomainAttributeTarget) {
                DomainAttributeTarget attrTarget = (DomainAttributeTarget)target;
                return attrTarget.getAttribute().getEContainingClass();
            }
            if (target instanceof AuditedMetricTarget) {
                return AuditRulesTest.getTargetEClass((EObject)((AuditedMetricTarget)target).getMetric().getTarget());
            }
        }
        AuditRulesTest.fail((String)"No target class");
        return null;
    }

    private class AuditAssert {
        private String pluginId;
        private boolean liveConstraintTested = false;

        AuditAssert(String pluginIdentifier) {
            this.pluginId = pluginIdentifier;
        }

        String constraintGlobalId(AuditRule audit) {
            return String.valueOf(this.pluginId) + "." + audit.getId();
        }

        void assertAudit(AuditRule audit) {
            EClass target = AuditRulesTest.this.findCanonicalEClass(AuditRulesTest.getTargetEClass(audit));
            Object validatedInstance = null;
            validatedInstance = NotationPackage.eINSTANCE.getView().isSuperTypeOf(target) ? AuditRulesTest.this.createNode((GenCommonBase)AuditRulesTest.this.getSetup().getGenModel().getNodeB(), (View)AuditRulesTest.this.getDiagram()) : target.getEPackage().getEFactoryInstance().create(target);
            this.assertEvaluation(audit, (EObject)validatedInstance);
            IConstraintDescriptor descriptor = ConstraintRegistry.getInstance().getDescriptor(this.pluginId, audit.getId());
            AuditRulesTest.assertNotNull((String)"Audit rule must be in ConstraintRegistry", (Object)descriptor);
            AuditRulesTest.assertTrue((String)"The target class must be accepted", (boolean)descriptor.targetsTypeOf(validatedInstance));
            if (!descriptor.isEnabled()) {
                System.err.println("descriptor is dispabled");
                System.err.println("descriptor.isError:" + descriptor.isError());
                if (descriptor.isError()) {
                    descriptor.getException().printStackTrace(System.err);
                }
            }
            AuditRulesTest.assertTrue((String)"Descriptor shoud be valid and enabled", (boolean)descriptor.isEnabled());
            AuditRulesTest.assertEquals((String)"Constraint id must match", (String)this.constraintGlobalId(audit), (String)descriptor.getId());
            AuditRulesTest.assertEquals((String)"Constraint Name must match", (String)audit.getName(), (String)descriptor.getName());
            AuditRulesTest.assertEquals((String)"Severity must match", (String)audit.getSeverity().getName(), (String)descriptor.getSeverity().getName());
            AuditRulesTest.assertNotNull((String)"target class is required", (Object)audit.getTarget());
            if (audit.isUseInLiveMode()) {
                AuditRulesTest.assertEquals((Object)descriptor.getEvaluationMode(), (Object)EvaluationMode.LIVE);
                this.liveConstraintTested = true;
            } else {
                AuditRulesTest.assertEquals((Object)descriptor.getEvaluationMode(), (Object)EvaluationMode.BATCH);
            }
            AuditRulesTest.assertEquals((String)"Constraint description must match", (String)audit.getDescription(), (String)descriptor.getDescription());
            AuditRulesTest.assertEquals((String)"Constraint message must match", (String)audit.getMessage(), (String)descriptor.getMessagePattern());
            Set categories = descriptor.getCategories();
            AuditRulesTest.assertEquals((String)"Single category expected", (int)1, (int)categories.size());
            AuditRulesTest.assertEquals((String)".Constraint category must be registered", categories.iterator().next(), (Object)CategoryManager.getInstance().getCategory(this.getCategoryPath(audit.getContainer())));
        }

        void assertEvaluation(final AuditRule audit, final EObject target) {
            IModelConstraint[] constraintFound;
            block9: {
                EObject[] validatedInstance = new EObject[1];
                if (target instanceof View) {
                    validatedInstance[0] = target;
                } else {
                    Diagram diagram = NotationFactory.eINSTANCE.createDiagram();
                    Node node = NotationFactory.eINSTANCE.createNode();
                    node.setElement(target);
                    validatedInstance[0] = node;
                    diagram.getTransientChildren().add((Object)node);
                    ResourceSetImpl rset = new ResourceSetImpl();
                    Resource r = rset.createResource(URI.createURI((String)"xttp://myresource"));
                    r.getContents().add((Object)diagram);
                    TransactionalEditingDomain domain = TransactionalEditingDomain.Factory.INSTANCE.createEditingDomain((ResourceSet)rset);
                    ((AdapterFactoryEditingDomain)domain).setResourceToReadOnlyMap((Map)new HashMap<Resource, Boolean>(){

                        @Override
                        public Boolean get(Object key) {
                            if (key instanceof Resource && "xttp".equals(((Resource)key).getURI().scheme())) {
                                return Boolean.FALSE;
                            }
                            return (Boolean)super.get(key);
                        }
                    });
                }
                constraintFound = new IModelConstraint[1];
                IValidationListener listener = new IValidationListener(){

                    public void validationOccurred(ValidationEvent event) {
                        boolean isTargetMatch = false;
                        Iterator it = event.getValidationTargets().iterator();
                        while (it.hasNext()) {
                            if (it.next() != target) continue;
                            isTargetMatch = true;
                            break;
                        }
                        if (!isTargetMatch) {
                            return;
                        }
                        for (IConstraintStatus status : event.getValidationResults()) {
                            if (!AuditAssert.this.constraintGlobalId(audit).equals(status.getConstraint().getDescriptor().getId())) continue;
                            constraintFound[0] = status.getConstraint();
                            break;
                        }
                    }
                };
                Method validationMethod = null;
                try {
                    String vaClassName = String.valueOf(AuditRulesTest.this.getGenModel().getGenDiagram().getEditorGen().getEditor().getPackageName()) + ".ValidateAction";
                    Class<?> validationProviderClass = AuditRulesTest.this.getSetup().loadGeneratedClass(vaClassName);
                    validationMethod = validationProviderClass.getMethod("runNonUIValidation", View.class);
                }
                catch (Exception e) {
                    AuditRulesTest.fail((String)"Could not find runNonUIValidation operation in ValidateAction");
                    e.printStackTrace();
                }
                try {
                    try {
                        ModelValidationService.getInstance().addValidationListener(listener);
                        validationMethod.invoke(null, validatedInstance[0]);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        ModelValidationService.getInstance().removeValidationListener(listener);
                        break block9;
                    }
                }
                catch (Throwable throwable) {
                    ModelValidationService.getInstance().removeValidationListener(listener);
                    throw throwable;
                }
                ModelValidationService.getInstance().removeValidationListener(listener);
            }
            AuditRulesTest.assertNotNull((String)("Constraint must be involved in validation:" + this.constraintGlobalId(audit)), (Object)constraintFound[0]);
        }

        void assertAuditContainer(AuditContainer auditContainer) {
            String categoryPath = this.getCategoryPath(auditContainer);
            AuditRulesTest.assertNotNull((String)("Category should be registered:" + categoryPath), (Object)CategoryManager.getInstance().findCategory(categoryPath));
            Category category = CategoryManager.getInstance().getCategory(categoryPath);
            AuditRulesTest.assertEquals((String)"Category id must match", (String)auditContainer.getId(), (String)category.getId());
            AuditRulesTest.assertEquals((String)"Category name must match", (String)auditContainer.getName(), (String)category.getName());
            AuditRulesTest.assertEquals((String)"Category description must match", (String)auditContainer.getDescription(), (String)category.getDescription());
            for (AuditRule nextRule : auditContainer.getAudits()) {
                this.assertAudit(nextRule);
            }
            for (AuditContainer next : auditContainer.getChildContainers()) {
                this.assertAuditContainer(next);
            }
        }

        String getCategoryPath(AuditContainer container) {
            ArrayList<AuditContainer> pathElements = new ArrayList<AuditContainer>();
            AuditContainer current = container;
            while (current != null) {
                pathElements.add(0, current);
                current = current.getParentContainer();
            }
            StringBuffer buf = new StringBuffer();
            int i = 0;
            while (i < pathElements.size()) {
                AuditContainer nextContainer = (AuditContainer)pathElements.get(i);
                if (i > 0) {
                    buf.append('/');
                }
                buf.append(nextContainer.getId());
                ++i;
            }
            return buf.toString();
        }
    }
}

