/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.runtime.diagram.ui.parts;

import java.lang.ref.PhantomReference;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Locator;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.handles.ConnectionHandle;
import org.eclipse.gmf.runtime.diagram.ui.handles.ConnectionHandleLocator;

public class ConnectionHandleTest
extends TestCase {
    public ConnectionHandleTest(String name) {
        super(name);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)ConnectionHandleTest.suite());
    }

    public static Test suite() {
        return new TestSuite(ConnectionHandleTest.class);
    }

    public void testConnectionHandle() throws Exception {
        FakeEditPart editpart = new FakeEditPart();
        ConnectionHandle handle = new ConnectionHandle((IGraphicalEditPart)editpart, ConnectionHandle.HandleDirection.OUTGOING, "the tooltip");
        ConnectionHandleLocator locator = new ConnectionHandleLocator(editpart.getFigure(), new Point(90, 90));
        handle.setLocator((Locator)locator);
        ConnectionHandleTest.assertTrue((boolean)handle.getChildren().isEmpty());
        handle.validate();
        ConnectionHandleTest.assertTrue((handle.getChildren().size() == 1 ? 1 : 0) != 0);
        ConnectionHandleTest.assertTrue((handle.getLocator() == locator ? 1 : 0) != 0);
        ConnectionHandleTest.assertTrue((handle.getOwner() == editpart ? 1 : 0) != 0);
        ConnectionHandleTest.assertTrue((!handle.isIncoming() ? 1 : 0) != 0);
        ConnectionHandleTest.assertTrue((editpart.getFigure().getBounds().getPosition(handle.getBounds().getCenter()) == 16 ? 1 : 0) != 0);
        ConnectionHandleTest.assertTrue((handle.findFigureAt(handle.getBounds().getCenter()) == handle ? 1 : 0) != 0);
        handle.addErrorIcon();
        ConnectionHandleTest.assertTrue((handle.getChildren().size() == 2 ? 1 : 0) != 0);
        handle.removeErrorIcon();
        ConnectionHandleTest.assertTrue((handle.getChildren().size() == 1 ? 1 : 0) != 0);
        handle = new ConnectionHandle((IGraphicalEditPart)editpart, ConnectionHandle.HandleDirection.INCOMING, "the tooltip");
        ConnectionHandleTest.assertTrue((boolean)handle.isIncoming());
    }

    public void testConnectionHandleForMemoryLeaks() throws Exception {
        FakeEditPart editpart = new FakeEditPart();
        ConnectionHandle objTested = new ConnectionHandle((IGraphicalEditPart)editpart, ConnectionHandle.HandleDirection.OUTGOING, "the tooltip");
        ConnectionHandleLocator locator = new ConnectionHandleLocator(editpart.getFigure(), new Point(90, 90));
        objTested.setLocator((Locator)locator);
        objTested.validate();
        ReferenceQueue spy = new ReferenceQueue();
        PhantomReference<ConnectionHandle> refObjTested = new PhantomReference<ConnectionHandle>(objTested, spy);
        objTested = null;
        System.gc();
        if (!refObjTested.isEnqueued()) {
            System.runFinalization();
        }
        ConnectionHandleTest.assertTrue((boolean)refObjTested.isEnqueued());
        Reference removedRef = spy.remove();
        if (removedRef != null) {
            removedRef.clear();
        }
    }

    private class FakeEditPart
    extends ShapeEditPart {
        public FakeEditPart() {
            super(null);
        }

        protected IFigure createFigure() {
            RectangleFigure rectangle = new RectangleFigure();
            rectangle.setLocation(new Point(0, 0));
            rectangle.setSize(100, 200);
            return rectangle;
        }
    }
}

