/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.search.ui.handlers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.search.ui.dialogs.DiagramResourceListSelectionDialog;
import org.eclipse.emf.search.ui.handlers.IOpenDiagramHandler;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOpenDiagramHandler
implements IOpenDiagramHandler {
    @Override
    public IStatus openDiagramEditor(String editorID, List<Object> list) {
        List<IResource> diagramFiles = this.selectDiagramResourceFromDialog();
        if (!diagramFiles.isEmpty()) {
            return this.openDiagramEditor(diagramFiles.get(0), list);
        }
        return Status.CANCEL_STATUS;
    }

    protected IStatus openDiagramEditor(IResource diagramFile, List<Object> list) {
        if (diagramFile instanceof IFile) {
            IEditorPart editorPart = null;
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            try {
                editorPart = page.openEditor((IEditorInput)new FileEditorInput((IFile)diagramFile), this.getDiagramEditorID());
            }
            catch (PartInitException e) {
                e.printStackTrace();
                return Status.CANCEL_STATUS;
            }
            if (editorPart instanceof IEditorPart) {
                this.selectElements(editorPart, list);
            }
        }
        return Status.OK_STATUS;
    }

    protected abstract String getDiagramEditorID();

    protected abstract void selectElements(IEditorPart var1, List<Object> var2);

    protected List<IResource> selectDiagramResourceFromDialog() {
        ArrayList<IResource> list = new ArrayList<IResource>();
        DiagramResourceListSelectionDialog d = new DiagramResourceListSelectionDialog(Display.getDefault().getActiveShell(), this.getDiagramFiles().toArray(new IResource[0]));
        if (d.open() == 0) {
            Object[] objectArray = d.getResult();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                if (o instanceof IResource) {
                    list.add((IResource)o);
                }
                ++n2;
            }
        }
        return list;
    }

    protected abstract String getDiagramFileExtension();

    @Override
    public List<IResource> getDiagramFiles() {
        try {
            DiagramResourceVisitor diagramResourceVisitor = new DiagramResourceVisitor();
            ResourcesPlugin.getWorkspace().getRoot().accept((IResourceProxyVisitor)diagramResourceVisitor, 2);
            return diagramResourceVisitor.getMatches();
        }
        catch (CoreException e) {
            e.printStackTrace();
            return new ArrayList<IResource>();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class DiagramResourceVisitor
    implements IResourceProxyVisitor {
        private List<IResource> matches = new ArrayList<IResource>();

        public boolean visit(IResourceProxy proxy) throws CoreException {
            switch (proxy.getType()) {
                case 1: {
                    IResource resource = proxy.requestResource();
                    if (!AbstractOpenDiagramHandler.this.getDiagramFileExtension().equals(resource.getFileExtension())) break;
                    this.matches.add(resource);
                    break;
                }
            }
            return true;
        }

        public List<IResource> getMatches() {
            return this.matches;
        }
    }
}

