/*******************************************************************************
 * Copyright (c) 2009 Ecliptical Software Inc. and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Ecliptical Software Inc. - initial API and implementation
 *******************************************************************************/
package org.eclipse.emf.mint.internal.genmodel;

import java.util.LinkedList;

import org.eclipse.emf.codegen.ecore.genmodel.GenAnnotation;
import org.eclipse.emf.codegen.ecore.genmodel.GenBase;
import org.eclipse.emf.codegen.ecore.genmodel.GenClass;
import org.eclipse.emf.codegen.ecore.genmodel.GenClassifier;
import org.eclipse.emf.codegen.ecore.genmodel.GenDataType;
import org.eclipse.emf.codegen.ecore.genmodel.GenEnum;
import org.eclipse.emf.codegen.ecore.genmodel.GenEnumLiteral;
import org.eclipse.emf.codegen.ecore.genmodel.GenFeature;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenOperation;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.codegen.ecore.genmodel.GenParameter;
import org.eclipse.emf.codegen.ecore.genmodel.GenTypeParameter;
import org.eclipse.emf.codegen.ecore.genmodel.GenTypedElement;
import org.eclipse.emf.codegen.ecore.genmodel.util.GenModelSwitch;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.mint.IItemJavaElementSource;
import org.eclipse.emf.mint.IItemJavaElementSourceContributor;

public class GenModelJavaElementSourceContributor implements
		IItemJavaElementSourceContributor, IChangeNotifier, IDisposable {

	protected final GenModelSwitch<Adapter> modelSwitch = new GenModelSwitch<Adapter>() {

		@Override
		public Adapter caseGenModel(GenModel object) {
			return createGenModelAdapter();
		}

		@Override
		public Adapter caseGenPackage(GenPackage object) {
			return createGenPackageAdapter();
		}

		@Override
		public Adapter caseGenClass(GenClass object) {
			return createGenClassAdapter();
		}

		@Override
		public Adapter caseGenFeature(GenFeature object) {
			return createGenFeatureAdapter();
		}

		@Override
		public Adapter caseGenBase(GenBase object) {
			return createGenBaseAdapter();
		}

		@Override
		public Adapter caseGenEnum(GenEnum object) {
			return createGenEnumAdapter();
		}

		@Override
		public Adapter caseGenEnumLiteral(GenEnumLiteral object) {
			return createGenEnumLiteralAdapter();
		}

		@Override
		public Adapter caseGenClassifier(GenClassifier object) {
			return createGenClassifierAdapter();
		}

		@Override
		public Adapter caseGenDataType(GenDataType object) {
			return createGenDataTypeAdapter();
		}

		@Override
		public Adapter caseGenOperation(GenOperation object) {
			return createGenOperationAdapter();
		}

		@Override
		public Adapter caseGenParameter(GenParameter object) {
			return createGenParameterAdapter();
		}

		@Override
		public Adapter caseGenTypedElement(GenTypedElement object) {
			return createGenTypedElementAdapter();
		}

		@Override
		public Adapter caseGenAnnotation(GenAnnotation object) {
			return createGenAnnotationAdapter();
		}

		@Override
		public Adapter caseGenTypeParameter(GenTypeParameter object) {
			return createGenTypeParameterAdapter();
		}

		@Override
		public Adapter defaultCase(EObject object) {
			return createEObjectAdapter();
		}
	};

	protected final LinkedList<IDisposable> adapters = new LinkedList<IDisposable>();

	protected final IChangeNotifier changeNotifier = new LightweightChangeNotifier();

	protected Adapter createAdapter(Notifier target) {
		Adapter adapter = modelSwitch.doSwitch((EObject) target);
		if (adapter != null)
			target.eAdapters().add(adapter);

		return adapter;
	}

	protected Adapter createGenModelAdapter() {
		Adapter adapter = new GenModelItemProvider(this);
		if (adapter instanceof IDisposable)
			adapters.add((IDisposable) adapter);

		return adapter;
	}

	protected Adapter createGenPackageAdapter() {
		Adapter adapter = new GenPackageItemProvider(this);
		if (adapter instanceof IDisposable)
			adapters.add((IDisposable) adapter);

		return adapter;
	}

	protected Adapter createGenClassAdapter() {
		Adapter adapter = new GenClassItemProvider(this);
		if (adapter instanceof IDisposable)
			adapters.add((IDisposable) adapter);

		return adapter;
	}

	protected Adapter createGenFeatureAdapter() {
		Adapter adapter = new GenFeatureItemProvider(this);
		if (adapter instanceof IDisposable)
			adapters.add((IDisposable) adapter);

		return adapter;
	}

	protected Adapter createGenBaseAdapter() {
		return null;
	}

	protected Adapter createGenEnumAdapter() {
		Adapter adapter = new GenEnumItemProvider(this);
		if (adapter instanceof IDisposable)
			adapters.add((IDisposable) adapter);

		return adapter;
	}

	protected Adapter createGenEnumLiteralAdapter() {
		Adapter adapter = new GenEnumLiteralItemProvider(this);
		if (adapter instanceof IDisposable)
			adapters.add((IDisposable) adapter);

		return adapter;
	}

	protected Adapter createGenClassifierAdapter() {
		return null;
	}

	protected Adapter createGenDataTypeAdapter() {
		Adapter adapter = new GenDataTypeItemProvider(this);
		if (adapter instanceof IDisposable)
			adapters.add((IDisposable) adapter);

		return adapter;
	}

	protected Adapter createGenOperationAdapter() {
		Adapter adapter = new GenOperationItemProvider(this);
		if (adapter instanceof IDisposable)
			adapters.add((IDisposable) adapter);

		return adapter;
	}

	protected Adapter createGenParameterAdapter() {
		return null;
	}

	protected Adapter createGenTypedElementAdapter() {
		return null;
	}

	protected Adapter createGenAnnotationAdapter() {
		return null;
	}

	protected Adapter createGenTypeParameterAdapter() {
		return null;
	}

	protected Adapter createEObjectAdapter() {
		return null;
	}

	public IItemJavaElementSource getItemJavaElementSource(Object object) {
		if (object instanceof Notifier)
			return (IItemJavaElementSource) createAdapter((Notifier) object);

		return null;
	}

	public void addListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.addListener(notifyChangedListener);
	}

	public void removeListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.removeListener(notifyChangedListener);
	}

	public void fireNotifyChanged(Notification notification) {
		changeNotifier.fireNotifyChanged(notification);
	}

	public void dispose() {
		for (IDisposable adapter : adapters)
			adapter.dispose();
	}

	private static class LightweightChangeNotifier implements IChangeNotifier {

		private INotifyChangedListener listener;

		private ChangeNotifier changeNotifier;

		public void addListener(INotifyChangedListener notifyChangedListener) {
			if (listener == null)
				listener = notifyChangedListener;
			else {
				if (changeNotifier == null)
					changeNotifier = new ChangeNotifier();

				changeNotifier.addListener(notifyChangedListener);
			}
		}

		public void removeListener(INotifyChangedListener notifyChangedListener) {
			if (changeNotifier == null) {
				if (listener == notifyChangedListener)
					listener = null;
			} else {
				changeNotifier.removeListener(notifyChangedListener);
				if (changeNotifier.isEmpty())
					changeNotifier = null;
			}
		}

		public void fireNotifyChanged(Notification notification) {
			if (listener != null)
				listener.notifyChanged(notification);

			if (changeNotifier != null)
				changeNotifier.fireNotifyChanged(notification);
		}
	}
}
