/*******************************************************************************
 * Copyright (c) 2005 - 2006 Joel Cheuoua & others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Joel Cheuoua - initial API and implementation
 *******************************************************************************/
package org.eclipse.emf.codegen.jet.editor.presentation;

import java.util.ResourceBundle;

import org.eclipse.emf.codegen.jet.editor.JETEditorPlugin;
import org.eclipse.emf.codegen.jet.editor.preferences.JETTemplateEditorPreferenceConstants;
import org.eclipse.emf.codegen.jet.editor.util.JETTemplateDocumentProvider;
import org.eclipse.emf.codegen.jet.editor.util.JETTemplateSourceViewerConfiguration;
import org.eclipse.jdt.internal.ui.IJavaHelpContextIds;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.ui.text.IColorManager;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.texteditor.ContentAssistAction;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditorActionDefinitionIds;
/**
 * @see TextEditor
 * @author Joel
 * @version $Revision: 1.4 $
 */
public class JETTextEditor extends TextEditor {
  private ISourceViewer sourceViewer;
  /**
   * Text operation code for requesting correction assist to show correction proposals for the
   * current position.
   */
  public static final int CORRECTIONASSIST_PROPOSALS = 50;
  
  /**
   * Text operation code for requesting common prefix completion.
   */
  public static final int CONTENTASSIST_COMPLETE_PREFIX = 60;
  private IDocumentProvider provider;

  public JETTextEditor() {
    IPreferenceStore preferenceStore = JETEditorPlugin.getDefault().getPreferenceStore();
    JETTemplateEditorPreferenceConstants.initializeDefaultValues(preferenceStore);
    IColorManager colorManager = JavaPlugin.getDefault().getJavaTextTools().getColorManager();
    
    setPreferenceStore(preferenceStore);
    setDocumentProvider(provider = new JETTemplateDocumentProvider());
    setSourceViewerConfiguration(new JETTemplateSourceViewerConfiguration(colorManager, preferenceStore, this, null));    
  }
  /**
   * Method getProvider.
   * @return IDocumentProvider
   */
  public IDocumentProvider getProvider() {
    return provider;
  }
  /**
   * Method setProvider.
   * @param provider IDocumentProvider
   */
  public void setProvider(IDocumentProvider provider) {
    this.provider = provider;
  }
  
  protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
    sourceViewer = super.createSourceViewer(parent, ruler, styles);
    return sourceViewer;
  }
  
  public ISourceViewer getJETEditorSourceViewer() {
    return sourceViewer;
  }
  
  /*
   * @see AbstractTextEditor#createActions()
   */
  protected void createActions() {
    super.createActions();
    ResourceBundle resourceBundle = ResourceBundle.getBundle("org.eclipse.emf.codegen.jet.editor.presentation.TextEditorMessages");
    Action action = new ContentAssistAction(resourceBundle,"ContentAssistProposal.", this); //$NON-NLS-1$
    action.setActionDefinitionId(ITextEditorActionDefinitionIds.CONTENT_ASSIST_PROPOSALS);
    setAction("ContentAssistProposal", action); //$NON-NLS-1$
    markAsStateDependentAction("ContentAssistProposal", true); //$NON-NLS-1$
    PlatformUI.getWorkbench().getHelpSystem().setHelp(action, IJavaHelpContextIds.CONTENT_ASSIST_ACTION);       
  }
}
