/*******************************************************************************
 * Copyright (c) 2005 - 2006 Joel Cheuoua & others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Joel Cheuoua - initial API and implementation
 *******************************************************************************/
package org.eclipse.emf.codegen.jet.editor;

import java.lang.reflect.Method;
import java.util.ArrayList;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.codegen.ecore.genmodel.GenBase;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenModelFactory;
import org.eclipse.emf.codegen.ecore.genmodel.impl.GenBaseImpl;
import org.eclipse.emf.codegen.jet.JETCompiler;
import org.eclipse.emf.codegen.jet.JETEmitter;
import org.eclipse.emf.codegen.jet.JETException;
import org.eclipse.emf.codegen.merge.java.JControlModel;
import org.eclipse.emf.codegen.merge.java.facade.FacadeHelper;
import org.eclipse.emf.codegen.util.CodeGenUtil;
import org.eclipse.emf.codegen.util.ImportManager;
import org.eclipse.emf.ecore.EModelElement;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Generator</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link com.metys.merlin.generation.templates.jetmapping.impl.JETEditorGenerator#getMappingRoot <em>Mapping Root</em>}</li>
 *   <li>{@link com.metys.merlin.generation.templates.jetmapping.impl.JETEditorGenerator#getCurrentGeneratedObject <em>Current Generated Object</em>}</li>
 *   <li>{@link com.metys.merlin.generation.templates.jetmapping.impl.JETEditorGenerator#getClassLoader <em>Class Loader</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class JETEditorGenerator extends GenBaseImpl {
  /**
   * The cached value of the '{@link #getCurrentGeneratedObject() <em>Current Generated Object</em>}' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see #getCurrentGeneratedObject()
   * @generated
   * @ordered
   */
  protected Object currentGeneratedObject = null;

  /**
   * The cached value of the '{@link #getClassLoader() <em>Class Loader</em>}' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see #getClassLoader()
   * @ordered
   */
  protected ClassLoader classLoader= null;
  
  protected GenModel genModel = null;
    
  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   */
  public JETEditorGenerator() {
    super();
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   */
  public GenModel getGenModel() {
    if (genModel == null)
      genModel = GenModelFactory.eINSTANCE.createGenModel();
    return genModel;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   */
  public Object getCurrentGeneratedObject() {
    return currentGeneratedObject;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   */
  public void setCurrentGeneratedObject(Object newCurrentGeneratedObject) {
    this.currentGeneratedObject = newCurrentGeneratedObject;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public ClassLoader getClassLoader() {
    return classLoader;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public void setClassLoader(ClassLoader newClassLoader) {
    this.classLoader = newClassLoader;
  }

  /*
   * (non-Javadoc)
   * 
   * @see com.metys.merlin.generation.genpattern.impl.GenerationPatternImpl#loadClass(java.lang.String)
   */
  protected Class loadEmitterClass(String className, ClassLoader cl) throws ClassNotFoundException {
    Class clazz = null;
    try {
      clazz = Class.forName(className, true, cl);
    } catch (Throwable t) {
      clazz = Class.forName(className);
    }
    return clazz;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated NOT
   */
  public void setMethod(JETEmitter jetEmitter, String className, ClassLoader cl) {
    try {
      Class emitterClass = loadEmitterClass(className, cl);
      Method emitterMethod = emitterClass.getDeclaredMethod("generate", new Class[] { Object.class });
      jetEmitter.setMethod(emitterMethod);
    } catch (Exception exception) {
      JETEditorPlugin.getDefault().log(exception);
    }
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated NOT
   */
  public String generateText(Object generatedObject, String jetFilePath, IProgressMonitor progressMonitor) {
    try {
      // Parse the JET Template
      JETCompiler jetCompiler = new JETCompiler(jetFilePath, "UTF-8");
      jetCompiler.parse();
      
      // Create the adequate classLoader
      ClassLoader cl = getClassLoader();
      JETEmitter jetEmitter = new JETEmitter(jetFilePath, cl);
      setMethod(jetEmitter, jetCompiler.getSkeleton().getPackageName() + "." + jetCompiler.getSkeleton().getClassName(), cl);
      return getGeneratedTextString(progressMonitor, jetEmitter, generatedObject, false);
    } catch (JETException e) {
      JETEditorPlugin.getDefault().log(e);
    }
    return null;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated NOT
   */
  public String generateJava(Object generatedObject, String jetFilePath, IProgressMonitor progressMonitor) {
    try {
      // Parse the JET Template
      JETCompiler jetCompiler = new JETCompiler(jetFilePath, "UTF-8");
      jetCompiler.parse();
      
      // Create the adequate classLoader
      ClassLoader cl = getClassLoader();
      JETEmitter jetEmitter = new JETEmitter(jetFilePath, cl);
      setMethod(jetEmitter, jetCompiler.getSkeleton().getPackageName() + "." + jetCompiler.getSkeleton().getClassName(), cl);
      if (generatedObject instanceof GenBase)
        genModel = ((GenBase) generatedObject).getGenModel();
      // Create an dummy import manager for this compilation unit
      ImportManager importManager = new ImportManager("");
      setImportManager(importManager);
      return getGeneratedJavaString(progressMonitor, jetEmitter, generatedObject, false);
    } catch (JETException e) {
      JETEditorPlugin.getDefault().log(e);
    }
    return null;
  }
    
  protected String getGeneratedTextString(IProgressMonitor progressMonitor, JETEmitter jetEmitter, Object argument, boolean additionalGenModelArg) {
    try {
      progressMonitor.beginTask("", 3);
      progressMonitor.subTask("Generating Output");
      
      Object args = argument;
      if (additionalGenModelArg) {
        ArrayList list = new ArrayList();
        list.add(argument);
        list.add(getGenModel());
        args = list;
      }
      
      String emitterResult = jetEmitter.generate(new SubProgressMonitor(progressMonitor, 1),
          new Object[] { args });
      emitterResult = unicodeEscapeEncode(emitterResult);
      
      progressMonitor.worked(1);      
      return emitterResult;
    } catch (Exception exception) {
      JETEditorPlugin.getDefault().log(exception);
      return "";
    } finally {
      progressMonitor.done();
    }
  }
  
  protected String getGeneratedJavaString(IProgressMonitor progressMonitor, JETEmitter jetEmitter, Object argument, boolean additionalGenModelArg) {
    try {
      progressMonitor.beginTask("", 3);
      progressMonitor.subTask("Generating Output");
      
      Object args = argument;
      if (additionalGenModelArg) {
        ArrayList list = new ArrayList();
        list.add(argument);
        list.add(getGenModel());
        args = list;       
      }
      
      String emitterResult = jetEmitter.generate(new SubProgressMonitor(progressMonitor, 1),
          new Object[] { args });
      emitterResult = unicodeEscapeEncode(emitterResult);
      
      JControlModel jControlModel = getGenModel().getJControlModel();
      if (jControlModel.getFacadeHelper() == null || !jControlModel.getFacadeHelper().getClass().getName().equals(getGenModel().getFacadeHelperClass()))
      {
        FacadeHelper facadeHelper = CodeGenUtil.instantiateFacadeHelper(getGenModel().getFacadeHelperClass()); 
        jControlModel.initialize(facadeHelper, getGenModel().getMergeRulesLocation());
      }
      
      String newContents = CodeGenUtil.convertFormat(jControlModel.getLeadingTabReplacement(), jControlModel.convertToStandardBraceStyle(), emitterResult);
      return newContents;
    } catch (Exception exception) {
      JETEditorPlugin.getDefault().log(exception);
      return "";
    } finally {
      progressMonitor.done();
    }
  }

  
  /* (non-Javadoc)
   * @see org.eclipse.emf.codegen.ecore.genmodel.impl.GenBaseImpl#getName()
   */
  public String getName() {
    return "JETEditorGenerator";
  }

  /* (non-Javadoc)
   * @see org.eclipse.emf.codegen.ecore.genmodel.impl.GenBaseImpl#getEcoreModelElement()
   */
  public EModelElement getEcoreModelElement() {
    return null;
  }

  /* (non-Javadoc)
   * @see org.eclipse.emf.codegen.ecore.genmodel.GenBase#reconcile()
   */
  public boolean reconcile() {
    return false;
  }

} //JETEditorGenerator
