/*
 * generated by Xtext 2.10.0
 */
package org.eclipse.emf.henshin.text.formatting2

import com.google.inject.Inject
import org.eclipse.emf.henshin.text.henshin_text.EPackageImport
import org.eclipse.emf.henshin.text.henshin_text.Model
import org.eclipse.emf.henshin.text.henshin_text.ModelElement
import org.eclipse.emf.henshin.text.henshin_text.Parameter
import org.eclipse.emf.henshin.text.henshin_text.Rule
import org.eclipse.emf.henshin.text.henshin_text.RuleElement
import org.eclipse.emf.henshin.text.services.Henshin_textGrammarAccess
import org.eclipse.xtext.formatting2.AbstractFormatter2
import org.eclipse.xtext.formatting2.IFormattableDocument
import org.eclipse.emf.henshin.text.henshin_text.Graph
import org.eclipse.emf.henshin.text.henshin_text.Node
import org.eclipse.emf.henshin.text.henshin_text.GraphElements
import org.eclipse.emf.henshin.text.henshin_text.Formula
import org.eclipse.emf.henshin.text.henshin_text.ConditionGraph
import org.eclipse.emf.henshin.text.henshin_text.ConditionGraphElements
import org.eclipse.emf.henshin.text.henshin_text.MultiRule
import org.eclipse.emf.henshin.text.henshin_text.Edges
import org.eclipse.emf.henshin.text.henshin_text.ConditionNode
import org.eclipse.emf.henshin.text.henshin_text.ConditionEdges
import org.eclipse.emf.henshin.text.henshin_text.Henshin_textPackage
import org.eclipse.emf.henshin.text.henshin_text.ConditionReuseNode
import org.eclipse.emf.henshin.text.henshin_text.Attribute
import org.eclipse.emf.common.util.EList
import org.eclipse.emf.henshin.text.henshin_text.Match
import org.eclipse.emf.ecore.EObject
import org.eclipse.emf.henshin.text.henshin_text.JavaImport
import org.eclipse.emf.henshin.text.henshin_text.MultiRuleReuseNode
import org.eclipse.emf.henshin.text.henshin_text.Edge
import org.eclipse.emf.henshin.text.henshin_text.ConditionEdge
import org.eclipse.emf.henshin.text.henshin_text.Conditions
import org.eclipse.emf.henshin.text.henshin_text.Expression
import org.eclipse.emf.henshin.text.henshin_text.CheckDangling
import org.eclipse.emf.henshin.text.henshin_text.InjectiveMatching
import org.eclipse.emf.henshin.text.henshin_text.Unit
import org.eclipse.emf.henshin.text.henshin_text.UnitElement
import org.eclipse.emf.henshin.text.henshin_text.ConditionalUnit
import org.eclipse.emf.henshin.text.henshin_text.PriorityUnit
import org.eclipse.emf.henshin.text.henshin_text.IndependentUnit
import org.eclipse.emf.henshin.text.henshin_text.LoopUnit
import org.eclipse.emf.henshin.text.henshin_text.IteratedUnit
import org.eclipse.emf.henshin.text.henshin_text.Call
import org.eclipse.emf.henshin.text.henshin_text.Strict
import org.eclipse.emf.henshin.text.henshin_text.Rollback

class Henshin_textFormatter extends AbstractFormatter2 {

	@Inject extension Henshin_textGrammarAccess
	
	EList<Match> el

	def dispatch void format(Model model, extension IFormattableDocument document) {
		val lastImport = model.getEPackageimports().last
		for (EPackageImport ePackageimport : model.getEPackageimports()) {
			ePackageimport.format
			if (ePackageimport === lastImport)
				ePackageimport.append[setNewLines(2)]
			else
				ePackageimport.append[setNewLines(1)]
		}
		
		for (ModelElement transformationsystem : model.getTransformationsystem()) {
			transformationsystem.format
		}
	}
	
	
	def dispatch void format(EPackageImport ePackageImport, extension IFormattableDocument document) {
		ePackageImport.regionFor.keyword("ePackageImport").append[oneSpace]
	}
	

	def dispatch void format(Rule rule, extension IFormattableDocument document) {
		for (Parameter parameters : rule.getParameters()) {
			parameters.format;
		}
		
		for (RuleElement ruleElements : rule.getRuleElements()) {
			ruleElements.format;
		}
		rule.regionFor.keyword("(").append[noSpace]
		rule.regionFor.keyword(")").append[oneSpace]
		rule.regionFor.keyword("{").append[newLine]
		rule.regionFor.keyword("}").prepend[newLine]
		rule.surround[newLines = 2]
	}
	
	def dispatch void format(MultiRule rule, extension IFormattableDocument document) {
		rule.surround[newLine]
		rule.surround[indent]
		for (RuleElement ruleElements : rule.getMultiruleElements()) {
			ruleElements.format;
		}
		rule.regionFor.keyword("(").append[noSpace]
		rule.regionFor.keyword(")").append[oneSpace]
		rule.regionFor.keyword("{").append[newLine]
		rule.regionFor.keyword("}").prepend[newLine]
		rule.surround[newLines = 1]
	}

	def dispatch void format(JavaImport javaImport, extension IFormattableDocument document) {
		javaImport.surround[indent]
		javaImport.regionFor.keyword("javaImport").append[oneSpace]
		javaImport.append[newLine]
		
	}
	
	def dispatch void format(CheckDangling checkDangling, extension IFormattableDocument document) {
		checkDangling.surround[indent]
		checkDangling.regionFor.keyword("checkDangling").append[oneSpace]
		checkDangling.append[newLine]
		
	}
	
	def dispatch void format(InjectiveMatching injectiveMatching, extension IFormattableDocument document) {
		injectiveMatching.surround[indent]
		injectiveMatching.regionFor.keyword("checkDangling").append[oneSpace]
		injectiveMatching.append[newLine]
		
	}
	def dispatch void format(Graph graph, extension IFormattableDocument document) {
		graph.surround[newLine]
		if (!graph.graphElements.isEmpty)
			graph.regionFor.keyword("{").append[newLine]
		for (GraphElements el : graph.graphElements) {
			el.format;
		}
		graph.regionFor.keyword("{").prepend[oneSpace]
		if (!graph.graphElements.isEmpty)
			graph.regionFor.keyword("}").prepend[newLine]
		graph.surround[indent]
	}
	
	def dispatch void format(ConditionGraph graph, extension IFormattableDocument document) {
		if (!graph.conditionGraphElements.isEmpty)
			graph.regionFor.keyword("{").append[newLine]
		for (ConditionGraphElements el : graph.conditionGraphElements) {
			el.format;
		}
		graph.regionFor.keyword("{").prepend[oneSpace]
		if (!graph.conditionGraphElements.isEmpty)
			graph.regionFor.keyword("}").prepend[newLine]
		graph.surround[indent]
	}

	def dispatch void format(Node node, extension IFormattableDocument document) {
		node.surround[newLine]
		node.surround[indent]
		node.regionFor.keyword("{").prepend[oneSpace]
		node.regionFor.keyword("(").append[noSpace]
		for (EObject attr : node.attribute) {
			attr.format;
		}
		node.regionFor.keyword(")").append[oneSpace]
	}
	
	def dispatch void format(Attribute attribute, extension IFormattableDocument document) {
		attribute.surround[newLine]
		attribute.surround[indent]
	}
	
	def dispatch void format(Match match, extension IFormattableDocument document) {
		match.surround[newLine]
		match.surround[indent]
	}
	
	
	def dispatch void format(ConditionNode node, extension IFormattableDocument document) {
		node.surround[newLine]
		node.surround[indent]
		node.regionFor.keyword("{").prepend[oneSpace]
		node.regionFor.keyword("(").append[noSpace]
		for (EObject attr : node.attribute) {
			attr.format;
		}
		node.regionFor.keyword(")").append[oneSpace]
	}
	
	
	
	def dispatch void format(Edges edges, extension IFormattableDocument document) {
		edges.surround[newLine]
		edges.surround[indent]
		val first = edges.edges.get(0)
		for (Edge e : edges.edges) {
			if (e !== first)
				e.format
		}
	}
	

	def dispatch void format(Edge edge, extension IFormattableDocument document) {
		edge.surround[indent]		
		edge.prepend[newLine]
		edge.previousHiddenRegion.immediatelyPreceding.keyword(",").append[noSpace]
	}
	
	def dispatch void format(ConditionEdges edges, extension IFormattableDocument document) {
		edges.surround[newLine]
		edges.surround[indent]
		val first = edges.edges.get(0)
		for (ConditionEdge e : edges.edges) {
			if (e !== first)
				e.format
		}
	}
	def dispatch void format(ConditionEdge edge, extension IFormattableDocument document) {
		edge.surround[indent]		
		edge.prepend[newLine]
		edge.previousHiddenRegion.immediatelyPreceding.keyword(",").append[noSpace]
	}
	
	
	def dispatch void format(Conditions conditions, extension IFormattableDocument document) {
		conditions.surround[newLine]
		conditions.surround[indent]
		val first = conditions.attributeConditions.get(0)
		for (Expression e : conditions.attributeConditions) {
			if (e !== first)
				e.format
		}
	}
	
	def dispatch void format(Expression expression, extension IFormattableDocument document) {
		expression.surround[indent]		
		expression.prepend[newLine]
		expression.previousHiddenRegion.immediatelyPreceding.keyword(",").append[noSpace]
	}
	
	
	def dispatch void format(ConditionReuseNode node, extension IFormattableDocument document) {
		node.surround[newLine]
		node.surround[indent]
		node.regionFor.keyword("{").prepend[oneSpace]
		node.regionFor.keyword("(").append[noSpace]
		for (EObject attr : node.attribute) {
			attr.format;
		}
		node.regionFor.keyword(")").append[oneSpace]
	}
	
	
	def dispatch void format(MultiRuleReuseNode node, extension IFormattableDocument document) {
		node.surround[newLine]
		node.surround[indent]
		node.regionFor.keyword("{").prepend[oneSpace]
		node.regionFor.keyword("(").append[noSpace]
		for (EObject attr : node.attribute) {
			attr.format;
		}
		node.regionFor.keyword(")").append[oneSpace]
	}
	
	def dispatch void format(Formula formula, extension IFormattableDocument document) {
		formula.surround[newLine]
		formula.surround[indent]
		formula.regionFor.keyword("formula").prepend[newLine]
		formula.regionFor.keyword("formula").surround[indent]
		formula.regionFor.keyword("}").prepend[newLine]
		for (ConditionGraph g : formula.conditionGraphs) {
			g.prepend[newLine]
			g.format;
		}
	}



	def dispatch void format(Unit unit, extension IFormattableDocument document) {
		for (Parameter parameters : unit.getParameters()) {
			parameters.format;
		}
		
		for (UnitElement unitElement : unit.getUnitElements()) {
			unitElement.format;
		}
		unit.regionFor.keyword("(").append[noSpace]
		unit.regionFor.keyword(")").append[oneSpace]
		unit.regionFor.keyword("{").append[newLine]
		unit.regionFor.keyword("}").prepend[newLine]
		unit.surround[newLines = 2]
	}

	def dispatch void format(UnitElement unitElement, extension IFormattableDocument document) {
		unitElement.surround[newLine]
		unitElement.surround[indent]
		for (el : unitElement.subSequence)
			el.format
	}
	def dispatch void format(Call call, extension IFormattableDocument document) {
		call.surround[newLine]
		call.surround[indent]
	}
	def dispatch void format(ConditionalUnit unit, extension IFormattableDocument document) {
		unit.surround[newLine]
		unit.surround[indent]
		
		unit.regionFor.keyword("(").prepend[oneSpace]
		unit.regionFor.keyword("(").append[noSpace]
		unit.regionFor.keyword(")").append[oneSpace]
		unit.regionFor.keyword("{").append[newLine]
		unit.regionFor.keyword("}").prepend[newLine]
		unit.regionFor.keyword("else").prepend[oneSpace]
		
		unit.getIf().format
		
		for (el : unit.getThen()) 
			el.format
		
		for (el : unit.getElse()) 
			el.format
		
		
	}
	def dispatch void format(PriorityUnit unit, extension IFormattableDocument document) {
		unit.surround[newLine]
		unit.surround[indent]
		for (el : unit.subSequence)
			el.format
	}
	def dispatch void format(IndependentUnit unit, extension IFormattableDocument document) {
		unit.surround[newLine]
		unit.surround[indent]
		for (el : unit.subSequence)
			el.format
	}
	def dispatch void format(LoopUnit unit, extension IFormattableDocument document) {
		unit.surround[newLine]
		unit.surround[indent]
		for (el : unit.subElement)
			el.format
	}
	def dispatch void format(IteratedUnit unit, extension IFormattableDocument document) {
		unit.surround[newLine]
		unit.surround[indent]
		for (el : unit.subElement) {
			el.format
		}
		unit.regionFor.keyword("(").prepend[oneSpace]
		unit.regionFor.keyword("(").append[noSpace]
		unit.regionFor.keyword(")").append[oneSpace]
		unit.regionFor.keyword("{").append[newLine]
		unit.regionFor.keyword("}").prepend[newLine]
		unit.surround[newLines = 1]
	}
	def dispatch void format(Strict strict, extension IFormattableDocument document) {
		strict.surround[newLine]
		strict.surround[indent]
	}
	def dispatch void format(Rollback rollback, extension IFormattableDocument document) {
		rollback.surround[newLine]
		rollback.surround[indent]
	}
}
