/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.model.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.henshin.model.Action;
import org.eclipse.emf.henshin.model.GraphElement;
import org.eclipse.emf.henshin.model.NestedCondition;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.model.actions.ActionHelper;

public class ActionElementFinder {
    static <E extends GraphElement> List<E> getRuleElementCandidates(Rule kernel, Action action, EReference containment) {
        ArrayList candidates = new ArrayList();
        ArrayList<Rule> rules = new ArrayList<Rule>();
        if (action == null || !action.isMulti()) {
            rules.add(kernel);
        }
        if (action == null || action.isMulti()) {
            rules.addAll((Collection<Rule>)kernel.getAllMultiRules());
        }
        if (action == null || action.getType() == Action.Type.DELETE || action.getType() == Action.Type.PRESERVE) {
            for (Rule rule : rules) {
                candidates.addAll((List)rule.getLhs().eGet((EStructuralFeature)containment));
            }
        }
        if (action == null || action.getType() == Action.Type.CREATE) {
            for (Rule rule : rules) {
                candidates.addAll((List)rule.getRhs().eGet((EStructuralFeature)containment));
            }
        }
        for (Rule rule : rules) {
            for (NestedCondition nestedCond : rule.getLhs().getNestedConditions()) {
                if (action != null && (action.getType() != Action.Type.REQUIRE || !nestedCond.isPAC()) && (action.getType() != Action.Type.FORBID || !nestedCond.isNAC())) continue;
                candidates.addAll((List)nestedCond.getConclusion().eGet((EStructuralFeature)containment));
            }
        }
        return candidates;
    }

    public static <E extends GraphElement> E getActionElement(E element, ActionHelper<E, ?> helper) {
        if (element == null || element.getGraph() == null) {
            return null;
        }
        if (helper.getAction(element) != null) {
            return element;
        }
        EObject container = element.getGraph().eContainer();
        if (container instanceof Rule) {
            E originInKernel;
            Rule rule = (Rule)container;
            E origin = rule.getMappings().getOrigin(element);
            if (origin == null) {
                origin = element;
            }
            if ((originInKernel = rule.getMultiMappings().getOrigin(origin)) != null) {
                return ActionElementFinder.getActionElement(originInKernel, helper);
            }
            return origin;
        }
        if (container instanceof NestedCondition) {
            return ActionElementFinder.getActionElement(((NestedCondition)container).getMappings().getOrigin(element), helper);
        }
        throw new RuntimeException("Graph neither contained in a Rule nor in a NestedCondition");
    }
}

