/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.interpreter.debug;

import java.util.Arrays;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.henshin.interpreter.EGraph;
import org.eclipse.emf.henshin.interpreter.debug.HenshinDebugElement;
import org.eclipse.emf.henshin.interpreter.debug.HenshinDebugVariable;

public abstract class HenshinDebugValue
extends HenshinDebugElement
implements IValue {
    protected EGraph graph;
    protected String declaredType;
    protected String actualType;
    protected String valueString;
    protected int indexInDomain = -1;
    protected HenshinDebugVariable[] childrenVariables;

    public HenshinDebugValue(IDebugTarget target, EGraph graph, String declaredType) {
        super(target);
        this.graph = graph;
        if (declaredType == null) {
            throw new IllegalArgumentException("declaredType must not be null");
        }
        this.declaredType = declaredType;
    }

    public String getReferenceTypeName() throws DebugException {
        return this.actualType;
    }

    public String getValueString() throws DebugException {
        return this.valueString;
    }

    public boolean isAllocated() throws DebugException {
        return true;
    }

    public abstract IVariable[] getVariables() throws DebugException;

    public boolean hasVariables() throws DebugException {
        return this.childrenVariables != null;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.actualType == null ? 0 : this.actualType.hashCode());
        result = 31 * result + Arrays.hashCode((Object[])this.childrenVariables);
        result = 31 * result + (this.valueString == null ? 0 : this.valueString.hashCode());
        return result;
    }

    public boolean isPrimitive(EObject object) {
        if (object instanceof EAttribute) {
            EAttribute attribute = (EAttribute)object;
            return attribute.getEType().getClassifierID() == 50 || attribute.getEType().getClassifierID() == 39 || attribute.getEType().getClassifierID() == 43 || attribute.getEType().getClassifierID() == 37 || attribute.getEType().getClassifierID() == 31 || attribute.getEType().getClassifierID() == 22;
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        HenshinDebugValue other = (HenshinDebugValue)((Object)obj);
        if (this.actualType == null ? other.actualType != null : !this.actualType.equals(other.actualType)) {
            return false;
        }
        if (!Arrays.equals((Object[])this.childrenVariables, (Object[])other.childrenVariables)) {
            return false;
        }
        return !(this.valueString == null ? other.valueString != null : !this.valueString.equals(other.valueString));
    }

    public int getIndexInDomain() {
        return this.indexInDomain;
    }
}

