/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.interpreter.ui.debug;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.henshin.interpreter.ui.util.ParameterConfig;
import org.eclipse.emf.henshin.model.Parameter;
import org.eclipse.emf.henshin.model.ParameterKind;
import org.eclipse.emf.henshin.model.Unit;

public class ParamUtil {
    public static IFile getIFile(URI uri) {
        try {
            if (uri.isPlatformResource()) {
                Path path = new Path(uri.toPlatformString(false));
                return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
        return null;
    }

    public static List<ParameterConfig> getParameterPreferences(Unit unit) {
        ArrayList<ParameterConfig> result = new ArrayList<ParameterConfig>();
        if (unit != null) {
            for (Parameter param : unit.getParameters()) {
                result.add(new ParameterConfig(param));
            }
        }
        return result;
    }

    public static Object paramConfigToObject(int type, String value) {
        if (type == 1) {
            return null;
        }
        if (type == 3) {
            return Boolean.parseBoolean(value);
        }
        if (type == 4) {
            return Integer.parseInt(value);
        }
        if (type == 6) {
            return Long.parseLong(value);
        }
        if (type == 5) {
            return Float.valueOf(Float.parseFloat(value));
        }
        if (type == 7) {
            return Double.parseDouble(value);
        }
        return value;
    }

    public static void fillParamConfigs(Collection<ParameterConfig> paramConfigs, Map<String, String> paramTypes, Map<String, String> paramValues, List<String> unsetParamNames) {
        for (ParameterConfig paramConfig : paramConfigs) {
            if (paramConfig.getKind() == ParameterKind.IN || paramConfig.getKind() == ParameterKind.INOUT) {
                paramConfig.setUnset(false);
            } else if (paramConfig.getKind() == ParameterKind.OUT || paramConfig.getKind() == ParameterKind.VAR) {
                paramConfig.setUnset(true);
            } else {
                paramConfig.setUnset(unsetParamNames.contains(paramConfig.getName()));
            }
            if (paramConfig.isUnset()) continue;
            int paramType = paramConfig.getType();
            if (paramTypes.get(paramConfig.getName()) != null) {
                paramType = Integer.parseInt(paramTypes.get(paramConfig.getName()));
            }
            Object paramValue = null;
            if (!paramConfig.isUnset()) {
                String stringValue = paramValues.get(paramConfig.getName());
                try {
                    paramValue = stringValue == null ? null : ParamUtil.paramConfigToObject(paramType, stringValue);
                }
                catch (NumberFormatException numberFormatException) {
                    paramValue = null;
                }
            }
            paramConfig.setType(paramType);
            paramConfig.setValue(paramValue);
        }
    }
}

